<?php

class Bootstrap extends Zend_Application_Bootstrap_Bootstrap
{

	protected function _initAutoload() {
   		$autoLoader = Zend_Loader_Autoloader::getInstance();
	
	    $resourceLoader = new Zend_Loader_Autoloader_Resource(array(
	                'basePath' => APPLICATION_PATH,
	                'namespace' => '',
	            ));
	
	    $resourceLoader->addResourceType('validate', 'forms/validate/', 'Application_Form_Validate_');
	    $resourceLoader->addResourceType('decorator', 'forms/decorator/', 'Application_Form_Decorator_');
	    $resourceLoader->addResourceType('subform', 'forms/subform/', 'Application_Form_SubForm_');
	    $resourceLoader->addResourceType('plugin', 'plugins/', 'Application_Plugin_');
	    $resourceLoader->addResourceType('extension','extensions/', 'Application_Extension_');
	
	    $autoLoader->pushAutoloader($resourceLoader);

	
	}

	protected function _initCrashHandler() {
		set_exception_handler(function($e) {
			error_log($e);
			require_once APPLICATION_PATH."/../public/crash.php";
			exit();
		});
	}
	
	protected function _initTranslator() {
		$tl = new Zend_Translate(array(
			"adapter"	=> "array",
			"content"	=> APPLICATION_PATH."/lang/fr.php",
			"locale"	=> "fr"
		));
		Zend_Registry::set('Zend_Translate', $tl);
	}
	
	protected function _initLoggers() {
		$conf = new Zend_Config_Ini(APPLICATION_PATH . '/configs/application.ini', APPLICATION_ENV);
		if( strtoupper(substr(PHP_OS, 0, 3)) === 'WIN' ){
			$logWriter = new Zend_Log_Writer_Stream(APPLICATION_PATH."/log/info");
		} else {
			if(defined('LOG_FACILITY')) $facility=getenv('LOG_FACILITY');
			else $facility=LOG_DAEMON;
			$logWriter = new Zend_Log_Writer_Syslog(array('application' => $conf->resources->db->params->dbname, 'facility' => $facility ));
		}

		if(Zend_Auth::getInstance()->hasIdentity()){
			$auth = Zend_Auth::getInstance()->getStorage()->read()->nomcomplet.
				' ('.Zend_Auth::getInstance()->getStorage()->read()->reference.')';
		}else{
			$auth = "Utilisateur non identifié";
		}
		$format =  $auth.' : %message%' . PHP_EOL;
		$logWriter->setFormatter(new Zend_Log_Formatter_Simple($format));
		$info = new Zend_Log($logWriter);
		$info->setTimestampFormat('d/m/Y H:i:s');
		Zend_Registry::set('logger', $info);
	}
	
	protected function _initAuth() {
		Zend_Registry::set('staticSalt','$ST!<%-u]/#"5>/GTW}k7V2#7G7(QT');
		$auth = Zend_Auth::getInstance();
		$this->bootstrap('db');
		$t = $this->getResource('db');
		$authAdapter = new Zend_Auth_Adapter_DbTable($t);
		$authAdapter->setTableName('vueexpediteur')
					->setIdentityColumn('reference')
					->setCredentialColumn('motdepasse')
					->setCredentialTreatment("MD5('".Zend_Registry::get('staticSalt'). "' || ?)");
		Zend_Registry::set('adapter',$authAdapter);
	}
	
	protected function _initDocType() {
		$this->bootstrap('view');
        $view = $this->getResource('view');
        $view->doctype('XHTML1_TRANSITIONAL');
	}

	protected function _initTitle() {
		$this->bootstrap('view');
		$view = $this->getResource('view');
		$this->view->headTitle('Portail '.Application_Model_ParametresMapper::getParametre('nom').' via LGF Bee');
        $this->view->headTitle()->setSeparator(" | ");
	}
	
}

