<?php

class AjaxController extends Zend_Controller_Action
{
	
    public function init()
    {
        $authAdapter = Zend_Registry::get('adapter');
        $auth = Zend_Auth::getInstance();
        if (!$auth->hasIdentity() && !in_array($this->getRequest()->getActionName(), 
            array('version', 'expediteurs', 'nblvcolis', 'nblvsemaine', 'nblvannee', 'nblvtotal', 'lvpremierederniere') )) {
            return $this->_helper->redirector('index', 'login');
        }
        $this->_helper->layout->disableLayout();
    }

    public function indexAction()
    {
        // action body
    }

    public function adresseAction()
    {
        $mapper = new Application_Model_AdresseMapper();
        $id = $this->getRequest()->getParam('id');
        $vals = $mapper->findFullDetails($id);
        $this->view->json = Zend_Json::encode($vals);
    }

    public function villeAction()
    {
    $param = $this->getRequest()->getParam('codepostal');
    if(!empty($param)){
      $codePostal_pays = explode(":", $param);
      if(count($codePostal_pays) == 2){
        $codePostal = $codePostal_pays[0];
        $pays = $codePostal_pays[1];
        $VilleMapper = new Application_Model_VilleMapper($pays);
        $listeVille = $VilleMapper->findVille($codePostal);
        $this->view->json = Zend_Json::encode($listeVille);
        }
      } 
    }

    public function codepostalAction()
    {
    $param = $this->getRequest()->getParam('ville');
    if(!empty($param)){
      $ville_pays = explode(":", $param);
      if(count($ville_pays) == 2){
        $ville = $ville_pays[0];
        $pays = $ville_pays[1];
        $VilleMapper = new Application_Model_VilleMapper($pays);
        $listeVille = $VilleMapper->findCode($ville);
        $this->view->json = Zend_Json::encode($listeVille);
        }
      }
    }

    public function templateAction()
    {
        $vals = array(
        	"id" => "%id%",
        	"nomcomplet" => "%nomcomplet%",
        	"ligne1"	=> "%ligne1%",
        	"ligne2" => "%ligne2%",
			"ligne3"	=> "%ligne3%",
        	"ligne4" => "%ligne4%",
        	"codepostal" => "%codepostal%",
        	"ville" => "%ville%",
        	"pays" => "%pays%",
        	"libelle" => "%libelle%"
        );
        $this->view->adresse = new Application_Model_ObjAdresse($vals);
    }

    public function adressesAction()
    {
        header("Content-Type: application/json");
    	$mapper = new Application_Model_AdresseMapper();
        $id = $this->getRequest()->getParam('id');
        $adresses = $mapper->fetchAllObj($id);
        $this->view->adresses = $adresses;
    }

    public function versionAction()
    {
        header("Content-Type: application/json");
        // informations propres au code
        list(
        	$revision,
        	$versionBaseAttendue,
        	$versionZendAttendue
        ) = explode(" ",trim(file_get_contents(APPLICATION_PATH."/version")," ".PHP_EOL));
        // informations sur la base correspondante
        $dbconf = Zend_Db_Table_Abstract::getDefaultAdapter()->getConfig();
        $hoteBase = $dbconf['host'];
        $nomBase = $dbconf['dbname'];
        // autres informations utiles
        $numeroClient = Application_Model_ParametresMapper::getParametre("id");
        $versionZendFactuelle = Zend_Version::VERSION;
        $versionBaseFactuelle = Application_Model_ParametresMapper::getParametre("version");
        $chargeUtilisateurs = @Application_Model_ExpediteurMapper::getNbusers();
        $chargeLv = @Application_Model_LVMapper::getNblv();
        $this->view->json = Zend_Json::encode(
        	array(
        		"numeroClient"		=> $numeroClient,
        		"revision" 			=> $revision,
        		"compatibleBase" 	=> $versionBaseAttendue,
        		"compatibleZend" 	=> $versionZendAttendue,
        		"versionBase" 		=> $versionBaseFactuelle,
        		"versionZend" 		=> $versionZendFactuelle,
        		"serveurBase" 		=> $hoteBase,
        		"serveurCode"		=> php_uname('n'),
        		"nomBase"			=> $nomBase,
        		"applicationPath" 	=> APPLICATION_PATH,
        		"applicationEnv" 	=> APPLICATION_ENV,
        		"nblv" 				=> @Application_Model_LVMapper::getNblv(),
        		"nbusers" 			=> @Application_Model_ExpediteurMapper::getNbusers()));
    }
	
// envois des données en plusieurs fois en json
	public function expediteursAction(){
		self::setCORS("lgf.fr");
		$expediteurM = new Application_Model_ExpediteurMapper(false);
		$data = $expediteurM->getAll();
		$this->_helper->json($data);
	}
	
	public function nblvcolisAction(){
		self::setCORS("lgf.fr");
		$lvM = new Application_Model_LVMapper(false);
		$data = $lvM->getNbLvColis();
		$this->_helper->json($data);
	}
	
	public function nblvsemaineAction(){
		self::setCORS("lgf.fr");
		if($this->_hasParam('nbsemaine')) $nbSemaine = $this->_getParam('nbsemaine');
		else $nbSemaine = 4;

		$lvM = new Application_Model_LVMapper(false);
		$data = $lvM->getNbLvSemaine($nbSemaine);
		$this->_helper->json($data);
	}
	
	public function nblvanneeAction(){
		self::setCORS("lgf.fr");
		if($this->_hasParam('annee')) $annee = $this->_getParam('annee');
		else $annee = false;
		
		$lvM = new Application_Model_LVMapper(false);
		$data = $lvM->getNbLvAnnee($annee);
		$this->_helper->json($data);
	}
	
	public function nblvtotalAction(){
		self::setCORS("lgf.fr");
		$lvM = new Application_Model_LVMapper(false);
		$data = $lvM->getNbLvTotal();
		$this->_helper->json($data);
	}
	
	public function lvpremierederniereAction(){
		self::setCORS("lgf.fr");
		$lvM = new Application_Model_LVMapper(false);
		$data = $lvM->getLvPremiereDerniere();
		$this->_helper->json($data);
	}

	private function setCORS($url){
		$shem="http";
		if(array_key_exists("HTTPS",$_SERVER)) $shem .= "s";
		header("Access-Control-Allow-Origin: $shem://$url");
	}
}