<?php

class CarnetController extends Zend_Controller_Action
{
	
    public function init()
    {
    	$authAdapter = Zend_Registry::get('adapter');
    	$auth = Zend_Auth::getInstance();
    	if (!$auth->hasIdentity()) {
    		return $this->_helper->redirector('index','login');
    	}
    	$this->view->headTitle()->prepend('Mes destinataires');
    }

    public function indexAction()
    {
    	$this->view->headTitle()->prepend('Consulter');
    	$carnet = new Application_Model_TiersMapper();
        //$this->view->entries = $carnet->fetchAll();
        $e = new Application_Model_ExpediteurMapper();
        $o = $e->getOptions();
    	$cartes = explode(",",trim($o['nbcartesct'],"{}")); // contient largeur et longueur dans cet ordre
    	
    	/* Filtres lv */
      $champ=null;
      $recherche=null;
    	if ($this->_hasParam('filtrer')) {
    		// rajouter les compléments de titre
    		$g = $this->getRequest()->getParams();
    		$this->view->params = $g;
            switch ($g['filtrer']) {
                case 'les_refs':
                    $champ = "reference";
                    break;
                
                default:
                    $champ = "nomcomplet";
                    break;
            }
    		if (isset($g['contenant'])) {
          $recherche = "%".$g['contenant']."%";
    		} elseif (isset($g['commencant_par'])) {
          $recherche = $g['commencant_par']."%";
    		} elseif (isset($g['finissant_par'])) {
          $recherche = "%".$g['finissant_par'];
    		} else {
                $recherche = "%";
            }
    		$this->view->filtre = true;
    	}
    	$adapter = new Application_Extension_PaginatorAdapter_ContactSelect();
      $adapter->setPattern($champ, $recherche);
        $paginateur = new Zend_Paginator($adapter);
        $paginateur->setCurrentPageNumber($this->_getParam('page'));
        Zend_Paginator::setDefaultScrollingStyle('Sliding');
        Zend_View_Helper_PaginationControl::setDefaultViewPartial('paginateur-simple.phtml');
        $paginateur->setItemCountPerPage($cartes[0] * $cartes[1]);
        $this->view->largeur = $cartes[0];
        $this->view->paginator = $paginateur;
        $this->view->jQNeeded = array('filtres');
    }

    public function ajouttiersAction()
    {
        $this->view->headTitle()->prepend('Ajouter');
        $request = $this->getRequest();
        foreach ($request->getPost() as $var) {
        	if (is_array($var)) {
        		foreach ($var as $avar) {
        			$avar = trim($avar);
        		}
        	} else {
        		$var = trim($var);
        	}
        }
        $form = new Application_Form_Tiers();
 		
        if ($request->isPost()) {
        	
        	if ($request->getParam('submit') == "Annuler") {
        		return $this->_helper->redirector('index');
        	}
            
            $p = $request->getPost();
            $adresse = new Application_Model_Adresse($p['adresse']);
			// problème de nomatch ou de code postal qui ne correspond pas à la ville
			$pays = $p['adresse']['pays'];
        	$vmapper = new Application_Model_VilleMapper($pays);
        	$vals = $vmapper->findVille($p['adresse']['codepostal']);
        	if ($p['adresse']['ville'] == "nomatch" || is_null($vals) || array_search($p['adresse']['ville'], $vals) === false) {
        		switch (true) {
        			case is_null($vals):
        				$form->getSubform('adresse')->getElement('ville')->addError("Aucune ville ne correspond à ce code postal");
        				break;
        			case (count($vals) > 1):
        				$form->getSubform('adresse')->getElement('ville')->addError("Plusieurs villes correspondent au code postal saisi");
        				break;
        			default:
        				$adresse->setVille($vals[0]);
        				break;
        		}
        	}
            
        	$valid = new Application_Form_Validate_Tiers();
            if ($form->isValid($p) && $valid->isValid($form)) {
            	// dans tous les cas, on ajoute également une première adresse
            	$tmapper = new Application_Model_TiersMapper();
            	$amapper = new Application_Model_AdresseMapper();
            	if ($form->getValue('type') == 'Entreprise') {
	                $tiers = new Application_Model_Entreprise($form->getValues());
	                $adresse->setTiers($tmapper->saveEntreprise($tiers));
            	} else if ($form->getValue('type') == 'Particulier') {
            		$tiers = new Application_Model_Particulier($form->getValues());
            		$adresse->setTiers($tmapper->saveParticulier($tiers));
            	}
            	$amapper->save($adresse);
            	return $this->_helper->redirector('index');
            }
            
        }
        $this->view->jQNeeded = array('tiers','adresse');
        $this->view->form = $form;
    }

    public function detailtiersAction()
    {
        $id = $this->getRequest()->getParam('id');
        $mapper = new Application_Model_TiersMapper();
        $type = $mapper->findType($id);
        $method = 'find'.ucfirst($type);
        $obj = 'Application_Model_'.ucfirst($type);
        $mapper->$method($id, $tiers = new $obj());
        $this->view->headTitle()->prepend($tiers->getReference());
        $amapper = new Application_Model_AdresseMapper();
        
        // le tiers est récupéré
        
        // tentative d'inclusion du formulaire de modification dans la page de détail, ergonomie Apple
        
        $form = new Application_Form_Tiers();
        $form->removeSubForm('adresse');
        $form->addElement('hidden','id', array('value' => $this->getRequest()->getParam('id'), 'required' => true));
        $form->removeElement('type');
        $form->addElement('hidden','type', array('value' => ucfirst($type), 'class' => 'lgf-type-toggle hidden'));
        $form->set($tiers->getValues());
        $form->getElement('submit')->setLabel('Modifier');
        $this->view->jQNeeded = array('tiers');
        $this->view->form = $form;
        
        $this->view->adresses = $amapper->fetchAllObj($id);
        $this->view->tiers = $tiers;
        $this->view->id = $id;
        $this->view->type = $type;
    }

    public function modiftiersAction()
    {
    	$request = $this->getRequest();
    	$id = $request->getParam('id');
    	$mapper = new Application_Model_TiersMapper();
    	$type = $mapper->findType($id);
    	$method = 'find'.ucfirst($type);
    	$obj = 'Application_Model_'.ucfirst($type);
    	$mapper->$method($id, $tiers = new $obj());
    	$this->view->headTitle()->prepend($tiers->getReference());
    	
    	// Le tiers est récupéré
    	
        $form    = new Application_Form_Tiers();
        $form->removeSubForm('adresse');
        $form->addElement('hidden','id', array('value' => $this->getRequest()->getParam('id'), 'required' => true));
        $form->removeElement('type');
        $form->addElement('hidden','type', array('value' => ucfirst($type), 'class' => 'lgf-type-toggle hidden'));
        $form->set($tiers->getValues());
        $form->getElement('submit')->setLabel('Modifier');
        
        if ($request->isPost()) { // soumission du formulaire
        	if ($request->getParam('submit') == "Annuler") {
        		return $this->_helper->redirector('index');
        	}
        	foreach ($request->getPost() as $var) {
        		$var = trim($var);
        	}
            if ($form->isValid($this->getRequest()->getPost())) { // formulaire valide
            	if ($form->getValue('type') == 'Entreprise') {
            		$tiers = new Application_Model_Entreprise($this->getRequest()->getPost());
	                if ($mapper->updateEntreprise($tiers)) {
	                	return $this->_helper->redirector('detailtiers','Carnet',null,array('id' => $tiers->getId()));
	                }
            	} else if ($form->getValue('type') == 'Particulier') {
            		$tiers = new Application_Model_Particulier($this->getRequest()->getPost());
            		if ($mapper->updateParticulier($tiers)) {
            			return $this->_helper->redirector('detailtiers','Carnet',null,array('id' => $tiers->getId()));
            		}
            	}
            }
        }
        
        //print_r($this->view->errors);
        
        $this->view->jQNeeded = array('tiers');
        $this->view->id = $id;
        $this->view->form = $form;
    }

    public function supprimetiersAction()
    {
        $id = $this->getRequest()->getParam('id');
        $mapper = new Application_Model_TiersMapper();
        $mapper->delete($id);
        return $this->_helper->redirector('index');
    }

    public function ajoutapAction() {
        $ap = new Zend_Session_Namespace('adresses_ponctuelles');
        if (!isset($ap->ids) || count($ap->ids) == 0) return $this->_helper->redirector('ajouttiers');
        $asmapper = new Application_Model_ASMapper();
        $this->view->headTitle()->prepend("Ajouter une adresse ponctuelle au carnet");

        if (is_null($id = $this->getRequest()->getParam('id'))) { // mode multi
            $adresses = [];
            foreach ($ap->ids as $id) {
                $asmapper->find($id, $adresses[] = new Application_Model_AdresseStatique());
            }
            $this->view->adresses = $adresses;
            $this->_helper->viewRenderer->setScriptAction('ajoutapmulti');
        } else {
            $asmapper->find($id, $adresse = new Application_Model_AdresseStatique());
            $this->view->adresse = $adresse;
            $form = new Application_Form_TiersFromOTF();
            if ($this->getRequest()->isPost()) {
                if ($form->isValid($p = $this->getRequest()->getPost())) { // formulaire valide

                    $amapper = new Application_Model_AdresseMapper();
                    $adresse = new Application_Model_Adresse($p['adresse']);
                    if ($p['nouveau'] == "oui") { // cas d'un nouveau contact

                        $tmapper = new Application_Model_TiersMapper();
                        if ($form->getValue('type') == 'Entreprise') {
                            $tiers = new Application_Model_Entreprise($form->getValues());
                            $adresse->setTiers($tmapper->saveEntreprise($tiers));
                        } else if ($form->getValue('type') == 'Particulier') {
                            $tiers = new Application_Model_Particulier($form->getValues());
                            $adresse->setTiers($tmapper->saveParticulier($tiers));
                        }
                    } else {
                        $adresse->setTiers($p['contact']);
                    }
                    foreach($ap->ids as $i => $idap) {
                        if ($idap == $id) {
                            unset($ap->ids[$i]);
                            break;
                        }
                    }
                    $amapper->save($adresse);
                    return $this->_helper->redirector('index');
                }
            }

            $form->set([
                'raison' => $adresse->nom,
                'prenom' => $adresse->nom,
                'nom' => $adresse->nom,
                'telfixe' => $adresse->telephone
            ]);
            $form->getSubform('adresse')->set([
                'ligne1' => $adresse->ligne1,
                'ligne2' => $adresse->ligne2,
                'ligne3' => $adresse->ligne3,
                'ligne4' => $adresse->ligne4,
                'pays' => $adresse->pays,
                'codepostal' => $adresse->codepostal,
                'ville' => $adresse->ville,
                'tag' => $adresse->tag,
            ]);
            $this->view->form = $form;
            $this->view->jQNeeded = array('tiers','adresse');
        }
    }

    public function ajoutadresseAction()
    {
        $request = $this->getRequest();
        foreach ($request->getPost() as $var) {
        	$var = trim($var);
        }
        $form = new Application_Form_Adresse($request->getParam('id'));
        $tmapper = new Application_Model_TiersMapper();
        $tmapper->find($request->getParam('id'), $tiers = new Application_Model_Tiers());
        $this->view->headTitle()->prepend($tiers->getReference());
        if ($request->isPost()) {
        	if ($request->getParam('submit') == "Annuler") {
        		return $this->_helper->redirector('detailtiers','Carnet',null,array('id' => $request->getParam('id')));
        	}
        	$p = $request->getPost();
        	
        	// problème de nomatch ou de code postal qui ne correspond pas à la ville
			$pays = $p['pays'];
        	$vmapper = new Application_Model_VilleMapper($pays);
        	$vals = $vmapper->findVille($p['codepostal']);
        	if (!isset($p['ville']) || $p['ville'] == "nomatch" || array_search($p['ville'], $vals) === false) {
        		switch (true) {
        			case is_null($vals):
        				$form->getElement('ville')->addError("Aucune ville ne correspond à ce code postal");
        				break;
        			case (count($vals) > 1):
        				$form->getElement('ville')->addError("Plusieurs villes correspondent au code postal saisi");
        				break;
        			default:
        				$p['ville'] = $vals[0];
        				break;
        		}
        	}
            
            $adresse = new Application_Model_Adresse($p);
        	
        	if ($form->isValid($p)) {
        		$mapper = new Application_Model_AdresseMapper();
        		$mapper->save($adresse);
        		return $this->_helper->redirector('detailtiers','Carnet',null,array('id' => $request->getParam('id')));
        	}
        	
        }
        
        $this->view->qui = $tiers->getNomComplet();
        $this->view->jQNeeded = array('adresse');
        $this->view->form = $form;
    }

    public function modifadresseAction()
    {
        $request = $this->getRequest();
    	$id = $request->getParam('id');
        $mapper = new Application_Model_AdresseMapper();
        $mapper->find($id, $adresse = new Application_Model_Adresse());
        
        $form = new Application_Form_Adresse($adresse->getTiers());
        if ($request->isPost()) {
        	$p = $request->getPost();
        	
        	if ($request->getParam('submit') == "Annuler") {
        		return $this->_helper->redirector('detailtiers', 'Carnet', null, array('id' => $adresse->getTiers()));
        	}
        	foreach ($p as $var) {
        		$var = trim($var);
        	}
        	
        	// problème de nomatch ou de code postal qui ne correspond pas à la ville
			$pays = $p['pays'];
        	$vmapper = new Application_Model_VilleMapper($pays);
        	$vals = $vmapper->findVille($p['codepostal']);
        	if ($p['ville'] == "nomatch" || array_search($p['ville'], $vals) === false) {
        		switch (true) {
        			case is_null($vals):
        				$form->getElement('ville')->addError("Aucune ville ne correspond à ce code postal");
        				$adresse->setCodePostal($p['codepostal']);
        				break;
        			case (count($vals) > 1):
        				$form->getElement('ville')->addError("Plusieurs villes correspondent au code postal saisi");
        				$adresse->setCodePostal($p['codepostal']);
        				break;
        			default:
        				$p['ville'] = $vals[0];
	        			break;
        		}
        	}
        	
        	
        	if ($form->isValid($p)) {
        		$adresse = new Application_Model_Adresse($p);
        		$mapper->save($adresse);
        		return $this->_helper->redirector('detailtiers', 'Carnet', null, array('id' => $adresse->getTiers()));
        	}
        	
        	$form->getElement('ville')->addError("");
        	
        }
        
        $form->addElement('hidden', 'id', array('value' => $id, 'required' => true));
        $form->set($adresse->getValues());
        $form->getElement('submit')->setLabel('Modifier');
        
       	$this->view->id = $id;
        $this->view->jQNeeded = array('adresse');
        $this->view->form = $form;
    }

    public function supprimeadresseAction()
    {
        $id = $this->getRequest()->getParam('id');
        $mapper = new Application_Model_AdresseMapper();
        $tiers = $mapper->delete($id);
        return $this->_helper->redirector('detailtiers', 'Carnet', null, array('id' => $tiers));
    }

    public function exporterAction()
    {
    	$format = $this->getRequest()->getParam('en');
        $amapper = new Application_Model_AdresseMapper();
        $exp = $amapper->fetchAllForExport();
        $s = Zend_Auth::getInstance()->getStorage()->read();
        $ref = $s->reference;
        $this->_helper->layout->disableLayout();
        $this->_helper->viewRenderer->setNoRender();
        header('Content-Type: text/csv; charset=utf-8');
        if ($format == 'lgfw') {
        	header('Content-Disposition: attachment; filename="carnet.lgfw.csv"');
	        echo "FORMAT CSV LGFW\r\n3.0\r\nLGFW\r\n0.5.11\r\n".date('d/m/Y H:i:s')."\r\ndestinataire\r\nlibelle;ligne1;ligne2;ligne3;ligne4;codepostal;ville;pays;reference;type;mail;telfixe;telport;fax;nom;prenom;civilite;statut;raisonsociale;siren\r\n";
	        foreach ($exp as $ligne) {
	        	$t = $ligne["t"];
	        	$a = $ligne["a"];
	        	echo $a->getLibelle().";".$a->getLigne1().";".$a->getLigne2().";".$a->getLigne3().";".$a->getLigne4().";".$a->getCodePostal().";".$a->getVille().";fr;".$t->getReference().";".$t->getType().";".$t->getMail().";".$t->getTelFixe().";".$t->getTelPort().";".$t->getFax().";".$t->nom.";".$t->prenom.";".$t->civilite.";".$t->statut.";".$t->raison.";".$t->siren."\r\n";
	        }
        } elseif ($format == 'lgf3') {
        	header('Content-Disposition: attachment; filename="carnet.lgf3.csv"');
        	echo "FORMAT CSV LGF3\r\n2.0\r\nLGFW\r\n0.5.11\r\n".date('d/m/Y H:i:s')."\r\ndestinataire\r\nadresse_cp;adresse_libelle;adresse_ligne1;adresse_ligne2;adresse_ligne3;adresse_ligne4;adresse_ville;expediteur_reference;fax;mail;nom;prenom;raisonsociale;reference;siren;telephone;\r\n";
        	foreach ($exp as $ligne) {
	        	$t = $ligne["t"];
	        	$a = $ligne["a"];
        		echo $a->getCodePostal().";".$a->getLibelle().";".$a->getLigne1().";".$a->getLigne2().";".$a->getLigne3().";".$a->getLigne4().";".$a->getVille().";".$ref.";".$t->getFax().";".$t->getMail().";".$t->nom.";".$t->prenom.";".$t->raison.";".$t->getReference().";".$t->siren.";".$t->getTelFixe().";\r\n";
        	}
        }
        
    }

    public function importerAction()
    {
        $request = $this->getRequest();
    	$form = new Application_Form_Upload();
        if($request->isPost()) {
        	$p = $request->getPost();
        	if (!$form->getElement('carnet')->receive()) {
        		// prévoir quelque chose ici si le fichier n'est pas correctement reçu
        	} else {
        		$logtype = "Zend_Log_Writer_".$p["log"];
	        	$log = new $logtype();
	        	$logger = new Zend_Log($log);
	        	$logger->setTimestampFormat('d/m/Y H:i:s');
	        	$tmapper = new Application_Model_TiersMapper();
	        	$amapper = new Application_Model_AdresseMapper();
	        	$csv = fopen($form->carnet->getFileName(),'r');
	        	list($format) = fgetcsv($csv,0,";");
	        	$logger->debug("format : ".$format);
	        	if ($format != "FORMAT CSV LGFW") $logger->notice("afin de profiter pleinement des fonctionnalités de l'import/export, merci d'utiliser le format CSV LGFW (export v3)");
	        	list($revision) = fgetcsv($csv,0,";");
	        	$logger->debug("révision : ".$revision);
	        	list($generateur) = fgetcsv($csv,0,";");
	        	$logger->debug("générateur : ".$generateur);
	        	list($version) = fgetcsv($csv,0,";");
	        	$logger->debug("version : ".$version);
	        	list($date) = fgetcsv($csv,0,";");
	        	$logger->debug("date de création du fichier : ".$date);
	        	list($objet) = fgetcsv($csv,0,";");
	        	$logger->debug("objet métier : ".$objet);
	        	$entetes = fgetcsv($csv,0,";");
	        	$logger->debug("nombre de champs : ".count($entetes));
	        	$i = 7;
	        	if ($format == "FORMAT CSV LGFW") {
		        	while (false !== ($ligne = fgetcsv($csv,0,";"))) {
		        		$logger->setEventItem("line", $i++);
		        		if (count($entetes) != count($ligne)) {
		        			$logger->err("irrégularité dans le nombre de champs : ".count($ligne)." champs trouvés");
		        		} else {
		        			$props = array_combine($entetes, $ligne);
		        			if (strlen($props['nom']) > 0) { // c'est un particulier
		        				$logger->info("import d'un particulier (référence : ".$props['reference'].")");
		        				if ($tmapper->existsReference($props['reference'])) {
		        					$cas = 4;
		        				} else {
		        					$cas = 0;
		        					$adresse = new Application_Model_Adresse($props);
		        					$adresse->setTiers($tmapper->saveParticulier(new Application_Model_Particulier($props)));
		        					$amapper->save($adresse);
		        				}
		        			} elseif (strlen($props['raisonsociale']) > 0) { // c'est une entreprise
		        				$logger->info("import d'une entreprise (référence : ".$props['reference'].")");
		        				if ($tmapper->existsReference($props['reference'])) {
		        					$cas = 4;
		        				} else {
		        					$cas = 0;
		        					$adresse = new Application_Model_Adresse($props);
		        					$adresse->setTiers($tmapper->saveEntreprise(new Application_Model_Entreprise($props)));
		        					$amapper->save($adresse);
		        				}
		        			} else {
		        				$logger->err("type de contact indéterminé (référence : ".$props['reference'].")");
		        			}
		        			switch ($cas) {
		        				case 0:
		        					$lvl = "info";
		        					$msg = "contact ajouté, adresse ajoutée";
		        					break;
		        				case 4:
		        					$lvl = "warn";
		        					$msg = "référence existante, contact et adresse ignorés";
		        					break;
		        				default:
		        					$lvl = "err";
		        					$msg = "erreur non documentée";
		        					break;
		        			}
		        			$logger->$lvl($msg);
		        		}
		        	}
	        	} elseif ($format == "FORMAT CSV LGF3") {
	        		if ($revision != "2.0") {
	        			$logger->err("L'application ne supporte que la version 2.0 de ce format");
	        		} elseif ($objet != "destinataire") {
	        			$logger->err("L'application ne supporte que l'import d'objets destinataires");
	        		} else {
	        			$entetes_traduits = array_merge(array_combine($entetes, $entetes), array(
	        				"adresse_cp" 		=> "codepostal",
	        				"adresse_libelle" 	=> "libelle",
	        				"adresse_ligne1"	=> "ligne1",
	        				"adresse_ligne2"	=> "ligne2",
							"adresse_ligne3"	=> "ligne3",
	        				"adresse_ligne4"	=> "ligne4",
	        				"adresse_ville"		=> "ville",
	        				"fax"				=> "fax",
	        				"mail"				=> "mail",
	        				"nom"				=> "nom",
	        				"prenom"			=> "prenom",
	        				"raisonsociale"		=> "raisonsociale",
	        				"reference"			=> "reference",
	        				"siren"				=> "siren",
	        				"telephone"			=> "telfixe"
	        			)); // champs non traduits : adresse_siglepays, adresse_zone, expediteur_reference, pass
	        			while (false !== ($ligne = fgetcsv($csv,0,";"))) {
	        				$logger->setEventItem("line", $i++);
	        				if (count($entetes) != count($ligne)) {
	        					$logger->err("irrégularité dans le nombre de champs : ".count($ligne)." champs trouvés");
	        				} else {
	        					$props = array_combine($entetes, $ligne);
	        					$props = array_combine($entetes_traduits, $props);
	        					$props['codepostal'] = str_pad(trim($props['codepostal']), 5, "0", STR_PAD_LEFT);
	        					if (strlen($props['raisonsociale']) > 0) { // c'est une entreprise
	        						$logger->info("import d'une entreprise (référence : ".$props['reference'].")");
		        					if ($tmapper->existsReference($props['reference'])) {
			        					$cas = 4;
			        				} else {
			        					$cas = 0;
			        					$adresse = new Application_Model_Adresse($props);
			        					$adresse->setTiers($tmapper->saveEntreprise(new Application_Model_Entreprise(array_merge($props, array("statut" => "SA")))));
			        					$amapper->save($adresse);
			        				}
	        					} elseif (strlen($props['nom']) > 0) { // c'est un particulier
	        						$logger->info("import d'un particulier (référence : ".$props['reference'].")");
		        					if ($tmapper->existsReference($props['reference'])) {
			        					$cas = 4;
			        				} else {
			        					$cas = 0;
			        					$adresse = new Application_Model_Adresse($props);
			        					$adresse->setTiers($tmapper->saveParticulier(new Application_Model_Particulier(array_merge($props, array("civilite" => "M.")))));
			        					$amapper->save($adresse);
			        				}
	        					} else {
	        						$logger->err("type de contact indéterminé (référence : ".$props['reference'].")");
	        					}
	        					switch ($cas) {
	        						case 0:
	        							$lvl = "info";
	        							$msg = "contact ajouté, adresse ajoutée";
	        							break;
	        						case 4:
	        							$lvl = "warn";
	        							$msg = "référence existante, contact et adresse ignorés";
	        							break;
	        						default:
	        							$lvl = "err";
	        							$msg = "erreur non documentée";
	        							break;
	        					}
	        					$logger->$lvl($msg);
	        				}
	        			}
	        		}
	        	}
	        	if ($p['log'] != "Null") $this->view->log = $log->events;
        	}
        }
        $this->view->headTitle()->prepend('Importer');
        $this->view->form = $form;
    }


}



















