<?php

class LoginController extends Zend_Controller_Action
{

	protected $_authAdapter;
	protected $_auth;
	protected $_logger;
	
	const ADMINPASS = 'rossignol';
	const SALT = '$2a$11$JX332Ri8w73nt3u1Wx7U9Q$';
	const FREQ = 30; // fréquence de régénération de l'otp
    
	public function init()
    {
      header("Cache-Control: no-cache");
      header("Cache-Control: no-store");
    	$this->_initLogger();
    	$this->_authAdapter = Zend_Registry::get('adapter');
        $this->_helper->layout->setLayout('login');
    	$this->_auth = Zend_Auth::getInstance();
    	if ($this->_auth->hasIdentity()) {
    		$auth = Zend_Auth::getInstance()->getStorage()->read()->nomcomplet.
    			' ('.Zend_Auth::getInstance()->getStorage()->read()->reference.')';
    		$this->_auth->clearIdentity();
    		$this->_logger->info($auth." : log out");
    	}
    }

    public function indexAction()
    {
        $request = $this->getRequest();
        $form = new Application_Form_Login();
        
        if ($request->isPost()) {
        	$p = $request->getPost();
        	if ($form->isValid($p)) {
        		
        		if (Application_Model_ParametresMapper::existe($p['user'])) {
        			if (Application_Model_ParametresMapper::estUtilisable($p['user'])) {
			        	$this->_authAdapter->setIdentity($p['user'])->setCredential($p['pass']);
			        	$result = $this->_auth->authenticate($this->_authAdapter);
			        	if ($result->isValid()) {
							Zend_Session::rememberMe();
			        		$this->_auth->getStorage()->write($this->_authAdapter->getResultRowObject());
							Application_Model_ParametresMapper::setDernierClient ($_SERVER['HTTP_USER_AGENT'], $p['user']);
							Application_Model_ParametresMapper::setDerniereIp ($_SERVER['REMOTE_ADDR'], $p['user']);
							$this->_logger->info(Zend_Auth::getInstance()->getStorage()->read()->nomcomplet.
											" (".Zend_Auth::getInstance()->getStorage()->read()->reference.") : Log in");
			        		return $this->_helper->redirector('index','index');
			        	} else {
			        		switch ($result->getCode()) {
			        			case Zend_Auth_Result::FAILURE_IDENTITY_NOT_FOUND :
			        			case Zend_Auth_Result::FAILURE_CREDENTIAL_INVALID :
			        				$this->view->errorMessage = "Mauvais couple utilisateur/mot de passe";
									$this->_logger->err("Bad login/pass (".$p["user"]."/".$p['pass'].") from ".$_SERVER['REMOTE_ADDR']);
			        				break;
			        			default :
			        				break;
			        		}
			        	}
        			} else {
        				$this->view->errorMessage = "Compte désactivé par le transporteur";
						$this->_logger->err("Login refused : user (".$p['user']."/".$p['pass'].") disabled from ".$_SERVER['REMOTE_ADDR']);
        			}
        		} else {
        			$this->view->errorMessage = "Mauvais couple utilisateur/mot de passe";
					$this->_logger->err("Bad login/pass (".$p['user']."/".$p['pass'].") from ".$_SERVER['REMOTE_ADDR']);
        		}
        	}
        }
        $this->view->form = $form;
    }

	public function superAction() {
		$form = new Application_Form_SuperLogin();
		$request = $this->getRequest();
		if ($request->isPost()) {
			$p = $request->getPost();
			if (isset($p['adminpass'])) {
				if( $p['adminpass'] == LoginController::ADMINPASS ){
					$this->_logger->info("[Admin] Log in");
					$form->showUserList();
				}else{
					$this->_logger->err("[Admin] Bad password \"".$p['adminpass']."\" from ".$_SERVER['REMOTE_ADDR']);
				}
			}
			if (isset($p['otpass'])) {
				if(!$this->verifierOtp($p['otpass'])){
					$this->_logger->err("[Admin] Bad otpass \"".$p['otpass']."\" for user \"".$p['user']."\" from ".$_SERVER['REMOTE_ADDR']);
				}else{
					$this->_authAdapter->setIdentityColumn('id')
					->setCredentialColumn('id')
					->setCredentialTreatment('');
					$this->_authAdapter->setIdentity($p['user'])->setCredential($p['user']);
					$result = $this->_auth->authenticate($this->_authAdapter);
					if ($result->isValid()) {
						$this->_auth->getStorage()->write($this->_authAdapter->getResultRowObject());
						$this->_logger->notice("[Admin] Log in as ".Zend_Auth::getInstance()->getStorage()->read()->nomcomplet.
						' ('.Zend_Auth::getInstance()->getStorage()->read()->reference.') from '.$_SERVER['REMOTE_ADDR']);
						return $this->_helper->redirector('index','index');
					} else {
					switch ($result->getCode()) {
						case Zend_Auth_Result::FAILURE_IDENTITY_NOT_FOUND :
							$this->view->errorMessage = "Utilisateur non trouvé";
							$this->_logger->err("[Admin] User \"".$p['user']."\" not found");
							break;
						case Zend_Auth_Result::FAILURE_CREDENTIAL_INVALID :
							$this->view->errorMessage = "Mauvais mot de passe o_O";
							$this->_logger->err("[Admin] Bad password \"".$p['otpass']."\" for user \"".$p['user']."\"");
							break;
						case Zend_Auth_Result::FAILURE_IDENTITY_AMBIGUOUS :
							$this->view->errorMessage = "Identité ambiguë";
							$this->_logger->err("[Admin] User \"".$p['user']."\" identity ambiguous");
							break;
						case Zend_Auth_Result::FAILURE_UNCATEGORIZED :
							$this->view->errorMessage = "Erreur non identifiée";
							$this->_logger->err("[Admin] Uncategorized error");
							break;
						default :
							break;
						}
					}
				}
			}
		}
		$this->view->form = $form;
	}
    
	private function verifierOtp($otp) {
		$now = time();
		$otpprecedent = bin2hex(substr(crypt(($now - LoginController::FREQ) - ($now % LoginController::FREQ), LoginController::SALT), 42, 4));
		$otpactuel = bin2hex(substr(crypt($now - ($now % LoginController::FREQ), LoginController::SALT), 42, 4));
		return $otp === $otpactuel || $otp === $otpprecedent;
	}

	private function _initLogger(){
		$conf = new Zend_Config_Ini(APPLICATION_PATH . '/configs/application.ini', APPLICATION_ENV);
		if( strtoupper(substr(PHP_OS, 0, 3)) === 'WIN' ){
			$logWriter = new Zend_Log_Writer_Stream(APPLICATION_PATH."/log/info");
		} else {
			$facility=LOG_AUTH;
			$logWriter = new Zend_Log_Writer_Syslog(array('application' => $conf->resources->db->params->dbname, 'facility' => $facility ));
		} 

		$format =  '%message%'.PHP_EOL;
		$logWriter->setFormatter(new Zend_Log_Formatter_Simple($format));
		$logger = new Zend_Log($logWriter);
		$logger->setTimestampFormat('d/m/Y H:i:s');
		$this->_logger = $logger;
	}
}

