<?php

class LvController extends Zend_Controller_Action
{
	
    private $LIGNES_PAR_PAGE = 25;

    public function init()
    {
    	$authAdapter = Zend_Registry::get('adapter');
    	$auth = Zend_Auth::getInstance();
    	if (!$auth->hasIdentity()) {
    		return $this->_helper->redirector('index','login');
    	}
    	$this->view->headTitle()->prepend('Mes expéditions');
    }

    public function indexAction()
    {
		$this->view->headTitle()->prepend('En cours');
       	$emapper = new Application_Model_ExpediteurMapper();
       	$o = $emapper->getOptions();

        $adapter = new Application_Extension_PaginatorAdapter_LvSelect("en cours");
        
        $page = $this->_getParam('page');
        $this->filtrerRechercher($adapter);
        $urlHelper = new Zend_View_Helper_Url();
        $this->view->urlAction = $urlHelper->url(array('controller'=>'lv', 'action'=>'index'), 'default', true)."/index";
        $this->prepareRendu($adapter, $o, $page );

    	if ($this->getRequest()->getParam('render') !== null) {
				$lvmapper = new Application_Model_LVMapper();
				$idlv = $this->getRequest()->getParam('render');
				if($lvmapper->aEtiquetteAImprimer($idlv)){
					$this->view->render = $idlv;
				}
    	}
       	$this->view->jQNeeded = array('lv-magiclist', 'lv-magiclist-ie', 'filtres', 'lv-render', 'lv-render-ie');
    }
	
	    public function planifiesAction()
    {
		$this->view->headTitle()->prepend('Planifées');
        $emapper = new Application_Model_ExpediteurMapper();
        $o = $emapper->getOptions();

        $adapter = new Application_Extension_PaginatorAdapter_LvSelect("planifiees");
        
        $page = $this->_getParam('page');
        $this->filtrerRechercher($adapter);
        $urlHelper = new Zend_View_Helper_Url();
        $this->view->urlAction = $urlHelper->url(array('controller'=>'lv', 'action'=>'planifies'), 'default', true);
        $this->prepareRendu($adapter, $o, $page );

    	if ($this->getRequest()->getParam('render') !== null) {
       		$this->view->render = $this->getRequest()->getParam('render');
    	}
        $this->view->planifiees = true;
       	$this->view->jQNeeded = array('lv-magiclist', 'lv-magiclist-ie', 'filtres', 'lv-render', 'lv-render-ie');
    }

    public function ajoutenlevementAction() {
    	$mapperExpediteur = new Application_Model_ExpediteurMapper();
    	$opt = $mapperExpediteur->getOptions(PROPRIETAIRE);
    	$request = $this->getRequest();
    	$adresse_destinataire = $request->getParam('id');
    	$amapper = new Application_Model_AdresseMapper();
    	$amapper->find($adresse_destinataire, $objet = new Application_Model_Adresse());
    	$tmapper = new Application_Model_TiersMapper();
    	// si on trouve son type dans le carnet, ce n'est pas un expéditeur
    	if ($tmapper->findType($objet->getTiers())) return $this->_helper->redirector('detailtiers','carnet',null,array("id" => $objet->getTiers()));
    	$this->view->headTitle()->prepend('Nouvel enlèvement');
    	$amapper->findObj($adresse_destinataire, $adresseDst = new Application_Model_ObjAdresse());
    	$this->view->destinataire = $adresseDst->getLibelle();
    	$form = new Application_Form_LV();
		$form->getElement("destinataire")->setLabel("Expéditeur");
		if ($opt['impressionenlevement'] == 'Dépôt') {
			$form->getElement('submit')->setLabel('Valider et cloturer');
		}
		$form->getSubForm('adresses')->setLegend('Adresses de l\'expéditeur');
		$form->removeElement('idflux');
    	
    	if ($request->isPost()) {
				list($p, $opt, $ftokens) = $this->PreTraitementFormulaire($request, $form);
    		if ($form->isValid($p)) {
                // si tout est bon, on peut invalider le token
                unset($ftokens->current);

    			// 1. enregistrer l'adresse statique du destinataire (cad l'utilisateur)
    			$destinataire = array(
    					'nom'			=> $adresseDst->getNomComplet(),
    					'ligne1'		=> mb_substr($adresseDst->getLigne1(),0,38,'UTF-8'),
    					'ligne2'		=> mb_substr($adresseDst->getLigne2(),0,38,'UTF-8'),
						'ligne3'		=> mb_substr($adresseDst->getLigne3(),0,38,'UTF-8'),
    					'ligne4'		=> mb_substr($adresseDst->getLigne4(),0,38,'UTF-8'),
    					'codepostal'	=> $adresseDst->getCodePostal(),
    					'ville'			=> $adresseDst->getVille(),
    					'telephone'		=> $adresseDst->getTelephone(),
    					'libelle'		=> $adresseDst->getLibelle(),
    					'tag'			=> $adresseDst->getTag(),
    					'pays'			=> $adresseDst->getPays(),
    					'reference'		=> $adresseDst->getReference()
    			);
    			$smapper = new Application_Model_ASMapper();
    			$id_adresse_destinataire = $smapper->save($ae = new Application_Model_AdresseStatique($destinataire));
    	
    	
    			// 2. enregistrer l'adresse statique de l'expéditeur
    			if ($p['adresse'] == 'otf') {
    				$id_adresse_expediteur = $smapper->save($ad = new Application_Model_AdresseStatique(array(
    						'nom'			=> $p['nom'],
    						'ligne1'		=> mb_substr($p['ligne1'],0,38,'UTF-8'),
    						'ligne2'		=> mb_substr($p['ligne2'],0,38,'UTF-8'),
							'ligne3'		=> mb_substr($p['ligne3'],0,38,'UTF-8'),
    						'ligne4'		=> mb_substr($p['ligne4'],0,38,'UTF-8'),
    						'codepostal'	=> $p['codepostal'],
    						'ville'			=> $p['ville'],
    						'telephone'		=> $p['telephone'],
    						'libelle'		=> '',
    						'tag'			=> isset($p['tagadresse'])?$p['tagadresse']:null,
    						'pays'			=> $p['pays'],
    						'reference'		=> ''
    				)));
                    $ap = new Zend_Session_Namespace('adresses_ponctuelles');
                    if (!isset($ap->ids)) $ap->ids = [$id_adresse_expediteur];
                    else $ap->ids[] = $id_adresse_expediteur;
    			} else {
    				$amapper->findObj($p['adresse'], $adresseExp = new Application_Model_ObjAdresse());
    				$expediteur = array(
    						'nom'			=> $adresseExp->getNomComplet(),
    						'ligne1'		=> mb_substr($adresseExp->getLigne1(),0,38,'UTF-8'),
    						'ligne2'		=> mb_substr($adresseExp->getLigne2(),0,38,'UTF-8'),
							'ligne3'		=> mb_substr($adresseExp->getLigne3(),0,38,'UTF-8'),
    						'ligne4'		=> mb_substr($adresseExp->getLigne4(),0,38,'UTF-8'),
    						'codepostal'	=> $adresseExp->getCodePostal(),
    						'ville'			=> $adresseExp->getVille(),
    						'telephone'		=> $adresseExp->getTelephone(),
    						'libelle'		=> $adresseExp->getLibelle(),
    						'tag'			=> $adresseExp->getTag(),
    						'pays'			=> $adresseExp->getPays(),
    						'reference'		=> $adresseExp->getReference()
    				);
    				$id_adresse_expediteur = $smapper->save($ad = new Application_Model_AdresseStatique($expediteur));
    			}
    	
    			// 3. enregistrer le flux statique s'il n'existe pas, le récupérer sinon
    			$lmapper = new Application_Model_LVMapper();
    			$id_flux = $lmapper->getFluxEnlevement($opt['impressionenlevement']);
    	
    	
    			// 4. créer la lv
					// on récupère l'id de la lv
					$id = $this->creerLV($id_adresse_expediteur, $id_adresse_destinataire, $p, $id_flux, $opt['lvplanifiable'], $lmapper);
    	
    	
    			// 5. enregistrer les commandes
    			if (isset($p['commandes'])) {
    				foreach($p['commandes'] as $commande) {
    					$lmapper->saveCommande($commande, $id);
    				}
    			}
    	
    			// 6. enregistrer les conteneurs
    			// Dans le cas d'un enlèvement, si l'impression est au dépot,
    			// la lettre de voiture est cloturée par un trigger dans la BDD.
    			$checkCloturee = false;
    			$this->EnregistrerConteneurs($lmapper, $p, $id, $checkCloturee);

    			// 7. enregistrer les instructions
    			$lmapper->saveInstructions($p['instructions']);
    	
    			if ($opt['impressionenlevement'] == 'Dépôt') {
    				$params = array();
    			} else {
    				$params = array("render" => $id);
    			}
    			if ($opt['impressionenlevement'] == 'Dépôt') {
    				return $this->_helper->redirector('histo','lv',null,$params);
    			} else{
    				return $this->_helper->redirector('index','lv',null,$params);
    			}
    		} else {
    			// rappeler les commandes, l'adresse et les conteneurs
    			if (isset($p['adresse'])) {
    				$form->addElement('hidden','rhi-adresse', array(
    						'value' => $p['adresse'],
    						'class' => "rhi-adresse"
    				));
    			}
    			if (isset($p['commandes'])) {
    				$cform = $form->addSubForm(new Application_Form_SubForm_Extension(), 'rhi-commandes')->getSubForm('rhi-commandes');
    				foreach ($p['commandes'] as $index => $commande) {
    					$cform->addElement('hidden', 'commande'.$index, array(
    							'value' => $commande,
    							'class' => "rhi-commande"
    					));
    				}
    			}
    			if (isset($p['conteneurs']['liste'])) {
    				$clform = $form->addSubForm(new Application_Form_SubForm_Extension(), 'rhi-conteneurs')->getSubForm('rhi-conteneurs');
    				foreach ($p['conteneurs']['liste'] as $key => $conteneur) {
    					$cliform = $clform->addSubForm(new Application_Form_SubForm_Extension(), $key)->getSubForm($key);
    					foreach ($conteneur as $info => $valeur) {
    						$cliform->addElement('hidden', $info, array(
    								'value' => $valeur,
    								'class' => "rhi-conteneur-".$info
    						));
    					}
    				}
    			}
    		}
    	}
    	
    	$this->view->jQNeeded = array('scombo','ecombo','adresse','adresse-ie','lv-commandes','lv-conteneurs', 'lv-saisieadresse','dateclotureprevue', 'jquery.datetimepicker', 'lv-checkValues');
    	$this->view->form = $form;
    }
    
    public function ajoutlvAction()
    {
    	$request = $this->getRequest();
    	$adresse_expediteur = $request->getParam('id');
    	$amapper = new Application_Model_AdresseMapper();
    	$amapper->find($adresse_expediteur, $objet = new Application_Model_Adresse());
    	$tmapper = new Application_Model_TiersMapper();
    	if ($tmapper->findType($objet->getTiers())) return $this->_helper->redirector('detailtiers','carnet',null,array("id" => $objet->getTiers()));
    	$this->view->headTitle()->prepend('Nouvelle expédition');
    	$amapper->findObj($adresse_expediteur, $adresseExp = new Application_Model_ObjAdresse());
    	$this->view->expediteur = $adresseExp->getLibelle();
    	$form = new Application_Form_LV();
    	
    	if ($request->isPost()) {
				list($p, $opt, $ftokens) = $this->PreTraitementFormulaire($request, $form);
			if ($form->isValid($p)) {
                // si tout est bon, on peut invalider le token
                unset($ftokens->current);
				
				// 1. enregistrer l'adresse statique de l'expéditeur
				$expediteur = array(
						'nom'			=> $adresseExp->getNomComplet(),
						'ligne1'		=> substr($adresseExp->getLigne1(),0,38),
    					'ligne2'		=> substr($adresseExp->getLigne2(),0,38),
						'ligne3'		=> substr($adresseExp->getLigne3(),0,38),
    					'ligne4'		=> substr($adresseExp->getLigne4(),0,38),
						'codepostal'	=> $adresseExp->getCodePostal(),
						'ville'			=> $adresseExp->getVille(),
						'telephone'		=> $adresseExp->getTelephone(),
						'libelle'		=> $adresseExp->getLibelle(),
						'tag'			=> $adresseExp->getTag(),
						'pays'			=> $adresseExp->getPays(),
						'reference'		=> $adresseExp->getReference()
				);
				$smapper = new Application_Model_ASMapper();
				$id_adresse_expediteur = $smapper->save($ae = new Application_Model_AdresseStatique($expediteur));
				
				
				// 2. enregistrer l'adresse statique du destinataire
				if ($p['adresse'] == 'otf') {
					$id_adresse_destinataire = $smapper->save($ad = new Application_Model_AdresseStatique(array(
						'nom'			=> $p['nom'],
						'ligne1'		=> substr($p['ligne1'],0,38),
						'ligne2'		=> substr($p['ligne2'],0,38),
						'ligne3'		=> substr($p['ligne3'],0,38),
						'ligne4'		=> substr($p['ligne4'],0,38),
						'codepostal'	=> $p['codepostal'],
						'ville'			=> $p['ville'],
						'telephone'		=> $p['telephone'],
						'libelle'		=> '',
						'tag'			=> isset($p['tagadresse'])?$p['tagadresse']:null,
						'pays'			=> $p['pays'],
						'reference'		=> ''
					)));
                    $ap = new Zend_Session_Namespace('adresses_ponctuelles');
                    if (!isset($ap->ids)) $ap->ids = [$id_adresse_destinataire];
                    else $ap->ids[] = $id_adresse_destinataire;
				} else {
					$amapper->findObj($p['adresse'], $adresseDst = new Application_Model_ObjAdresse());
					$destinataire = array(
							'nom'			=> $adresseDst->getNomComplet(),
							'ligne1'		=> substr($adresseDst->getLigne1(),0,38),
    						'ligne2'		=> substr($adresseDst->getLigne2(),0,38),
							'ligne3'		=> substr($adresseDst->getLigne3(),0,38),
    						'ligne4'		=> substr($adresseDst->getLigne4(),0,38),
							'codepostal'	=> $adresseDst->getCodePostal(),
							'ville'			=> $adresseDst->getVille(),
							'telephone'		=> $adresseDst->getTelephone(),
							'libelle'		=> $adresseDst->getLibelle(),
							'tag'			=> $adresseDst->getTag(),
							'pays'			=> $adresseDst->getPays(),
							'reference'		=> $adresseDst->getReference()
					);
					$id_adresse_destinataire = $smapper->save($ad = new Application_Model_AdresseStatique($destinataire));
				}
				
				// 3. enregistrer le flux statique
				$lmapper = new Application_Model_LVMapper();
				$id_flux = $lmapper->saveFlux($p['idflux']);
				
				
				// 4. créer la lv
				// on récupère l'id de la lv
				$id = $this->creerLV($id_adresse_expediteur, $id_adresse_destinataire, $p, $id_flux, $opt['lvplanifiable'], $lmapper);
				
				
				// 5. enregistrer les commandes
				if (isset($p['commandes'])) {
					foreach($p['commandes'] as $commande) {
						$lmapper->saveCommande($commande, $id);
					}
				}
				
				// 6. enregistrer les conteneurs
				$this->EnregistrerConteneurs($lmapper, $p, $id);

				// 7. enregistrer les instructions
				$lmapper->saveInstructions($p['instructions']);
				
				return $this->_helper->redirector('index','lv',null,array("render" => $id));
			} else {
				// rappeler les commandes, l'adresse et les conteneurs
				if (isset($p['adresse'])) {
					// si c'est une adresse ponctuelle
					if($p['adresse'] == 'otf'){
						$this->view->adressePonctuelle = array(
								"nom" => $p["nom"],
								"telephone" => $p["telephone"],
								"ligne1" => $p["ligne1"],
								"ligne2" => $p["ligne2"],
								"ligne3" => $p["ligne3"],
								"ligne4" => $p["ligne4"],
								"codepostal" => $p["codepostal"],
								"ville" => $p["ville"],
								"pays" => $p["pays"],
								"tagadresse" => $p["tagadresse"]
						);
					}else{
						$form->addElement('hidden','rhi-adresse', array(
								'value' => $p['adresse'],
								'class' => "rhi-adresse"
						));
					}
				}
				if (isset($p['commandes'])) {
					$cform = $form->addSubForm(new Application_Form_SubForm_Extension(), 'rhi-commandes')->getSubForm('rhi-commandes');
					foreach ($p['commandes'] as $index => $commande) {
						$cform->addElement('hidden', 'commande'.$index, array(
							'value' => $commande,
							'class' => "rhi-commande"	
						));
					}
				}
				if (isset($p['conteneurs']['liste'])) {
					$clform = $form->addSubForm(new Application_Form_SubForm_Extension(), 'rhi-conteneurs')->getSubForm('rhi-conteneurs');
					foreach ($p['conteneurs']['liste'] as $key => $conteneur) {
						$cliform = $clform->addSubForm(new Application_Form_SubForm_Extension(), $key)->getSubForm($key);
						foreach ($conteneur as $info => $valeur) {
							$cliform->addElement('hidden', $info, array(
								'value' => $valeur,
								'class' => "rhi-conteneur-".$info
							));
						}
					}
				}
			}
    	}
    	
    	$this->view->jQNeeded = array('scombo','ecombo','adresse','adresse-ie','lv-commandes','lv-conteneurs', 'lv-saisieadresse','dateclotureprevue', 'jquery.datetimepicker', 'lv-checkValues');
    	$this->view->form = $form;
    }
	
	public function detailslvAction() {
    	if (is_null($this->getRequest()->getParam('id'))) {
    		return $this->_helper->redirector('index');
    	}
		$lm = new Application_Model_LVMapper();
    	$this->view->lv = $lm->fetch($this->getRequest()->getParam('id'), true);
    	$this->view->conteneurs = $lm->fetchAllConteneursWithTraces($this->getRequest()->getParam('id'));
		
		if ($this->getRequest()->isPost()) {
    		
    		if (!is_null($this->getRequest()->getParam('retour'))) return $this->_helper->redirector('histo');
		}
		
	}

    public function modifielvAction() {
    	if (is_null($this->getRequest()->getParam('id'))) {
    		return $this->_helper->redirector('index');
    	}
    	$lm = new Application_Model_LVMapper();
    	$this->view->lv = $lm->fetch($this->getRequest()->getParam('id'));
    	$this->view->conteneurs = $lm->fetchAllConteneurs($this->getRequest()->getParam('id'));
    	$this->view->commandes = $lm->fetchAllCommandes($this->getRequest()->getParam('id'));
        if ($this->view->lv->flux != "Enlèvement" && strpos($this->view->lv->flux, 'Import') !== 0) {
            $lesFlux = $lm->fetchAllFlux();
            
            foreach ($lesFlux as $i => $f) {
                if ($f['libelle'] == "Enlèvement" || strpos($f['libelle'], "Import") === 0 || $f['libelle'] == $this->view->lv->flux) unset($lesFlux[$i]);
            }
            if (count($lesFlux)) // si au moins un autre flux
                $this->view->flux = $lesFlux;
        }
		
		$m = new Application_Model_ExpediteurMapper();
		$o = $m->getOptions();
		
    	if ($this->getRequest()->isPost()) {
    		
    		if (!is_null($this->getRequest()->getParam('annul'))) return $this->_helper->redirector('index');
    		
    		if (!is_null($this->getRequest()->getParam('flux')) && $this->getRequest()->getParam('flux') != "original")
                    $lm->updateFlux($this->getRequest()->getParam('flux'), $this->getRequest()->getParam('id'));

    		$conteneurs = $this->getRequest()->getParam('cont');
    		$commandes = $this->getRequest()->getParam('commandes');
			
    		
    		if (count($conteneurs) == count($this->view->conteneurs)) { // seul cas (pour l'instant) de formulaire non valide
    			$this->view->erreur = "Impossible de retirer tous les conteneurs d'une expédition";
    		} else {
    			// suppression de conteneurs, si nécessaire
                if (is_array($conteneurs)) {
    	    		foreach ($conteneurs as $id => $value) {
    	    			$lm->deleteConteneur($id);
    	    		}
	    		}

	    		$aconserver = array();
	    		$ainserer = array();
                if (is_array($commandes)) {
    	    		foreach ($commandes as $id => $value) {
    	    			if (strpos($id, 'e') !== false) { // existant
    	    				$aconserver[] = substr($id,1);
    	    			} else { // nouveau
    	    				$ainserer[] = $value;
    	    			}
    	    		}
                }
	    		if (count($aconserver) < count($this->view->commandes)) $lm->deleteCommandeDelta($aconserver, $this->getRequest()->getParam('id'));
	    		
	    		foreach ($ainserer as $value) {
	    			$lm->saveCommande($value, $this->getRequest()->getParam('id'));
	    		}
				
				if ($o['lvplanifiable']) {
					$dateclotureprevue = $this->getRequest()->getParam('dateclotureprevue');
					$lm->changeDateCloturePrevue($this->getRequest()->getParam('id'), $dateclotureprevue);
				}			
	    		
    			return $this->_helper->redirector('index');
    		}
    	}
    	$this->view->jQNeeded = array('lv-commandes','dateclotureprevue', 'jquery.datetimepicker');
    }
    
    public function saisiradresseAction() {
    	$this->view->jQNeeded = array('adresse', 'adresse-ie');
        $this->_helper->layout->setLayout('nomenu');
        $form = new Application_Form_AdresseOTF();
        $request = $this->getRequest();
        if ($request->isPost()) {
        	$p = $request->getPost();

            // problème de nomatch ou de code postal qui ne correspond pas à la ville
            $pays = $p['pays'];
            $vmapper = new Application_Model_VilleMapper($pays);
            $vals = $vmapper->findVille($p['codepostal']);
            if (!isset($p['ville']) || $p['ville'] == "nomatch" || array_search($p['ville'], $vals) === false) {
                switch (true) {
                    case is_null($vals):
                        $form->getElement('ville')->addError("Aucune ville ne correspond à ce code postal");
                        break;
                    case (count($vals) > 1):
                        $form->getElement('ville')->addError("Plusieurs villes correspondent au code postal saisi");
                        break;
                    default:
                        $p['ville'] = $vals[0];
                        break;
                }
            }

        	if ($p['submit'] == "Annuler" || $form->isValid($p)) {
    			$this->view->jQNeeded[] = 'lv-saisieadresse';
        	}
        }
        
        $this->view->form = $form;
    }
    
    public function ielabelsAction() {
    	$request = $this->getRequest();
    	if ($request->isPost()) {
        	$p = $request->getPost();
        	$ids = $p['ids'];
        } else {
        	$ids = array($request->getParam('id'));
        }
        $this->_helper->layout->disableLayout();
        $this->view->ids = $ids;
    }
    
    public function rendernewlabelsAction() {
    	$this->_forward("renderlabels", null, null, array("newer" => true));
    }
    
    public function renderlabelsAction()
    {
    	$request = $this->getRequest();
        if (count($request->getParams()) == 0) {
        	return $this->_helper->redirector('index');
        }
        if ($request->isPost()) {
        	$p = $request->getPost();
        	$ids = $p['ids'];
        } else {
        	$ids = array($request->getParam('id'));
        }
        if(empty($ids[0])){
          // pas d'id de lv
          $this->_helper->layout->setLayout('nomenu');
          $this->view->titre="Impossible d'imprimer l'étiquette.";
          $this->view->message="Pas d'id de LV fourni.";
          return;
        }
        $m = new Application_Model_ExpediteurMapper();
        $o = $m->getOptions();
        $lmapper = new Application_Model_LVMapper();
        $smapper = new Application_Model_ASMapper();
        $pdf = new Zend_Pdf();
        foreach ($ids as $id) { // pour chaque lv
        	$newer = $request->getParam("newer");
        	$position = 1;
        	$decalage = 0;
        	if (!is_null($newer)) $decalage = $lmapper->fetchDecalageConteneur($id);
        	$position += $decalage;
	        $conteneurs = $lmapper->fetchAllConteneurs($id, $newer);
          // si find retourne false, c'est qu'il n'y à pas de résultats
          if( !$lmapper->find($id, $lv = new Application_Model_LV()) ){
            // la lv n'existe pas ou est cloturé
            $this->_helper->layout->setLayout('nomenu');
            $this->view->titre="Impossible d'imprimer l'étiquette.";
            $this->view->message="Car la LV n'existe pas ou est cloturé.";
            return;
          };
          $etat = $this->pickEtat($lv->getFlux(), $o['etatetq'], "etq");
          if(!file_exists($etat)){
            // pas de modéle d'étiquette
            $this->_helper->layout->setLayout('nomenu');
            $this->view->titre="Impossible d'imprimer l'étiquette.";
            $this->view->message="Le fichier modèle <strong>".
                pathinfo($etat)['basename']."</strong> n'existe pas";
            return;
          };
          // on créer le pdf pour l'étiquette
          header("Content-Disposition: inline; filename=\"".Zend_Date::now()->get('YYYYMMdd_HHmmss').".pdf\"");
          if ($this->_hasParam("debug")) {
            header("Content-type: text/html");
          } else {
            header("Content-type: application/pdf");
          }
          $this->_helper->layout->disableLayout();
          $this->_helper->viewRenderer->setNoRender();

	        $smapper->find($lv->getExpediteur(), $expediteur = new Application_Model_AdresseStatique());
	        $smapper->find($lv->getDestinataire(), $destinataire = new Application_Model_AdresseStatique());
	        $parser = new Application_Plugin_Pdf_XMLParser($this->pickEtat($lv->getFlux(), $o['etatetq'], "etq"));
	        foreach ($conteneurs as $conteneur) {
	        	$parser->exec($pdf, array(
	        			"lv" => $lv,
	        			"default" => $conteneur,
	        			"expediteur" => $expediteur,
	        			"destinataire" => $destinataire,
	        			"adds" => array(
	        				"nbcolis" => count($conteneurs) + $decalage,
	        				"nom_trans" => Application_Model_ParametresMapper::getParametre('nom'),
	        				"tel_trans" => Application_Model_ParametresMapper::getParametre('telephone'),
	        				"position" 		=> $position++,
	        				"departement" 	=> substr($destinataire->codepostal, 0, 2)
	        			)
	        	));
	        }
	        $lmapper->imprimeConteneurs($id);
        }
        echo $pdf->render();
    }

    public function supprimelvAction()
    {
    	$request = $this->getRequest();
    	if ($request->isPost()) {
    		$p = $request->getPost();
    		$ids = $p['ids'];
    	} else {
    		$ids = array($request->getParam('id'));
    	}
        $mapper = new Application_Model_LVMapper();
    	foreach ($ids as $id) {
        	$mapper->delete($id);
    	}
        return $this->_helper->redirector('index');
    }

    public function cloturelvAction()
    {
    	$request = $this->getRequest();
    	if ($request->isPost()) {
    		$p = $request->getPost();
    		$ids = $p['ids'];
    	} else {
    		$ids = array($request->getParam('id'));
    	}
        $lvmapper = new Application_Model_LVMapper();
		$idlvs = $lvmapper->filtreLvPrevue($ids);
		if($idlvs !="") {
			$lvmapper->cloture($idlvs);
			$this->_forward('journallv');
		}
		else $this->_forward('index');
    }

    public function renderlvAction()
    {
    	$request = $this->getRequest();
        if (count($request->getParams()) == 0) {
        	return $this->_helper->redirector('index');
        }
        if ($request->isPost()) {
        	$p = $request->getPost();
        	$ids = $p['ids'];
        } else {
        	$ids = array($request->getParam('id'));
        }
        $m = new Application_Model_ExpediteurMapper();
        $o = $m->getOptions();
        $lmapper = new Application_Model_LVMapper();
        $pdf = new Zend_Pdf();
        foreach ($ids as $id) {
	        $lmapper->findObj($id, $lv = new Application_Model_ObjLV());
	        $etat = $this->pickEtat($lv->getFlux(), $o['etatlv'], "lv");
          if(!file_exists($etat)){
            // pas de modéle de LV
            $this->_helper->layout->setLayout('nomenu');
            $this->view->titre="Impossible d'imprimer la lettre de voiture.";
            $this->view->message="Le fichier modèle <strong>".
                pathinfo($etat)['basename']."</strong> n'existe pas";
            return;
          };
	        $parser = new Application_Plugin_Pdf_XMLParser($etat);
	        
	        $parser->exec($pdf, array(
	        		"default" => $lv,
	        		"lv" => $lv,
	        		"expediteur" => $lv->getExpediteur(),
	        		"destinataire" => $lv->getDestinataire(),
	        		"adds" => array(
	        				"nom_trans" 	=> Application_Model_ParametresMapper::getParametre('nom'),
	        				"tel_trans" 	=> Application_Extension_StaticLib::formaterTelephone(Application_Model_ParametresMapper::getParametre('telephone')),
	        				"departement" 	=> substr($lv->getDestinataire()->codepostal, 0, 2)
	        		)
	        ));
        }
        header("Content-Disposition: inline; filename=\"".Zend_Date::now()->get('YYYYMMdd_HHmmss').".pdf\"");
        if ($this->_hasParam("debug")) {
          header("Content-type: text/html");
        } else {
          header("Content-type: application/pdf");
        }
        $this->_helper->layout->disableLayout();
        $this->_helper->viewRenderer->setNoRender();
        $content = $pdf->render();
        echo $content;
    }
	
	// Fonction suppression de lv cloturees
	public function demandesuppressionAction() {
		$request = $this->getRequest();
    	$this->view->headTitle()->prepend("Motif de suppression :");
       
        $ias = new Zend_Session_Namespace('ids_a_supprimer');

    	if ($request->isPost()) {
    		$p = $request->getPost();
			if (isset($p['ids'])) {
				$ias->ids = $p['ids'];
			}
    	} else {
			$ias->ids = [$request->getParam('id')];
    	}
        $lvmapper = new Application_Model_LVMapper();
		
		if ($request->isPost()) {
            $motif = $request->getParam('motif');
    		if (!is_null($request->getParam('envoyer')) && !empty($motif)) {
				$lvmapper->demandesuppression($ias->ids, $motif);
                unset($ias->ids);
				return $this->_helper->redirector('histo');
			}
			else {
				if (!is_null($request->getParam('retour'))) 
				return $this->_helper->redirector('histo');
			}
		}
		if(isset($ias->ids[0])){
			$listeLv = $lvmapper->getNumeroLvNbColisDestByLvIds($ias->ids);
			if($listeLv == false){
				return $this->_helper->redirector('histo');
			}
			$this->view->listeLv = $listeLv;
			$this->view->jQNeeded = array('demandeSuppression');
		}else{
			return $this->_helper->redirector('histo');
		}
	}

    public function rendercontroleAction() {
    	$request = $this->getRequest();
    	if (count($request->getParams()) == 0) {
    		return $this->_helper->redirector('index');
    	}

    	$lmapper = new Application_Model_LVMapper();
    	if ($request->isPost()) {
    		$p = $request->getPost();
    		$ids = $p['ids'];
    	} else {
    		$ids = $lmapper->getIdlvFromJournal($request->getParam('id'));
    	}
    	$flux = $lmapper->ordonner($ids); // assoc, chaque flux est une clé dont la valeur est un assoc {"impression" => locale ou depot, "lv" => array(ids)}
    	$pdf = new Zend_Pdf();
        $m = new Application_Model_ExpediteurMapper();
        $o = $m->getOptions();
        $etat = $this->pickEtat(null, $o['etatlv'], "ctr");
        if(!file_exists($etat)){
          // pas de modéle de controle
          $this->_helper->layout->setLayout('nomenu');
          $this->view->titre="Impossible d'imprimer le controle.";
          $this->view->message="Le fichier modèle <strong>".
              pathinfo($etat)['basename'].
              "</strong> n'existe pas";
          return;
        };
    	$parser = new Application_Plugin_Pdf_XMLParser($etat);
    	$numCont = "";
    	foreach ($flux as $nom => $lot) {
    		foreach ($lot["lv"] as $id) {
    			$lmapper->findObj($id, $lv = new Application_Model_ObjLV());
    			$conteneurs = $lmapper->fetchAllConteneurs($id);
    			foreach ($conteneurs as $c) {
    				$numCont .= $c->getNumero();
    			}
    		}
    	}
    	$parser->exec($pdf, array(
    			"adds" => array(
    				"numerosconteneur" => new Application_Plugin_Splitter($this->compresserNumeros($numCont), chr(0), 382), // nombre de caractères dans un QRCode de version 20
    				"numeroramasse" => $request->isPost() ? "[en cours]" : $request->getParam('id'),
    			)
    		)
    	);
      header("Content-Disposition: inline; filename=\"".Zend_Date::now()->get('YYYYMMdd_HHmmss').".pdf\"");
      if ($this->_hasParam("debug")) {
        header("Content-type: text/html");
      } else {
        header("Content-type: application/pdf");
      }
      $this->_helper->layout->disableLayout();
      $this->_helper->viewRenderer->setNoRender();
    	$content = $pdf->render();
    	echo $content;
    }
    
    public function renderjournalAction() {
    	$request = $this->getRequest();
    	if (count($request->getParams()) == 0) {
    		return $this->_helper->redirector('index');
    	}
		$configTrans = Zend_Controller_Front::getInstance()->getParam('bootstrap');
		$transporteur = $configTrans->getOption('settings_trans');
		
    	$lmapper = new Application_Model_LVMapper();
    	$ids = $lmapper->getIdlvFromJournal($request->getParam('id'));
    	$idjournal = $request->getParam('id');
    	$flux = $lmapper->ordonner($ids); // assoc, chaque flux est une clé dont la valeur est un assoc {"impression" => locale ou depot, "lv" => array(ids)}
    	$pdf = new Zend_Pdf();
    	$idtrans = Application_Model_ParametresMapper::getParametre('id');
		$proprietaire_name = $lmapper->getExpeNomComplet($ids);
		$m = new Application_Model_ExpediteurMapper();
        $o = $m->getOptions();
		if ($o['etatjn'] == 0) {
			$etat = APPLICATION_PATH."/layouts/etats/jn".$idtrans.".xml";
		} else {
			$etat = APPLICATION_PATH."/layouts/etats/jn".$idtrans."-".$o['etatjn'].".xml";
		}
		if(!file_exists($etat)){
			// pas de modéle de journal
			$this->_helper->layout->setLayout('nomenu');
			$this->view->titre="Impossible d'imprimer le journal.";
			$this->view->message="Le fichier modèle <strong>".
					pathinfo($etat)['basename']."</strong> n'existe pas";
			return;
		};
		$parser = new Application_Plugin_Pdf_XMLParser($etat);
		
    	$nbCont = $poids = 0;
    	foreach ($flux as $nom => $lot) {
    		$nbCont = $poids = 0;
    		foreach ($lot["lv"] as $id) {
    			$lmapper->findObj($id, $lv = new Application_Model_ObjLV());
    			$parser->exec($pdf, array(
    					"default" => $lv,
    					"lv" => $lv,
    					"expediteur" => $lv->getExpediteur(),
    					"destinataire" => $lv->getDestinataire(),
    					"adds" => array(
								"proprietaire" => $proprietaire_name,
    							"nom_trans" 	=> $transporteur['nomcomplet'],
							    "ligne1_trans"	=> $transporteur['ligne1'],
								"ligne2_trans"	=> $transporteur['ligne2'],
								"codepostal_trans"	=> $transporteur['codepostal'],
								"ville_trans"	=> $transporteur['ville'],
    							"tel_trans" 	=> $transporteur['tel'],
    							"departement" 	=> substr($lv->getDestinataire()->codepostal, 0, 2),
    							"nbLv"			=> count($ids),
    							"journal"		=> $idjournal
    					)
    			));
    			$nbCont += $lv->getNbColis();
    			$poids += $lv->getPoidsTotal();
    		}	
    		$parser->exec($pdf, array(
    				"adds" => array(
    						"Counter"	=> count($lot["lv"]),
    						"NbCont"	=> $nbCont,
    						"Poids"		=> number_format($poids/1000, 3, ',', ' '),
    						"flux"		=> $nom,
							"proprietaire" => $proprietaire_name,
							"nom_trans" 	=> $transporteur['nomcomplet'],
							"ligne1_trans"	=> $transporteur['ligne1'],
							"ligne2_trans"	=> $transporteur['ligne2'],
							"codepostal_trans"	=> $transporteur['codepostal'],
							"ville_trans"	=> $transporteur['ville'],
							"tel_trans" 	=> $transporteur['tel'],
							"departement" 	=> substr($lv->getDestinataire()->codepostal, 0, 2),
							"nbLv"			=> count($ids),
							"journal"		=> $idjournal
					)
    		), "Bande1");
    	}
      header("Content-Disposition: inline; filename=\"".Zend_Date::now()->get('YYYYMMdd_HHmmss').".pdf\"");
      if ($this->_hasParam("debug")) {
        header("Content-type: text/html");
      } else {
        header("Content-type: application/pdf");
      }
      $this->_helper->layout->disableLayout();
      $this->_helper->viewRenderer->setNoRender();
    	$content = $pdf->render();
    	echo $content;
    }
    
    public function journallvAction()
    {
    	$request = $this->getRequest();
    	if (count($request->getParams()) == 0) {
    		return $this->_helper->redirector('index');
    	}
		
		$configTrans = Zend_Controller_Front::getInstance()->getParam('bootstrap');
		$transporteur = $configTrans->getOption('settings_trans');
		
    	if ($request->isPost()) {
    		$p = $request->getPost();
    		$ids = $p['ids'];
    	} else {
    		$ids = array($request->getParam('id'));
    	}
    	$m = new Application_Model_ExpediteurMapper();
    	$o = $m->getOptions();
    	$lmapper = new Application_Model_LVMapper();
		$ids = $lmapper->filtreLvPrevue($ids);
		if($ids == "") return $this->_helper->redirector('index');
		$ids = explode(',', $ids);
    	$flux = $lmapper->ordonner($ids); // assoc, chaque flux est une clé dont la valeur est un assoc {"impression" => locale ou depot, "lv" => array(ids)}
    	$pdf = new Zend_Pdf();
    	$idtrans = Application_Model_ParametresMapper::getParametre('id');
		$proprietaire_name = $lmapper->getExpeNomComplet($ids);
    	foreach ($flux as $nom => $lot) { 
    		$nbCont = $poids = 0;
    		if ($lot["impression"] == "Locale") {
    			$etat = $this->pickEtat($nom, $o['etatlv'], "lv");
    			$idjournal = "";
    		} elseif ($lot["impression"] == "Dépôt") {
    			$etat = APPLICATION_PATH."/layouts/etats/jn".$idtrans.".xml";
    			$idjournal = $lmapper->getJournal($lot["lv"][0]);
    		}
    		if(!file_exists($etat)){
    			// pas de modéle de journal
    			$this->_helper->layout->setLayout('nomenu');
    			$this->view->titre="Impossible d'imprimer le journal.";
    			$this->view->message="Le fichier modèle <strong>".
    					pathinfo($etat)['basename']."</strong> n'existe pas";
    			return;
    		};
    		$parser = new Application_Plugin_Pdf_XMLParser($etat);
    		if ($lot["impression"] == "Locale") {
    			$parser->newPage($pdf);
    		}
    		foreach ($lot["lv"] as $id) {
    			$lmapper->findObj($id, $lv = new Application_Model_ObjLV());
	    		$parser->exec($pdf, array(
	    				"default" => $lv,
	    				"lv" => $lv,
	    				"expediteur" => $lv->getExpediteur(),
	    				"destinataire" => $lv->getDestinataire(),
	    				"adds" => array(
								"proprietaire" => $proprietaire_name,
    							"nom_trans" 	=> $transporteur['nomcomplet'],
							    "ligne1_trans"	=> $transporteur['ligne1'],
								"ligne2_trans"	=> $transporteur['ligne2'],
								"codepostal_trans"	=> $transporteur['codepostal'],
								"ville_trans"	=> $transporteur['ville'],
    							"tel_trans" 	=> $transporteur['tel'],
    							"departement" 	=> substr($lv->getDestinataire()->codepostal, 0, 2),
    							"nbLv"			=> count($ids),
    							"journal"		=> $idjournal
    					)
	    		));
	    		$nbCont += $lv->getNbColis();
	    		$poids += $lv->getPoidsTotal();
    		}
    		if ($lot["impression"] == "Dépôt") {
    			$parser->exec($pdf, array(
    					"adds" => array(
    							"Counter"	=> count($lot["lv"]),
    							"NbCont"	=> $nbCont,
    							"Poids"		=> number_format($poids/1000, 3, ',', ' '),
    							"flux"		=> $nom,
								"proprietaire" => $proprietaire_name,
								"nom_trans" 	=> $transporteur['nomcomplet'],
								"ligne1_trans"	=> $transporteur['ligne1'],
								"ligne2_trans"	=> $transporteur['ligne2'],
								"codepostal_trans"	=> $transporteur['codepostal'],
								"ville_trans"	=> $transporteur['ville'],
								"tel_trans" 	=> $transporteur['tel'],
								"departement" 	=> substr($lv->getDestinataire()->codepostal, 0, 2),
								"nbLv"			=> count($ids),
								"journal"		=> $idjournal
    					)
    			), "Bande1");
    		}
    	}
    	header("Content-Disposition: inline; filename=\"".Zend_Date::now()->get('YYYYMMdd_HHmmss').".pdf\"");
    	if ($this->_hasParam("debug")) {
    		header("Content-type: text/html");
    	} else {
    		header("Content-type: application/pdf");
    	}
    	$this->_helper->layout->disableLayout();
    	$this->_helper->viewRenderer->setNoRender();
    	$content = $pdf->render();
    	echo $content;
    }
    
    /**
     * Cette fonction détermine l'état à utiliser en fonction du flux et de la classe de l'utilisateur.
     * La priorisation fonctionne ainsi :
     * 1. Un état spécifique au flux et à la classe
     * 2. Un état spécifique au flux
     * 3. Un état spécifique à la classe
     * 4. L'état générique
     * Si la classe vaut 0, on recherche uniquement 2 et 4 avec la même priorisation
     * @param string $flux
     * @param string $classe
     * @param string $type
     */
    private function pickEtat($flux, $classe, $type = "lv") {
    	$idtrans = Application_Model_ParametresMapper::getParametre('id');
    	$etat = '';
    	if ($classe != 0) {
    		if (file_exists($etat = APPLICATION_PATH."/layouts/etats/".$type.$idtrans."-".$flux."-".$classe.".xml"));
    		elseif (file_exists($etat = APPLICATION_PATH."/layouts/etats/".$type.$idtrans."-".$flux.".xml"));
    		elseif (file_exists($etat = APPLICATION_PATH."/layouts/etats/".$type.$idtrans."-".$classe.".xml"));
    		else $etat = APPLICATION_PATH."/layouts/etats/".$type.$idtrans.".xml";
    	} else {
    		if (file_exists($etat = APPLICATION_PATH."/layouts/etats/".$type.$idtrans."-".$flux.".xml"));
    		else $etat = APPLICATION_PATH."/layouts/etats/".$type.$idtrans.".xml";
    	}
    	return $etat;
    }
    
    public function journauxAction() {
    	$this->view->headTitle()->prepend('Journaux');
    	$lmapper = new Application_Model_LVMapper();
    	$this->view->journaux = $lmapper->getJournaux();
    } 
    
    public function histoAction()
    {
    	$this->view->headTitle()->prepend('Historique');
    	$lmapper = new Application_Model_LVMapper();
    	$this->view->destinataires = $lmapper->fetchAllDestinataires();
    	
    	/* Recherche de la date de la plus vieille lv */
    	$this->view->older = preg_replace("#^(\d{4})-(\d{1,2})-(\d{1,2})$#", "$3/$2/$1", $lmapper->getOldest());
    	
    	$e = new Application_Model_ExpediteurMapper();
    	$o = $e->getOptions();
    	
    	/* Nouveau pagi */
    	$adapter = new Application_Extension_PaginatorAdapter_LvSelect("historique");
    	
    	$page = $this->_getParam('page');
        $this->filtrerRechercher($adapter);
        $urlHelper = new Zend_View_Helper_Url();
        $this->view->urlAction = $urlHelper->url(array('controller'=>'lv', 'action'=>'histo'), 'default', true);
        $this->prepareRendu($adapter, $o, $page );
        
        $this->view->jQNeeded = array('lv-magiclist','filtres');
    }
    
	public function exporterAction() {
		$filters = array();
		$nom = "Historique expéditions ".Application_Model_ParametresMapper::getParametre('nom');
		list(
			$versionBaseAttendue,
		) = explode(" ",trim(file_get_contents(APPLICATION_PATH."/version")," ".PHP_EOL));
		try{
			register_shutdown_function(function(){$this->shutdown();});
			$adapter = new Application_Extension_PaginatorAdapter_LvSelect("historique");
			$this->filtrerRechercher($adapter);
			$this->lvs = $adapter->getItems();
			$this->csvContent = "FORMAT CSV LGFW\r\n".
					"3.0\r\n".
					"LGFBee\r\n".
					$versionBaseAttendue."\r\n".
					date('d/m/Y')."\r\n".
					"lv\r\n".
					"expediteur_reference;".
					"expediteur_nom;".
					"expediteur_telephone;".
					"expediteur_libelleadresse;".
					"expediteur_ligne1;".
					"expediteur_ligne2;".
					"expediteur_ligne3;".
					"expediteur_ligne4;".
					"expediteur_codepostal;".
					"expediteur_ville;".
					"expediteur_pays;".
					"destinataire_reference;".
					"destinataire_nom;".
					"destinataire_telephone;".
					"destinataire_libelleadresse;".
					"destinataire_ligne1;".
					"destinataire_ligne2;".
					"destinataire_ligne3;".
					"destinataire_ligne4;".
					"destinataire_codepostal;".
					"destinataire_ville;".
					"destinataire_pays;".
					"numero;".
					"portdu;".
					"valeurdeclaree;".
					"contreremboursement_declare;".
					"contreremboursement_corrige;".
					"flux;".
					"tournée;".
					"marchandise;".
					"nbcolis;".
					"identifiantcommande;".
					"poids_declare;".
					"poids_corrige;".
					"poid_final;".
					"date_creation;".
					"date_cloture;".
					"suivi_date;".
					"suivi_type;".
					"suivi_libelle;".
					"facturation_refs;".
					"facturation_puht\r\n";
			while($l = array_shift($this->lvs)) {
				$this->csvContent .= $l->getExpediteur()->getReference().";".
						$l->getExpediteur()->getNom().";".
						$l->getExpediteur()->getTelephone().";".
						$l->getExpediteur()->getLibelle().";".
						$l->getExpediteur()->getLigne1().";".
						$l->getExpediteur()->getLigne2().";".
						$l->getExpediteur()->getLigne3().";".
						$l->getExpediteur()->getLigne4().";".
						$l->getExpediteur()->getCodePostal().";".
						$l->getExpediteur()->getVille().";".
						$l->getExpediteur()->getPays().";".
						$l->getDestinataire()->getReference().";".
						$l->getDestinataire()->getNom().";".
						$l->getDestinataire()->getTelephone().";".
						$l->getDestinataire()->getLibelle().";".
						$l->getDestinataire()->getLigne1().";".
						$l->getDestinataire()->getLigne2().";".
						$l->getDestinataire()->getLigne3().";".
						$l->getDestinataire()->getLigne4().";".
						$l->getDestinataire()->getCodePostal().";".
						$l->getDestinataire()->getVille().";".
						$l->getDestinataire()->getPays().";".
						$l->getNumero().";".
						$l->getPortDu().";".
						$l->getValeurDeclaree().";".
						$l->getContreremboursementDeclare().";".
						$l->getContreremboursementCorrige().";".
						$l->getFlux().";".
						$l->getTournee().";".
						$l->getMarchandises().";".
						$l->getNbColis().";".
						$l->getReferences().";".
						$l->getPoidsTotalDeclareEnKg().";".
						$l->getPoidsTotalConstateEnKg().";".
						$l->getPoidsEnKg().";".
						$l->getDateSaisie().";".
						$l->getDateCloture().";".
						$l->conformite['date'].";".
						$l->conformite['type'].";".
						$l->conformite['libelle'].";".
						$l->facturation['refs'].";".
						$l->facturation['puht']."\r\n";
			}
			$this->_helper->layout->disableLayout();
			$this->_helper->viewRenderer->setNoRender();
			header('Content-Type: text/csv; charset=utf-8');
			header('Content-Disposition: attachment; filename="'.$nom.'.csv"');
			header('Expires: 0');
			echo $this->csvContent;
		}catch(Exception $e){
			file_put_contents('php://stderr', 'Application_Controllers_LVController.php exporterAction() exception ' . $e . "\n");
			ini_set('max_execution_time', 1);
			sleep(3); 
		}
	}

	
	function shutdown()
	{
		// on vide des variables pour récupérer un peu de mémoire
		if(isset($this->lvs)){
			error_log("LV restantes : ".count($this->lvs));
			$this->lvs=null;
		}
		if(isset($this->csvContent)){
			$this->csvContent=null;
		}
		$a=error_get_last();
		if($a!==null) {
			error_log("Shutdown script with error \"".$a['message']."\"");
			error_log("headers : ".count(headers_list()));
			if(headers_sent()) {
				echo "Error, memory exceded. File truncated.";
			}else{
				$title = "Impossible d'exporter.";
				$msg = "Le nombre de lettres de voiture est trop important pour faire une exportation.<br>Appliquez un filtre plus restrictif, en filtrant par date, par exemple.";
				header("location: /error/index/title/".urlencode($title)."/msg/".urlencode($msg));
			}
		}
	}
	
    public function listdispatchAction()
    {
        return $this->_helper->redirector('index');
    }
    
    private function huffmaniser($chaine) {
		$tree = array (
				"*" => "0", "0" => "100",
				"1" => "101", "2" => "110",
				"3" => "111"
		);
    	$bin = "";
		for ($i = 0; $i < strlen($chaine); $i++) $bin .= $tree[$chaine{$i}];
    	$chars = str_split($bin, 8);
    	$chars[count($chars) -1] = str_pad($chars[count($chars) -1], 8, "0", STR_PAD_RIGHT);
    	$result = "";
    	foreach ($chars as $char) $result .= $char;
    	return $result;
    }
    
    private function compresserNumeros($numeros) {
    	$numeros = str_split($numeros, 13);
    	/*sort($numeros, SORT_STRING);*/
		for ($i=0; $i < sizeof($numeros); $i++){
		}
    	$prefixe = str_pad(Application_Model_ParametresMapper::getParametre('id'), 2, '0', STR_PAD_LEFT);
    	
    	$suite = 0;
    	$chaine = base_convert(ltrim(substr($numeros[0], 3), '0'), 36, 4);
		foreach ($numeros as $index => $numero) {
			if ($index == 0) {
				continue;
			}
			
			$precedent = ltrim(substr($numeros[$index - 1], 3), '0');
			$courant = ltrim(substr($numero, 3), '0');
			$delta = base_convert($courant, 36, 4) - base_convert($precedent, 36, 4);
			if ($delta == 1) {
				$suite++;
			} else {
				$chaine .= "*".$suite;
				$chaine .= "*".base_convert($delta, 10, 4);
				$suite = 0;
			}
		}
		$chaine .= "*".$suite;
		$binary = $this->huffmaniser(base_convert("LGF", 36, 4)."*".$prefixe."*".$chaine);
		$base45 = $this->convBase($binary,'01', '0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ $%*+-./:');
    	return $base45;
    }
	
	private function intToAlphaBaseN($n,$baseArray) {
		$l=count($baseArray);
		$s = '';
		for ($i = 1; $n >= 0 && $i < 10; $i++) {
			$s =  $baseArray[($n % pow($l, $i) / pow($l, $i - 1))].$s;
			$n -= pow($l, $i);
		}
		return $s;
	} 
	
	
	private function convBase($numberInput, $fromBaseInput, $toBaseInput) {
		if ($fromBaseInput==$toBaseInput) return $numberInput;
		$fromBase = str_split($fromBaseInput,1);
		$toBase = str_split($toBaseInput,1);
		$number = str_split($numberInput,1);
		$fromLen=strlen($fromBaseInput);
		$toLen=strlen($toBaseInput);
		$numberLen=strlen($numberInput);
		$retval='';
		if ($toBaseInput == '0123456789')
		{
			$retval=0;
			for ($i = 1;$i <= $numberLen; $i++)
				$retval = bcadd($retval, bcmul(array_search($number[$i-1], $fromBase),bcpow($fromLen,$numberLen-$i)));
			return $retval;
		}
		if ($fromBaseInput != '0123456789'){
			$base10=$this->convBase($numberInput, $fromBaseInput, '0123456789');
		}else {
			$base10 = $numberInput;
		}
		if ($base10<strlen($toBaseInput)){
			return $toBase[$base10];
		}
		while($base10 != '0')
		{
			$retval = $toBase[bcmod($base10,$toLen)].$retval;
			$base10 = bcdiv($base10,$toLen,0);
		}
		return $retval;
	}

    private function toCLocale(&$data) {
    	function noComma(&$value) {
    		if (is_numeric(str_replace(",", ".", $value))) $value = str_replace(",", ".", $value);
    	}
    	array_walk_recursive($data, 'noComma');
    	return $this;
    }
    
    private function r_trim(&$data) {
    	function trim_value(&$value) {
    		$value = trim($value);
    	}
    	array_walk_recursive($data, 'trim_value');
    	return $this;
    }
		
/**
* @param integer $id_adresse_expediteur 
* @param integer $id_adresse_destinataire
* @param array $p : parametre post du formulaire
* @param integer $id_flux
* @param bool $lvplanifiable
* @param Application_Model_LVMapper $lmapper
* @return integer $id : 
*/
	private function creerLV($id_adresse_expediteur, $id_adresse_destinataire, $p, $id_flux, $lvplanifiable, Application_Model_LVMapper &$lmapper){
		$donnees = array(
			"expediteur" 	 			=> $id_adresse_expediteur,
			"destinataire" 	 		=> $id_adresse_destinataire,
			"valeurDeclaree" 		=> $p['valeur_declaree'],
			"instructions"	 		=> $p['instructions'],
			"portDu"		 				=> $p['port_du'],
			"contreremboursementdeclare"	=> $p['contreremboursement'],
			"message"						=> $p['message'],
			"tag"								=> $p['tag'],
			"idflux"						=> $id_flux,
			// le propriétaire de la lv est inséré automatiquement par le mapper
		);
		if ($lvplanifiable) {
			$donnees["dateclotureprevue"] = $p['dateclotureprevue'];
		}
		else {
			$donnees["dateclotureprevue"] = $lmapper->datenow();
		}
		$nbcont = isset($p['conteneurs']['liste'])?count($p['conteneurs']['liste']):0;
		$nbsupp = (is_int(intval($p['conteneurs']['nombre'])))?intval($p['conteneurs']['nombre']):0;
		$optionsCodes = [];
		if(isset($p['options'])){
			foreach ($p['options'] as $optionCode => $isActive) {
				if($isActive){
					array_push($optionsCodes, $optionCode);
				}
			}
		}
		return $lmapper->save(new Application_Model_LV($donnees), $nbcont + $nbsupp, $optionsCodes);
	}

/**
* @param classZend_Controller_Request_Http $request : requette
* @param Application_Form_LV $form : objet formulaire
* @return $p, $opt
*/
	private function PreTraitementFormulaire(Zend_Controller_Request_Http $request, Application_Form_LV $form){
		$p = $request->getPost();
		$this->toCLocale($p)->r_trim($p);

		// si pas de token de form, c'est qu'on attend pas de formulaire
		// si il y a un token mais qu'il ne correspond pas, on redirige également vers le listing
		$ftokens = new Zend_Session_Namespace('ftokens');
		if (!isset($ftokens->current) || $ftokens->current != $p['otftoken']) {
				return $this->_helper->redirector('index','lv',null,array());
		}

		// si le formulaire est annulé on retourne à l'index des lv
		if ($request->getParam('submit') == "Annuler") {
			return $this->_helper->redirector('index');
		}
		// pour les ecombo
		$instr_element = $form->getElement('instructions');
		$march_element = $form->getSubForm('conteneurs')->getElement('marchandise');
		$opera_element = $form->getSubForm('conteneurs')->getElement('operateur');
		if ($instr_element->getMultiOption($p['instructions']) === null) $instr_element->addMultiOption('lgf-new-value', $p['instructions']);
		if ($march_element->getMultiOption($p['conteneurs']['marchandise']) === null) $march_element->addMultiOption('lgf-new-value', $p['conteneurs']['marchandise']);
		// pour la saisie d'adresse à la volée
		$form->getElement('destinataire')->addMultiOption('otf', 'otf');

		$mapperExpediteur = new Application_Model_ExpediteurMapper();
		$opt = $mapperExpediteur->getOptions(PROPRIETAIRE);
		if ($opt['autocompleteoperateur']) {
			if ($opera_element->getMultiOption($p['conteneurs']['operateur']) === null) $opera_element->addMultiOption('lgf-new-value', $p['conteneurs']['operateur']);
		}
		$form->getElement('instructions')->setValue($p['instructions']);
		$form->getSubForm('conteneurs')->getElement('marchandise')->setValue($p['conteneurs']['marchandise']);
		$form->getSubForm('conteneurs')->getElement('operateur')->setValue($p['conteneurs']['operateur']);
		return array($p, $opt, $ftokens);
	}

/**
* @param Application_Model_LVMapper $lmapper
* @param array $p
* @param integer $id : id de la lettre de voiture
* @param bool $checkCloturee : doit on verifier si la lettre de voiture est cloturée avant d'ajouter le conteneur (default: true)
*/
	private function EnregistrerConteneurs(Application_Model_LVMapper &$lmapper, $p, $id, $checkCloturee = true){
		$em = new Application_Model_ExpediteurMapper();
		$o = $em->getOptions();
		$limite = $o['limitecolis'];
		// 6.1. ajout des derniers colis laissés dans le formulaire
		$infos = $p['conteneurs']; // nombre, poids, type, operateur, repartition
		if ($infos['repartition'] == "total") {
			$modulo = round($infos['poids']*1000) % $infos['nombre'];
			$poids = floor($infos['poids']*1000/$infos['nombre'])/1000;
		} else {
			$modulo = 0;
			$poids = round($infos['poids'], 3);
		}
		for ($i = 0; $i < $infos['nombre'] && ($i < $limite || $limite == 0); $i++) {
			if ($i == 0 && $infos['repartition'] == "total") {
				$pds = $poids + $modulo / 1000;
			} else {
				$pds = $poids;
			}
			
			$p['conteneurs']['liste'][] = array(
				"poids" => $pds,
				"marchandise" => $infos['marchandise'],
				"operateur" => $infos['operateur']
			);
		}
		// 6.2. enregistrement des colis
		if ($limite > 0) array_splice($p['conteneurs']['liste'], $limite); // sécurité double (JS et php) pour ne pas dépasser la limite
		foreach($p['conteneurs']['liste'] as $cont) {
			$cont['poids'] = $cont['poids']*1000;
			$lmapper->saveConteneur(new Application_Model_Conteneur(array_merge($cont, array("lettre" => $id))),$checkCloturee);
			$lmapper->saveMarchandise($cont['marchandise']);
			$lmapper->saveOperateur($cont['operateur']);
		}
	}
  
  private function prepareRendu(&$adapter, $o, $page ){
    $r = $adapter->getCountColisLV();
    $this->view->nbcolis = $r["nbcolis"];
    $this->view->nblv = $r["nblv"];
    $adapter->setRowCount(intval($this->view->nblv));
    $this->view->flux = $adapter->getFluxDistincts();
    $paginateur = new Zend_Paginator($adapter);
    $paginateur->setItemCountPerPage($o['nbligneslv']);
    $paginateur->setCurrentPageNumber($page);
    Zend_Paginator::setDefaultScrollingStyle('Sliding');
    Zend_View_Helper_PaginationControl::setDefaultViewPartial('paginateur-simple.phtml');
    $this->view->paginator = $paginateur;
  }
  
  private function filtrerRechercher(&$adapter){
    if(!isset($this->view->messages)){
      $this->view->messages = [];
    }
    $filters = array();
    /* Implémentation des filtres */
    if ($this->_hasParam('filtrer')) {
      $g = $this->getRequest()->getParams();
      if ($g['du'] != "" && $g['au'] != "") {
        // vérification des dates
        $debut = Application_Model_Date::fromISO($g['du']);
        $fin   = Application_Model_Date::fromISO($g['au']);

        if(! $debut->isDateValid()){
          array_push($this->view->messages,
            "Date de début ".$debut->dateToFRFormat()." non valide. ".
            "Filtrage par date ignoré."
          );
        }
        if(! $fin->isDateValid()){
          array_push($this->view->messages,
            "Date de fin ".$fin->dateToFRFormat()." non valide. ".
            "Filtrage par date ignoré."
          );
        }

        if($debut->isDateValid() && $fin->isDateValid()){
          $filters[] = array(
            'champ' => 'datecloture',
            'type' => 'between',
            'valeur' => [$debut->dateToFRFormat(), $fin->dateToFRFormat()]
          );
        }
        $g['du'] = $debut->dateToFRFormat();
        $g['au'] = $fin->dateToFRFormat();
      }

      if (isset($g['refclient']) && $g['refclient'] != "tous") {
        $filters[] = array('champ' => 'destinataire_reference', 'type' => '=', 'valeur' => $g['refclient']);
      } elseif (isset($g['nomclient']) && $g['nomclient'] != "tous") {
        $filters[] = array('champ' => 'destinataire_nom', 'type' => '=', 'valeur' => $g['nomclient']);
      }
      if ($g['flux'] != "tous") {
        $filters[] = array('champ' => 'idflux', 'type' => '=', 'valeur' => $g['flux']);
      }
      $this->view->params = $g;
    }

    /* Implémentation de la recherche */
    if ($this->_hasParam('reference')) {
      $filters[] = array('champ' => '"references"', 'type' => 'ILIKE', 'valeur' => "%".$this->_getParam('reference')."%");
    $this->view->reference = $this->_getParam('reference');
    }
    if (count($filters) == 0) $filters = null;

    // ajout des filtres au selecteur
  	$adapter->setFilters($filters);
  }
}
