<?php

class ProfilController extends Zend_Controller_Action
{

    protected $_utilisateur = null;

    public function init()
    {
    	$authAdapter = Zend_Registry::get('adapter');
    	$auth = Zend_Auth::getInstance();
    	if (!$auth->hasIdentity()) {
    		return $this->_helper->redirector('index','login');
    	}
    	$mapper = new Application_Model_ExpediteurMapper();
    	$mapper->find(Zend_Auth::getInstance()->getStorage()->read()->id, $this->_utilisateur = new Application_Model_ObjExpediteur());
    	$this->view->headTitle()->prepend('Mon profil');
    }

    public function indexAction()
    {
    	$amapper = new Application_Model_AdresseMapper();
    	if ($this->getRequest()->getParam('id')) {
    		$amapper->setDefault($this->_utilisateur->getId(), $this->getRequest()->getParam('id'));
    	}
    	
    	$pform = new Application_Form_Profil();
    	$mform = new Application_Form_Mdp();
    	$request = $this->getRequest();
    	
    	if ($request->isPost()) {
    		if ($request->getParam('submit') == "Annuler") {
    			return $this->_helper->redirector('index');
    		}
    		$p = $request->getPost();
    		$mapper = new Application_Model_ExpediteurMapper();
    		// il est important de vérifier le mdp en dernier car les navigateurs modernes insèrent automatiquement les mdp sauvegardés dans le champ validé
    		if ($pform->isValid($p)) { // suffisant pour le moment pour décider du form envoyé
    			$mapper = new Application_Model_ExpediteurMapper();
    			$mapper->setNom($this->_utilisateur->getId(), $p['nomcomplet']);
    			$mapper->setOptions(new Application_Model_ObjExpediteur(array_merge($p, array("id" => $this->_utilisateur->id))));
    			$mapper->setCoordonnees($p);
    			return $this->_helper->redirector('index');
    		} elseif ($mform->isValid($p) && $p['newpass'] === $p['confirmnewpass']) { // si c'est pas le profil, c'est le mdp
    			$mapper->setPassword($this->_utilisateur->getId(), $p['newpass'], $p['oldpass']);
    			return $this->_helper->redirector('index');
    		}
    	}
    	
    	
    	$this->view->pform = $pform;
    	$this->view->mform = $mform;
    	$this->view->headTitle()->prepend('Afficher');
        $this->view->utilisateur = $this->_utilisateur;
        $this->view->adresses = $amapper->fetchAllObj($this->_utilisateur->getId());
        $this->view->defaut = $amapper->getDefault($this->_utilisateur->getId());
        $this->view->jQNeeded = array('profil');
        if ($this->_hasParam('testpopup')) $this->view->jQNeeded = array('popup');
    }

    public function changemdpAction()
    {
        $this->view->headTitle()->prepend('Changer de mot de passe');
        
        $form = new Application_Form_Mdp();
        $request = $this->getRequest();
        
        if ($request->isPost()) {
        	if ($request->getParam('submit') == "Annuler") {
        		return $this->_helper->redirector('index');
        	}
        	$p = $request->getPost();
        	if ($form->isValid($p) && $p['new'] === $p['confirm_new']) {
        		$mapper = new Application_Model_ExpediteurMapper();
        		$mapper->setPassword($this->_utilisateur->getId(), $p['new'], $p['old']);
        		return $this->_helper->redirector('index');
        	}
        }
        
        $this->view->form = $form;
    }

    public function ajoutadresseAction()
    {
        $request = $this->getRequest();
        foreach ($request->getPost() as $var) {
        	$var = trim($var);
        }
        $this->view->headTitle()->prepend('Ajouter une adresse d\'expédition');
        $form = new Application_Form_Adresse($this->_utilisateur->getId(), true);
        
        if ($request->isPost()) {
        	if ($request->getParam('submit') == "Annuler") {
        		return $this->_helper->redirector('index');
        	}
        	if ($form->isValid($request->getPost())) {
        		$adresse = new Application_Model_Adresse($form->getValues());
        		$mapper = new Application_Model_AdresseMapper();
        		$mapper->save($adresse);
        		return $this->_helper->redirector('index');
        	}
        }
        
        $this->view->jQNeeded = array('adresse');
        $mapper = new Application_Model_ExpediteurMapper();
        $me = $mapper->getMe();
        $form->set(['nom' => $me->getNom()]);
        $this->view->form = $form;
    }

    public function modifadresseAction()
    {
        $request = $this->getRequest();
    	$id = $request->getParam('id');
        $mapper = new Application_Model_AdresseMapper();
        $mapper->find($id, $adresse = new Application_Model_Adresse());
        $this->view->headTitle()->prepend('Modifier mon adresse');
        $this->view->suppressible = !$mapper->isDefault($this->_utilisateur->getId(), $id);
        
        $form = new Application_Form_Adresse($adresse->getTiers(), true);
        
        if ($request->isPost()) {
        	if ($request->getParam('submit') == "Annuler") {
        		return $this->_helper->redirector('index');
        	}
        	foreach ($request->getPost() as $var) {
        		$var = trim($var);
        	}
        	if ($form->isValid($this->getRequest()->getPost())) {
        		$adresse = new Application_Model_Adresse($this->getRequest()->getParams());
        		$mapper->save($adresse);
        		return $this->_helper->redirector('index');
        	}
        }
        
        $form->addElement('hidden', 'id', array('value' => $id, 'required' => true));
        $form->set($adresse->getValues());
        $form->getElement('submit')->setLabel('Modifier');
        
        $this->view->jQNeeded = array('adresse');
       	$this->view->id = $id;
        $this->view->form = $form;
    }

    public function supprimeadresseAction()
    {
        $id = $this->getRequest()->getParam('id');
        $mapper = new Application_Model_AdresseMapper();
        $mapper->delete($id);
        return $this->_helper->redirector('index');
    }

    public function optionsAction()
    {
    	$mapper = new Application_Model_ExpediteurMapper();
    	$form = new Application_Form_Options();
    	$form->set($mapper->getOptions($this->_utilisateur->id));
        $request = $this->getRequest();
        
        if ($request->isPost()) {
        	if ($request->getParam('submit') == "Annuler") {
        		return $this->_helper->redirector('index');
        	}
        	$p = $request->getPost();
        	$obj = new Application_Model_ObjExpediteur($p);
        	$obj->setId($this->_utilisateur->getId());
        	$mapper->setOptions($obj);
        	return $this->_helper->redirector('index');
        }
        
        $this->view->form = $form;
    }

    public function changenomAction()
    {
        $this->view->headTitle()->prepend('Changer de nom');
        
        $form = new Application_Form_NomExpediteur();
        $request = $this->getRequest();
        
        if ($request->isPost()) {
        	if ($request->getParam('submit') == "Annuler") {
        		return $this->_helper->redirector('index');
        	}
        	$p = $request->getPost();
        	if ($form->isValid($p) && $p['new'] === $p['confirm_new']) {
        		$mapper = new Application_Model_ExpediteurMapper();
        		$mapper->setNom($this->_utilisateur->getId(), $p['nomcomplet']);
        		return $this->_helper->redirector('index');
        	}
        }
        
        $this->view->form = $form;
    }


}















