<?php

if (!defined("PROPRIETAIRE")) define("PROPRIETAIRE", Zend_Auth::getInstance()->getStorage()->read()->id);

class Application_Extension_PaginatorAdapter_ContactSelect extends Zend_Paginator_Adapter_DbSelect {

	public function __construct() {
		$this->_select = Zend_Db_Table::getDefaultAdapter()->select()->from('vuecarnet')->where('idexpediteur = ?', PROPRIETAIRE)->order('reference');
	}

	public function getItems($offset, $itemCountPerPage)
	{
		
		$resultSet = $this->_select->limit($itemCountPerPage, $offset)->query()->fetchAll(Zend_Db::FETCH_ASSOC);
		$entries = array();
		foreach ($resultSet as $row) {
			$type= "Application_Model_".ucfirst($row['type']);
			$entries[] = new $type($row);
		}
		return $entries;
	}



	public function setPattern($searchColumn, $searchValue) {
		if (!empty($searchColumn) && !empty($searchValue)) $this->_select->where("$searchColumn ILIKE ?", $searchValue);
		return $this;
	}


}
