<?php

if (!defined("PROPRIETAIRE")) define("PROPRIETAIRE", Zend_Auth::getInstance()->getStorage()->read()->id);

class Application_Extension_PaginatorAdapter_LvSelect extends Zend_Paginator_Adapter_DbSelect {
	
	private $_countColisLV = null;
	private $_fluxDistincts = null;

	private $_order = array(
		"historique" => "datecloture DESC",
		"en cours" => "datecreation DESC",
		"planifiees" => "dateclotureprevue ASC"
	);

	private $_mode = null;
	
	public function __construct($mode = "historique") {
		if (!in_array($mode, array_keys($this->_order))) throw new Exception("Le paginateur est utilisé dans une action pour laquelle il n'est pas paramétré");
		$this->_mode = $mode;
		$this->_countColisLV = Zend_Db_Table::getDefaultAdapter()->select()->from('vuelv',array('nbcolis'=>'sum(nbcolis)', 'nblv'=>'count(*)'))->where('idexpediteur = ?', PROPRIETAIRE);
		$this->_fluxDistincts = Zend_Db_Table::getDefaultAdapter()->select()->distinct()->from('lv',array())->join('fluxstatique', 'lv.idflux = fluxstatique.id')->where('idexpediteur = ?', PROPRIETAIRE)->order('libelle ASC');
		$this->_select = Zend_Db_Table::getDefaultAdapter()->select()->from('vuelv')->where('idexpediteur = ?', PROPRIETAIRE)->order($this->_order[$mode]);
		switch ($mode) {
			case 'historique':
				$this->_select->where('datecloture IS NOT NULL');
				$this->_countColisLV->where('datecloture IS NOT NULL');
				$this->_fluxDistincts->where('lv.datecloture IS NOT NULL');
				break;
			case 'en cours':
				$this->_select->where('datecloture IS NULL AND dateclotureprevue <= now()::date');
				$this->_countColisLV->where('datecloture IS NULL AND estplanifiee IS NOT TRUE');
				$this->_fluxDistincts->where('lv.datecloture IS NULL AND lv.dateclotureprevue <= now()::date');
				break;
			case 'planifiees':
				$this->_select->where('datecloture IS NULL AND dateclotureprevue > now()::date');
				$this->_countColisLV->where('datecloture IS NULL AND estplanifiee IS TRUE');
				$this->_fluxDistincts->where('lv.datecloture IS NULL AND lv.dateclotureprevue > now()::date');
				break;
		}
	}
	
	public function getItems($offset = null, $itemCountPerPage = null)
    {
    	if (!is_null($offset)) {
    		$this->_select->limit($itemCountPerPage, $offset);
    	}
    	$sql = $this->_select->order('id DESC');
    	$stmt = new Zend_Db_Statement_Pdo(Zend_Db_Table::getDefaultAdapter(), $sql);
    	$stmt->execute();
      	$codeSuivi = Application_Extension_StaticLib::getCodeSuivi();		
    	$entries = array();
    	while($row = $stmt->fetch(Zend_Db::FETCH_ASSOC)) {
			$lettre = Application_Extension_StaticLib::row2Objlv($row);
    		if ($this->_mode == 'historique') {
				$lettre->setConformite($row, $codeSuivi);
				$lettre->setFacturation($row, Application_Extension_StaticLib::getFacturation($row['id']));
			}
    		$entries[] = $lettre;
    	}
    	return $entries;
    }

    public function getOrder() {
    	return $this->_order[$this->_mode];
    }
    
    public function getSelect() {
    	return clone $this->_select;
    }
    
    public function getCountColisLV() {
    	if ($this->_countColisLV instanceof Zend_Db_Select) {
    		$r = $this->_countColisLV->query()->fetch(Zend_Db::FETCH_ASSOC);
    		return $this->_countColisLV = $r; 
    	} else {
    		return $this->_countColisLV;
    	}
    }

    public function getFluxDistincts() {
    	if ($this->_fluxDistincts instanceof Zend_Db_Select) {
    		return $this->_fluxDistincts = $this->_fluxDistincts->query()->fetchAll(Zend_Db::FETCH_ASSOC);
    	} else {
    		return $this->_fluxDistincts;
    	}
    }
    
	public function setFilters($filters) {
		if (!is_null($filters) && is_array($filters)) {
			foreach ($filters as $filt) {
				if (is_array($filt)) {
					if ($filt['type'] == 'between') {
						$this->_select->where('datecloture::date BETWEEN \''.$filt['valeur'][0].'\' AND \''.$filt['valeur'][1].'\'::date'); // filtre de date à date
						$this->_countColisLV->where('datecloture::date BETWEEN \''.$filt['valeur'][0].'\' AND \''.$filt['valeur'][1].'\'::date');
					} else {
						$where = $filt['champ'].' '.$filt['type'].' ?';
						$this->_select->where($where, $filt['valeur']);
						$this->_countColisLV->where($where, $filt['valeur']);
					}
				} else {
					throw new Exception('Le filtrage de lv nécessite un tableau associatif contenant les bornes, '.gettype($filters).' donné');
				}
			}
		}
		return $this;
	}

    
}
