<?php

class Application_Extension_StaticLib {

  public static function array_from_prefix(array $array, $prefix)
	{
  	$ret = array();
  	$len = strlen($prefix);
  	foreach ($array as $key => $val) {
  		if (substr($key,0,$len) == $prefix) {
  			$ret[substr($key,$len)] = $val;
  		}
  	}
  	return $ret;
  }

  /**
  * créer un objet lv à partir d'un tableau associatif (retour requête sql)
  *@param array $row : tableau associatif 
  *@param Application_Model_ObjLV $lv : 
  *@return Application_Model_ObjLV
  */
	public static function row2Objlv($row, Application_Model_ObjLV $lv = null)
	{
		if ( !is_object($lv) ) $lv = new Application_Model_ObjLV();
    $lv->setDateSaisie($row['datecreation'])
			->setEmarge($row['url'])
			->setContreremboursementDeclare($row['contreremboursementdeclare'] / 100)	// conversion en monnaie, stockée en entier dans la base
			->setContreremboursementCorrige( is_null( $row['contreremboursementcorrige'] ) ? null : $row['contreremboursementcorrige'] / 100 )
			->setValeurDeclaree($row['valeurdeclaree'] / 100)					// conversion en monnaie, stockée en entier dans la base
			->setDestinataire(new Application_Model_AdresseStatique(self::array_from_prefix($row, "destinataire_")))
			->setExpediteur(new Application_Model_AdresseStatique(self::array_from_prefix($row, "expediteur_")))
    ->setId($row['id'])
    ->setNumero($row['numero'])
    ->setPortDu($row['portdu'])
    ->setMessage($row['message'])
    ->setInstructions($row['instructions'])
    ->setDatemodification($row['datemodification'])
    ->setIdflux($row['idflux'])
    ->setFlux($row['flux'])
    ->setTag($row['tag'])
    ->setTournee($row['tournee'])
    ->setReferencesCommande($row['references'])
    ->setDateCloturePrevue($row['dateclotureprevue'])
    ->setDemandeSuppression($row['demandesuppression'])
    ->setDemandeSuppression_motif($row['demandesuppression_motif'])
    ->setNbColis($row['nbcolis'])
    ->setMarchandises($row['marchandises'])
    ->setPoidsTotal($row['poidstotal'])
    ->setPoidsTotalDeclare($row['poidstotaldeclare'])
    ->setPoidsTotalConstate($row['poidstotalconstate'])
    ->setReferences($row['references'])
    ->setOperateurs($row['operateurs'])
    ->setDateCloture($row['datecloture'])
    ->setDateImpression($row['dateimpression'])
    ->setEnlevement($row['enlevement'])
    ->setOptions($row['options']);
		return $lv;
	}

/**
* récupère les codes de suivi
* @return array :     [PODMQT] => Array([id] => '250',[type] => 'PODMQT',[libelle] => 'Preuve de livraison électronique : Image manquante' )
*/
  public static function getCodeSuivi(){
    $codeSuivi = Zend_Db_Table_Abstract::getDefaultAdapter()->select()->from('typetrace_ihm', array('id', 'type', 'libelle'))->query()->fetchAll();
    $codeSuivi = array_combine(array_column($codeSuivi,'type'),$codeSuivi);
    return $codeSuivi;
  }

  	/**
	 * récupère la facturation liée à une lettre de voiture
	 * @param string : id de lettre de voiture
	 * @return array : Array([refs] => '1 x A-050', [puht] => 683)
	 */
  	public static function getFacturation($idlv) {
		$query = "SELECT ARRAY_TO_STRING(ARRAY_AGG(tarifs.refs), ', ') AS refs, SUM(tarifs.puht / 100::FLOAT4) AS puht
				  FROM (
				  	  SELECT
					  	  COUNT(tarifstatique.reference) || ' x ' || tarifstatique.reference AS refs,
						  SUM(tarifstatique.puht) AS puht
					  FROM lv
					  	  JOIN facture.expediteur ON lv.idexpediteur = expediteur.idtiers
					  	  JOIN facture.lignedefacturelv ON lv.id = lignedefacturelv.idlv
						  JOIN facture.lignedefacture ON lignedefacturelv.idlignedefacture = lignedefacture.id
						  JOIN facture.tarifstatique ON lignedefacture.idtarifstatique = tarifstatique.id
					  WHERE lv.id = ".$idlv."
					  AND facture.expediteur.tarifvisibleportail IS TRUE
					  GROUP BY tarifstatique.reference
				  ) AS tarifs";
		$result = Zend_Db_Table::getDefaultAdapter()->fetchAll($query)[0];
		return $result;
	}

	/**
	* formate un numéro de téléphone
	* @param string : numéro de téléphone
	* @return string : numéro formaté
	*/
	public static function formaterTelephone($string){
		$string = trim($string);
		$validateur = new Application_Form_Validate_Telephone("international");
		if($validateur->isValid($string)){
			$search = array(' ','-','.');
			$tel = str_replace( $search , "" , $string);
			// si numéro de moins de 14 caractères, on le formate avec des espaces tous les 2 caractères
			if(strlen($tel) <= 14) $numeroTelFormater = trim( strrev( chunk_split( strrev($tel), 2 , " " )) );
			// sinon, on le renvoie brut
			else $numeroTelFormater = $tel;
			return $numeroTelFormater;
		}else{
			return null;
		}
	}
}
