<?php
if (!defined("PROPRIETAIRE")) define("PROPRIETAIRE", Zend_Auth::getInstance()->getStorage()->read()->id);

class Application_Form_Adresse extends Application_Form_Extension
{
	
    private $avecNom = false;

	public function __construct($id, $avecNom = false) {
        $this->avecNom = $avecNom;
		parent::__construct(null);
		$this->getElement('tiers')->setValue($id);
	}
	
	public function set($vals) {
		foreach ($vals as $name => $val) {
            if (!$this->avecNom && $name == 'nom') continue;
			$this->getElement($name)->setValue($val);
		}
	}
	
    public function init()
    {
        $this->setMethod('post');
        
        $this->addElement('hidden', 'tiers', array('required' => true));
        
        $this->addElement('text', 'libelle', array(
        	'label'		=> 'Libellé',
        	'required'	=> true,
        	'validators' => array(
        		array('validator' => 'StringLength', 'options' => array(1, 30))
        	)	
        ));

        if ($this->avecNom)
            $this->addElement('text', 'nom', array(
                'label' => 'Nom apparent',
                'required' => true,
                'validators' => array(
                    array('validator' => 'StringLength', 'options' => array(1, 70))
                )
            ));
        
        $this->addElement('text', 'ligne1', array(
        	'label' 	=> 'Ligne 1',
        	'maxLength'	=> 38,
        	'required' 	=> true,
			'validators' => array(
            	array('validator' => 'StringLength', 'options' => array(1, 38))
            )
        ));
        
		$this->addElement('text', 'ligne2', array(
        	'label'		=> 'Ligne 2',
        	'maxLength'	=> 38,
			'validators' => array(
            	array('validator' => 'StringLength', 'options' => array(1, 38))
            )
        ));
		
		$this->addElement('text', 'ligne3', array(
        	'label'		=> 'Ligne 3',
        	'maxLength'	=> 38,
			'validators' => array(
            	array('validator' => 'StringLength', 'options' => array(1, 38))
            )
        ));
		
		$this->addElement('text', 'ligne4', array(
        	'label'		=> 'Ligne 4',
        	'maxLength'	=> 38,
			'validators' => array(
            	array('validator' => 'StringLength', 'options' => array(1, 38))
            )
        ));
		
        $this->addElement('select', 'pays', array(
        	'label'		=> 'Pays',
        	'class'		=> 'pays',
			'value'     => 'fr',
			'multiOptions' => Application_Model_VilleMapper::getPaysDisponibles(),
			'required' 	=> true	
        ));
		
        $this->addElement('text', 'codepostal', array(
        	'label'		=> 'Code postal',
        	'class'		=> 'code',
        	'required'	=> true
        ));
        
        $this->addElement('text', 'ville', array(
        	'label'		=> 'Ville',
        	'class'		=> 'ville',
        	'value'	=> 'Saisissez un code postal',
        	'required'	=> true
        ));
        
        $this->slipDecorator('codepostal', new Application_Form_Decorator_VilleButton());
        
        $mapper = new Application_Model_ExpediteurMapper();
        $opt = $mapper->getOptions(PROPRIETAIRE);
        if ($opt['tagadresse']) {
	        $this->addElement('text', 'tag', array(
	        	'label'		=> 'Tag(s)',
	        	'maxLength' => 30,
	        ));
        } else {
        	$this->addElement('hidden','tag');
        }
        
        $this->addElement('submit','submit', array(
        		'label'		=> 'Ajouter',
        		'ignore'	=> true
        ));
        
        $this->slipDecorator('submit', new Application_Form_Decorator_CancelButton(),2);
        
    }

    public function isValid($data) {
        $this->getElement('codepostal')->addValidator(new Application_Form_Validate_CodePostal($data['pays']));
        return parent::isValid($data);
    }


}

