<?php
if (!defined("PROPRIETAIRE")) define("PROPRIETAIRE", Zend_Auth::getInstance()->getStorage()->read()->id);

class Application_Form_AdresseOTF extends Application_Form_Adresse
{
	public function __construct() {
		parent::__construct(0);
		$this->removeElement('tiers');
	}
	
	public function set($vals) {
		foreach ($vals as $name => $val) {
			$this->getElement($name)->setValue($val);
		}
	}
	
    public function init()
    {        
    	$this->addElement('hidden', 'otf');
    	
        $this->addElement('text', 'nom', array(
        	'label'		=> 'Nom',
        	'required' 	=> true,
        	'validators' => array(
        			array('validator' => 'StringLength', 'options' => array(1, 30))
        	)
        ));
        
        $this->addElement('text', 'telephone', array(
        	'label'		=> 'Téléphone',
        	'maxLength'	=> 20,
       		'validators' => array( new Application_Form_Validate_Telephone("international") )
        ));
        
        parent::init();
        
        $this->removeElement('libelle');
        $this->removeCustomDecorators('submit');
        
        
    }


}

