<?php

class Application_Form_Extension extends Zend_Form
{
	private $custom_decorators = array();

	public function __toString() {
		$this->setDecorators(array(
		    'FormElements',
		    array('Form',array('class' => 'zend_form_extended'))
		));
		$this->setElementDecorators(array(
		    'ViewHelper',
		    new Application_Form_Decorator_Errors(),
		    array('Label',array('class' => 'field_label')),
			new Application_Form_Decorator_Element()
		));
		foreach($this->getElements() as $element) {
			if ($element->getType() == "Zend_Form_Element_Button" || $element->getType() == "Zend_Form_Element_Submit") {
				$element->setDecorators(array(
					'ViewHelper',
					new Application_Form_Decorator_Errors(),
					new Application_Form_Decorator_EmptyLabel(),
					new Application_Form_Decorator_Element()
				));
			}
		}
		foreach($this->getSubForms() as $subform) {
			$subform->setDecorators(array(
				'FormElements',
				new Application_Form_Decorator_SubFormTitle()
			));
			$subform->setElementDecorators(array(
				'ViewHelper',
				new Application_Form_Decorator_Errors(),
				array('Label',array('class' => 'field_label')),
				new Application_Form_Decorator_Element()
			));
			foreach($subform->getElements() as $element) {
				if ($element->getType() == "Zend_Form_Element_Button" || $element->getType() == "Zend_Form_Element_Submit") {
					$element->setDecorators(array(
						'ViewHelper',
						new Application_Form_Decorator_Errors(),
						new Application_Form_Decorator_EmptyLabel(),
						new Application_Form_Decorator_Element()
					));
				}
			}
			$subform->slipDecorators();
		}
		foreach($this->custom_decorators as $decorator) {
			$this->slipDecorator($decorator['name'], $decorator['decorator'], $decorator['place'], false);
		}
		return parent::__toString();
	}
	
	public function removeCustomDecorators($elementName) {
		foreach ($this->custom_decorators as $index => $decorator) {
			if ($decorator['name'] == $elementName) unset($this->custom_decorators[$index]);
		}
	}
	
	public function slipDecorator($elementName, $decorator, $before = 1, $remember = true) {
    	if (!$remember) { // au moment de retourner le code du formulaire
	    	$decs = $this->getElement($elementName)->getDecorators();
	    	if ($decs !== null) {
	    		array_splice($decs, $before, 0, array($decorator));
	    		$this->getElement($elementName)->setDecorators($decs);
	    	} else {
	    		return null;
	    	}
    	} else { // dans l'init
    		$this->custom_decorators[] = array('name' => $elementName, 'decorator' => $decorator, 'place' => $before);
    	}
    }
}

