<?php
if (!defined("PROPRIETAIRE")) define("PROPRIETAIRE", Zend_Auth::getInstance()->getStorage()->read()->id);

class Application_Form_LV extends Application_Form_Extension
{

	public function set($vals) {
		foreach ($vals as $name => $val) {
			$this->getElement($name)->setValue($val);
		}
	}
	
    public function init()
    {
        $this->setMethod('post');
        
        $tmapper = new Application_Model_TiersMapper();
        $lmapper = new Application_Model_LVMapper();
        $flux = $lmapper->fetchAllFlux();
        $fluxliste = array();
        foreach ($flux as $f) {
			$fluxliste[$f['id']] = $f['libelle'];
        }
        
        if (count($fluxliste) > 1) {
        	$this->addElement('select','idflux', array(
        		'label'		=> 'Flux',
        		'multiOptions' => $fluxliste,
        		'required'	=> true
        	));
        } else {
        	$this->addElement('hidden', 'idflux', array(
        		'value'		=> $flux[0]['id'],
        		'required'	=> true
        	));
        }
        
        $dests = $tmapper->fetchAllAsList();
        
        $mapper = new Application_Model_ExpediteurMapper();
        $opt = $mapper->getOptions(PROPRIETAIRE);
        if ($opt['autocompletedestinataire']) $class = 'lgf-selectable-combo tiers-updater';
        else $class = 'lgf-selectable-combo tiers-updater onblur';
        $this->addElement('select','destinataire', array(
        	'label'			=> 'Destinataire',
        	'class'			=> $class,
        	'size'			=> '7',
        	'required'		=> true,
        	'multiOptions'	=> $dests
        ));
        
        $this->slipDecorator('destinataire', new Application_Form_Decorator_AdresseButton());
        
        $this->addElement('hidden','adresse', array(
        		'id'		=> 'adresse-ie',
                'required'  => true
        ));
        
        $this->slipDecorator('adresse', new Application_Form_Decorator_IESpecific(), 4);
        
        if (count($dests) === 0) $this->getElement('destinataire')->setDescription("Ce formulaire de saisie se base sur votre carnet d'adresse pour le choix du destinataire. Votre carnet est vide pour l'instant, merci d'y ajouter vos destinataires avant de commencer la saisie d'expédition.");
        
        $this->addSubForm(new Application_Form_SubForm_Extension(), 'adresses')->getSubForm('adresses')->setLegend('Adresses du destinataire')->setAttrib('class', 'destinataire-adresses');
        
        $this->addElement('text','valeur_declaree', array(
	        	'label'			=> 'Valeur déclarée',
						'class'			=> 'number decimal',
	        	'validators' 	=> array(
						array('validator' => 'Float', 'options' => array('locale' => 'en')),
						new Application_Form_Validate_SuperieurOuEgal( 0 )
				)
        ));
        
        $this->addElement('text','contreremboursement', array(
        		'label'			=> 'Contre-remboursement',
						'class'			=> 'number decimal',
        		'validators' 	=> array(
        				array('validator' => 'Float', 'options' => array('locale' => 'en')),
								new Application_Form_Validate_SuperieurOuEgal( 0 )
        		)
        ));
        
        $this->addElement('checkbox','port_du', array(
        		'label'		=> 'Port dû'
       	));
        
        $this->addElement('text','commande', array(
        		'label'		=> 'Références commande',
        		'maxLength' => 30,
        		'ignore'	=> true,
        ));
        
        $this->slipDecorator('commande', new Application_Form_Decorator_Lister());
        
        $this->addElement('select','instructions', array(
        	'label'			=> 'Instructions de livraison',
        	'size'			=> '7',
        	'class'			=> 'lgf-editable-combo',
        	'maxLength'		=> 70,
			'multiOptions'	=> $lmapper->fetchAllInstructions(),
        	'validators' => array(
        		array('validator' => 'StringLength', 'options' => array(0, 70))
        	)
        ));
        $this->getElement('instructions')->setRegisterInArrayValidator(false);
        
        $this->addElement('text','message', array(
        	'label'			=> 'Message',
        	'maxLength'		=> 70,
        	'validators' => array(
       			array('validator' => 'StringLength', 'options' => array(0, 70))
        	)
        ));
		
		if ($opt['lvplanifiable']) {
			$this->addElement('text', 'dateclotureprevue', array(
				'label'			=> 'Date de clotûre prévue',
				'maxLength'		=> 70, 
				'readonly' 		=> 'readonly')
			);
		}

		$optionLVmapper = new Application_Model_OptionLVMapper();
		if(count($optionLVmapper->getOptionsDisponibles()) > 0){
			$this->addSubForm(new Application_Form_SubForm_OptionLV(), 'options')->getSubForm('options')->setLegend('Options de transport');
		}

        $this->addSubForm(new Application_Form_SubForm_Colis(), 'conteneurs')->getSubForm('conteneurs')->setLegend('Conteneurs');
        
		      
        if ($opt['taglv']) {
	        $this->addElement('text','tag', array(
	        	'label'		=> 'Tag(s)',
	        	'maxLength'	=> 30
	        ));
        } else {
        	$this->addElement('hidden','tag');
        }
        
        $this->addElement('submit','submit', array(
       		'label'		=> 'Enregistrer',
       		'ignore'	=> true	
       	));
        
        $this->slipDecorator('submit', new Application_Form_Decorator_CancelButton(),2);

        $this->addElement('hidden', 'otftoken', array(
            'required'  => true
        ));

        if ($_SERVER['REQUEST_METHOD'] == 'GET') {
            $form_token = md5('bee' + Zend_Auth::getInstance()->getStorage()->read()->id + 'lgf' + microtime());
            $ftokens = new Zend_Session_Namespace('ftokens');
            $ftokens->current = $form_token;

            $this->getElement('otftoken')->setValue($form_token);
        }
		
    }

}
