<?php

class Application_Form_LVListe extends Zend_Form
{

	private $_buffer = array();
	
	public function __construct($options = null) {
		$this->setDisableLoadDefaultDecorators(true);
		parent::__construct($options);
	}

    public function bufferElement($element, $name = null, $options = null) {
    	$this->_buffer[] = array("element" => $element, "name" => $name, "options" => $options);
    }

    public function unbufferElement($name) {
    	foreach($this->_buffer as $key => $element) {
    		if ($element['name'] == $name) {
    			unset($this->_buffer[$key]);
    		}
    	}
    }
    
    public function __toString() {
    	foreach($this->_buffer as $element) $this->addElement($element['element'], $element['name'], $element['options']);
    	
    	$this->addElement('submit', 'cloture', array(
    		'label'		=> 'Clôturer',
    		'ignore'	=> true
    	));
    	
    	$this->addElement('submit', 'imprimetiquettes',array(
    		'label'		=> 'Réimprimer les étiquettes',
    		'ignore'	=> true
    	));
    	
    	$this->addElement('submit', 'supprime',array(
    		'label'		=> 'Supprimer',
    		'ignore'	=> true
    	));
    	
    	return parent::__toString();
    }
}

