<?php

class Application_Form_Options extends Application_Form_Extension
{

	public function set($vals) {
    	foreach ($vals as $name => $val) {
    		$elm = $this->getElement($name);
    		if ($elm == null) continue;
    		if ($elm->getType() == "Zend_Form_Element_Checkbox") {
    			$elm->setChecked($val);
    		} else {
    			$this->getElement($name)->setValue($val);
    		}
    	}
	}
	
    public function init()
    {
        $this->setMethod('post');
        
        $this->addElement('checkbox', 'tagadresse', array(
        	'label'		=> 'Activer les tags pour les adresses',
        ));
        
        $this->addElement('checkbox', 'taglv', array(
        	'label'		=> 'Activer les tags pour les LV',
        ));

        $this->addElement('checkbox', 'autocompleteoperateur', array(
        	'label'		=> 'Activer l\'autocomplétion des opérateurs',
        ));
        
        $this->addElement('submit','submit', array(
        	'label'		=> 'Enregistrer',
        	'ignore'	=> true
        ));
        
        $this->slipDecorator('submit', new Application_Form_Decorator_CancelButton(),2);
    }


}

