﻿<?php

class Application_Form_Profil extends Application_Form_Extension
{
	public function set($vals) {
		foreach ($vals as $name => $val) {
			$elm = $this->getElement($name);
			if ($elm == null) continue;
			if ($elm->getType() == "Zend_Form_Element_Checkbox") {
				$elm->setChecked($val);
			} else {
				$this->getElement($name)->setValue($val);
			}
		}
	}
    
	public function init()
    {
        $this->setMethod('post');
        
        $mapper = new Application_Model_ExpediteurMapper();
        $me = $mapper->getMe();
        $opts = $mapper->getOptions();
        $coords = $mapper->getCoordonnees();
        
        $this->addElement('text','nomcomplet', array(
        		'label' => 'Nom',
        		'required' => true,
        		'value' => $me->getNom()
        ));
        
        $this->addElement('text','reference', array(
        		'label' => 'Utilisateur',
        		'disabled' => true,
        		'value' => $me->getReference()
        ));
        
        $this->addElement('text', 'telfixe', array(
       		'label'		=> 'Téléphone fixe',
        	'value'		=> $coords['telfixe'],
        	'maxLength'	=> 20,
       		'validators' => array( new Application_Form_Validate_Telephone("international"))
       	));
       
       	$this->addElement('text', 'fax', array(
       		'label'		=> 'Fax',
       		'value'		=> $coords['fax'],
        	'maxLength'	=> 20,
       		'validators' => array( new Application_Form_Validate_Telephone("international"))
       	));
       
       	$this->addElement('text', 'telport', array(
       		'label'		=> 'Téléphone portable',
       		'value'		=> $coords['telport'],
        	'maxLength'	=> 20,
       		'validators' => array( new Application_Form_Validate_Telephone("international"))
       	));
       	
       	$this->addElement('text', 'mail', array(
       			'label'		=> 'Mail',
       			'value'		=> $coords['mail'],
       			'validators' => array(
       					'EmailAddress'
       			)
       	));
        
        $this->addElement('text','nbligneslv', array(
        		'label' => 'Nombre de lignes par page dans l\'historique',
        		'required' => true
        ));
        
        $this->addElement('hidden','nbcartesct', array(
        		'label' => 'Nombre de cartes par page dans le carnet'
        ));
        
        $this->slipDecorator('nbcartesct', new Application_Form_Decorator_CartesSelecteur(), 2);
        
        $emapper = new Application_Model_EtatsMapper();
        
        $this->addElement('select', 'etatetq', array(
				'label'			=> 'Format d\'impression des étiquettes',
				'multiOptions' 	=> $emapper->getClassesEtq()
        ));
        
        $this->addElement('select', 'etatlv', array(
				'label'			=> 'Format d\'impression des lettres de voiture',
				'multiOptions' 	=> $emapper->getClassesLv()
        ));
		
		$this->addElement('select', 'etatjn', array(
				'label'			=> 'Format d\'impression des journaux',
				'multiOptions' 	=> $emapper->getClassesJn()
        ));
        
        $this->addElement('checkbox', 'tagadresse', array(
        	'label'		=> 'Activer les tags pour les adresses',
        ));
        
        $this->addElement('checkbox', 'taglv', array(
        	'label'		=> 'Activer les tags pour les LV',
        ));

        $this->addElement('checkbox', 'autocompleteoperateur', array(
        	'label'		=> 'Activer l\'autocomplétion des opérateurs',
        ));
        
        $this->addElement('checkbox', 'autocompletedestinataire', array(
        	'label'		=> 'Activer l\'autocomplétion des destinataires à la saisie',
        ));
        
        $this->set($opts);
        
        $this->addElement('submit','submit', array(
        	'label'		=> 'Enregistrer',
        	'ignore'	=> true
        ));
        
        $this->slipDecorator('submit', new Application_Form_Decorator_CancelButton(),2);
    }


}

