<?php

class Application_Form_Tiers extends Application_Form_Extension
{
	
	public function set($vals) {
    	foreach ($vals as $name => $val) {
    		$this->getElement($name)->setValue($val);
    	}
	}
    
	public function init()
    {
    	$this->setMethod('post');
    	
       	$this->addElement('radio', 'type', array(
       		'label'		=> 'Type de tiers',
       		'class'		=> 'lgf-type-toggle',
       		'required'	=> true,
       		'multiOptions' => array("Entreprise" => 'entreprise', "Particulier" => 'particulier')
       	));
       	
       	// champs propres aux entreprises
       	
       	$mapper = new Application_Model_TiersMapper();
       	
       	$this->addElement('select','statut', array(
       		'label'			=> 'Statut juridique',
       		'class'			=> 'lgf-type-dependant lgf-type-Entreprise',
       		'multiOptions'	=> $mapper->getEnumValues("statut",true)
       	));
       	
       	$this->addElement('text','siren', array(
       		'label'			=> 'Siren',
       		'class'			=> 'lgf-type-dependant lgf-type-Entreprise',
       		'maxLength'		=> 9,
       		'validators' => array(
       			array('validator' => 'StringLength', 'options' => array(9))
       		)
       	));
       	
       	$this->addElement('text','raison', array(
       		'label'		=> 'Raison sociale',
       		'required'	=> true,
       		'class'			=> 'lgf-type-dependant lgf-type-Entreprise',
       		'validators' => array(
       			array('validator' => 'StringLength', 'options' => array(1, 60)),
       			new Application_Form_Validate_Tiers()
       		)
       	));
       	
       	// champs propres aux particuliers
       	
       	$this->addElement('select','civilite', array(
       		'label'			=> 'Civilité',
       		'class'			=> 'lgf-type-dependant lgf-type-Particulier',
       		'multiOptions'	=> $mapper->getEnumValues("civilite")
       	));
       	
       	$this->addElement('text','nom', array(
       		'label'		=> 'Nom',
       		'required'		=> true,
       		'class'			=> 'lgf-type-dependant lgf-type-Particulier',
       		'validators' => array(
       			array('validator' => 'StringLength', 'options' => array(1, 30)),
       			new Application_Form_Validate_Tiers()
       		)
       	));
       	
       	$this->addElement('text','prenom', array(
       		'label'		=> 'Prénom',
       		'class'			=> 'lgf-type-dependant lgf-type-Particulier',
       		'validators' => array(
       			array('validator' => 'StringLength', 'options' => array(1, 30))
       		)
       	));
       	
       	// champs communs
       	
       	$this->addElement('text','reference', array(
       		'label'		=> 'Référence',
       		'required'	=> true,
       		'validators' => array(
       			array('validator' => 'StringLength', 'options' => array(1, 30)),
       			new Application_Form_Validate_Reference()
       		)	
       	));
       	
       	$this->addElement('text', 'mail', array(
       		'label'		=> 'Mail',
       		'validators' => array(
       			'EmailAddress'
       		)	
       	));
       
       	$this->addElement('text', 'telfixe', array(
       		'label'		=> 'Téléphone fixe',
        	'maxLength'	=> 20,
       		'validators' => array( new Application_Form_Validate_Telephone("international"))
       	));
       
       	$this->addElement('text', 'fax', array(
       		'label'		=> 'Fax',
        	'maxLength'	=> 20,
       		'validators' => array( new Application_Form_Validate_Telephone("international"))
       	));
       
       	$this->addElement('text', 'telport', array(
       		'label'		=> 'Téléphone portable',
        	'maxLength'	=> 20,
       		'validators' => array( new Application_Form_Validate_Telephone("international"))
       	));
       	
       	// subform de la première adresse
       	
       	$this->addSubForm(new Application_Form_SubForm_Adresse(), 'adresse')->getSubForm('adresse')->setLegend('Adresse');
       	
       	// champs de validation
       	
       	$this->addElement('submit','submit', array(
       		'label'		=> 'Ajouter',
       		'ignore'	=> true	
       	));
       	
       	$this->slipDecorator('submit', new Application_Form_Decorator_CancelButton(),2);
       	
    }
    
    public function isValid($data) {
      if (isset($data['type'])) {
    		if ($data['type'] == 'Entreprise') {
    			$this->getElement('civilite')->setIgnore(true)->setRequired(false);
    			$this->getElement('prenom')->setIgnore(true)->setRequired(false);
    			$this->getElement('nom')->setIgnore(true)->setRequired(false);
        	} else {
    			$this->getElement('statut')->setIgnore(true)->setRequired(false);
    			$this->getElement('raison')->setIgnore(true)->setRequired(false);
    			$this->getElement('siren')->setIgnore(true)->setRequired(false);
      	}
      }
      // échouera de toute façon car le champ type est requis
    	return parent::isValid($data);
    }
    
    public function __toString() {
    	$base = parent::__toString();
    	if (count($this->_errorMessages) > 0) {
    		$list = "<ul><li>".implode("</li><li>",$this->_errorMessages)."</li></ul>";
    		return $base.$list;
    	}
    	return $base;
    }

}

