<?php

class Application_Form_TiersFromOTF extends Application_Form_Tiers {
	
	public function init() {

		$this->addElement('radio', 'nouveau', array(
       		'label'		=> 'Nouveau contact',
       		'class'		=> 'lgf-nouveau-toggle',
       		'required'	=> true,
       		'value'	=> "oui",
       		'multiOptions' => array("oui" => "oui", "non" => "non")
       	));

		$tmapper = new Application_Model_TiersMapper();
   	$dests = $tmapper->fetchAllAsList();

   	$this->addElement('select','contact', array(
    	'label'			=> 'Contact',
    	'required'		=> true,
    	'multiOptions'	=> $dests
    ));

		parent::init();
	}

  public function isValid($data) {
    if ($data['nouveau'] == "non") { // ancien, dans une liste select
      unset($data['type']);
      $this->getElement('type')->setIgnore(true)->setRequired(false);
      $this->getElement('reference')->setIgnore(true)->setRequired(false);
    } else { // nouveau, il faut alors remplir les champs
      $this->getElement('contact')->setIgnore(true)->setRequired(false);
    }
    return parent::isValid($data);
  }
}