<?php
if (!defined("PROPRIETAIRE")) define("PROPRIETAIRE", Zend_Auth::getInstance()->getStorage()->read()->id);

class Application_Form_SubForm_Adresse extends Application_Form_SubForm_Extension {

	public function set($vals) {
		foreach ($vals as $name => $val) {
			$this->getElement($name)->setValue($val);
		}
	}

	public function init() {
		$this->addElement('text', 'libelle', array(
        	'label'		=> 'Libellé',
			'value'		=> 'défaut',
        	'required'	=> true,
        	'validators' => array(
        		array('validator' => 'StringLength', 'options' => array(1, 30))
        	)	
        ));
        
        $this->addElement('text', 'ligne1', array(
        	'label' 	=> 'Ligne 1',
        	'required' 	=> true,
			'maxLength'	=> 38,
			'validators' => array(
            	array('validator' => 'StringLength', 'options' => array(1, 38))
            )
        ));
        
        $this->addElement('text', 'ligne2', array(
        	'label'		=> 'Ligne 2',
			'maxLength'	=> 38,
			'validators' => array(
            	array('validator' => 'StringLength', 'options' => array(1, 38))
            )
        ));
		
		$this->addElement('text', 'ligne3', array(
        	'label' 	=> 'Ligne 3',
			'maxLength'	=> 38,
			'validators' => array(
            	array('validator' => 'StringLength', 'options' => array(1, 38))
            )
        ));
        
        $this->addElement('text', 'ligne4', array(
        	'label'		=> 'Ligne 4',
			'maxLength'	=> 38,
			'validators' => array(
            	array('validator' => 'StringLength', 'options' => array(1, 38))
            )
        ));
		
		$this->addElement('select', 'pays', array(
        	'label'		=> 'Pays',
			'class'		=> 'pays',
			'value'     => 'fr',
            'multiOptions' => Application_Model_VilleMapper::getPaysDisponibles(),
			'required' 	=> true	
        ));
        
        $this->addElement('text', 'codepostal', array(
        	'label'		=> 'Code postal',
        	'class'		=> 'code',
        	'required'	=> true,
        ));
        
        $this->addElement('text', 'ville', array(
        	'label'		=> 'Ville',
        	'class'		=> 'ville',
        	'value'		=> 'Saisissez un code postal',
        	'required'	=> true
        ));
        $this->slipDecorator('codepostal', new Application_Form_Decorator_VilleButton());
        
		$mapper = new Application_Model_ExpediteurMapper();
        $opt = $mapper->getOptions(PROPRIETAIRE);
        if ($opt['tagadresse']) {
	        $this->addElement('text', 'tag', array(
	        	'label'		=> 'Tag(s)',
	        	'maxLength' => 30,
	        ));
        } else {
        	$this->addElement('hidden','tag');
        }
	}

    public function isValid($data) {
        $this->getElement('codepostal')->addValidator(new Application_Form_Validate_CodePostal($data['adresse']['pays']));
        return parent::isValid($data);
    }
}
