<?php

class Application_Form_SubForm_Colis extends Application_Form_SubForm_Extension {

	public function set($vals) {
		foreach ($vals as $name => $val) {
			$this->getElement($name)->setValue($val);
		}
	}

	public function isValid($data) {
		if (isset($data['conteneurs']['liste'])) {
			if (count($data['conteneurs']['liste']) > 0
					&& $this->getElement('nombre')->getValue() == ""
					&& $this->getElement('poids')->getValue() == ""
					&& $this->getElement('marchandise')->getValue() == "") {
				$this->getElement('nombre')->setRequired(false)->setIgnore(true);
				$this->getElement('poids')->setRequired(false)->setIgnore(true);
				$this->getElement('marchandise')->setRequired(false)->setIgnore(true);
			}
		}
		return parent::isValid($data);
	}
	
	public function init() {
		
		$mapper = new Application_Model_LVMapper();
		
		$this->addElement('text','nombre',array(
				'label'			=> 'Nombre',
				'required'		=> true,
				'class'			=> 'number',
				'validators' 	=> array(
						array('validator' => 'GreaterThan', 'options' => array('min' => 0))
				)
			)
		);

		$this->addElement('text','poids',array(
				'label'			=> 'Poids (en kg)',
				'required'		=> true,
				'class'			=> 'number decimal',
				'validators' 	=> array(
						array('validator' => 'GreaterThan', 'options' => array('min' => 0))
				)
		));
		
		$this->slipDecorator('poids', new Application_Form_Decorator_ChoixPoids());
		
		$this->addElement('select','marchandise',array(
				'label'			=> 'Marchandise',
				'maxlength'		=> 30,
				'size'			=> 7,
				'class'			=> 'lgf-editable-combo',
				'required'		=> true,
				'multiOptions'	=> $mapper->fetchAllMarchandises(),
				'validators' => array(
						array('validator' => 'StringLength', 'options' => array(0, 30))
				)
		));
		$this->getElement('marchandise')->setRegisterInArrayValidator(false);
		
		$mapperExpediteur = new Application_Model_ExpediteurMapper();
		$opt = $mapperExpediteur->getOptions(PROPRIETAIRE);
        if ($opt['autocompleteoperateur']) {
			$this->addElement('select', 'operateur', array(
					'label'			=> 'Opérateur',
					'maxlength'		=> 30,
					'size'			=> '7',
					'class'			=> 'lgf-editable-combo',
					'multiOptions'	=> $mapper->fetchAllOperateurs(),
					'validators' => array(
							array('validator' => 'StringLength', 'options' => array(0, 30))
					)
			));
			$this->getElement('operateur')->setRegisterInArrayValidator(false);
		}
		else
		{
			$this->addElement('text', 'operateur', array(
				'label'			=> 'Opérateur',
				'maxLength'		=> 30,
				'validators' => array(
					array('validator' => 'StringLength', 'options' => array(0, 30))
				)
			));
		}
			
		$this->addElement('button','ajout',array(
				'label'			=> 'Ajouter conteneur(s)',
				'class'			=> 'lgf-conteneur-ajout',
				'ignore'		=> true,
		));
		
		$this->addElement('hidden','liste',array(
				'label'			=> 'Conteneurs',
				'value'			=> '0',
				'ignore'		=> true
		));
		
		$this->slipDecorator('liste', new Application_Form_Decorator_TableauColis());
	}
	
}