<?php

class Application_Form_SubForm_Extension extends Zend_Form_SubForm {
	
	private $custom_decorators = array();
	
	public function slipDecorators() {
		foreach($this->custom_decorators as $decorator) {
			$this->slipDecorator($decorator['name'], $decorator['decorator'], $decorator['place'], false);
		}
	}
	
    public function slipDecorator($elementName, $decorator, $before = 1, $remember = true) {
    	if (!$remember) { // au moment de retourner le code du formulaire
	    	$decs = $this->getElement($elementName)->getDecorators();
	    	if ($decs !== null) {
	    		array_splice($decs, $before, 0, array($decorator));
	    		$this->getElement($elementName)->setDecorators($decs);
	    	} else {
	    		return null;
	    	}
    	} else { // dans l'init
    		$temp = $this->custom_decorators;
    		$temp[] = array('name' => $elementName, 'decorator' => $decorator, 'place' => $before);
    		$this->custom_decorators = $temp;
    	}
    }
}