<?php
if (!defined("PROPRIETAIRE")) define("PROPRIETAIRE", Zend_Auth::getInstance()->getStorage()->read()->id);

class Application_Form_SubForm_LV extends Application_Form_SubForm_Extension {

	public function set($vals) {
		foreach ($vals as $name => $val) {
			$this->getElement($name)->setValue($val);
		}
	}

	public function init() {
		$this->addElement('radio', 'type', array(
				'label'		=> 'Type de tiers',
				'class'		=> 'lgf-type-toggle',
				'required'	=> true,
				'multiOptions' => array("Entreprise" => 'entreprise', "Particulier" => 'particulier')
		));
		
		// champs propres aux entreprises
		
		$mapper = new Application_Model_TiersMapper();
		
		$this->addElement('select','statut', array(
				'label'			=> 'Statut juridique',
				'class'			=> 'lgf-type-dependant lgf-type-Entreprise',
				'multiOptions'	=> $mapper->getEnumValues("statut")
		));
		
		$this->addElement('text','raison', array(
				'label'		=> 'Raison sociale',
				'class'			=> 'lgf-type-dependant lgf-type-Entreprise',
				'validators' => array(
						array('validator' => 'StringLength', 'options' => array(1, 60))
				)
		));
		
		// champs propres aux particuliers
		
		$this->addElement('select','civilite', array(
				'label'			=> 'Civilité',
				'class'			=> 'lgf-type-dependant lgf-type-Particulier',
				'multiOptions'	=> $mapper->getEnumValues("civilite")
		));
		
		$this->addElement('text','nom', array(
				'label'		=> 'Nom',
				'class'			=> 'lgf-type-dependant lgf-type-Particulier',
				'validators' => array(
						array('validator' => 'StringLength', 'options' => array(1, 30))
				)
		));
		
		$this->addElement('text','prenom', array(
				'label'		=> 'Prénom',
				'class'			=> 'lgf-type-dependant lgf-type-Particulier',
				'validators' => array(
						array('validator' => 'StringLength', 'options' => array(1, 30))
				)
		));
		
		$this->addElement('text','reference', array(
				'label'		=> 'Référence',
				'validators' => array(
						array('validator' => 'StringLength', 'options' => array(1, 30))
				)
		));

		$this->addElement('text','ligne1',array(
				'label'			=> 'Ligne 1',
				'required'		=> true
		));

		$this->addElement('text','ligne2',array(
				'label'			=> 'Ligne 2'
		));
		
		$this->addElement('text','ligne3',array(
				'label'			=> 'Ligne 3'
		));
		
		$this->addElement('text','ligne4',array(
				'label'			=> 'Ligne 4'
		));

		$this->addElement('text','codepostal',array(
				'label'			=> 'Code postal',
				'class'			=> 'code',
				'required'		=> true,
				'maxLength'		=> 5,
				'validators' => array(
						array('validator' => 'Digits'),array('validator' => 'StringLength', 'options' => 5)
				)
		));

		$this->addElement('text','ville',array(
				'label'			=> 'Ville',
				'class'			=> 'ville',
				'required'		=> true
		));
		
		$this->addElement('text','pays',array(
				'label'			=> 'Pays',
				'required'		=> true
		));
		
		$this->slipDecorator('ville', new Application_Form_Decorator_VilleButton());
		
		$mapper = new Application_Model_ExpediteurMapper();
        $opt = $mapper->getOptions(PROPRIETAIRE);
        if ($opt['tagadresse']) {
	        $this->addElement('text', 'tag', array(
	        	'label'		=> 'Tag(s)',
	        	'maxLength' => 30,
	        ));
        } else {
        	$this->addElement('hidden','tag');
        }
		
		$this->addElement('checkbox','enregistrer', array(
				'label'			=> 'Enregistrer dans le carnet',
				'ignore'		=> true
		));
	}
}
