<?php

class Application_Form_Validate_Reference extends Zend_Validate_Abstract {
	
	const EXIST = "référence existante";
	
	protected $_messageTemplates = array(
			self::EXIST => "Un contact avec cette référence existe déjà dans ce carnet"
	);
	
	public function isValid($value, $context = null) {
		$return = true;
	
		$mp = new Application_Model_TiersMapper();
		if (isset ($context['id'])) {
			if ($mp->existsReference($value, $context['id'])) {
				$this->_error(self::EXIST);
				$return = false;
			}
		}
		else {
			if ($mp->existsReference($value, null)) {
				$this->_error(self::EXIST);
				$return = false;
			}
		}
		return $return;
	}
}