<?php
class Application_Form_Validate_SuperieurOuEgal extends Zend_Validate_Abstract
{
	const FLOAT = 'float';
	const MSG_MINIMUM = 'msgMinimum';

	public $minimum = 0;

	protected $_messageVariables = array(
		'min' => 'minimum',
	);

	protected $_messageTemplates = array(
		self::MSG_MINIMUM => "'%value%' doit être supérieure ou égale à '%min%'",
	);

	public function __construct($min=0) {
		$this->minimum = $min;
	}

	public function isValid($value)
	{
		$this->_setValue($value);
		if ($value < $this->minimum) {
			$this->_error(self::MSG_MINIMUM);
			return false;
		}
		return true;
	}
}