<?php

class Application_Form_Validate_Telephone extends Zend_Validate_Regex {
	
	protected $_messageTemplates = array(
			self::INVALID   => "Entrée invalide, numéro de téléphone attendu",
			self::NOT_MATCH => "'%value%' ne semble pas être un numéro de téléphone conforme",
			self::ERROROUS  => "Une erreur interne est survenue en comparant la valeur saisie à un format générique",
	);
	
	protected $_formats = array(
		"international" => "/(?=^.{2,20}$)^\+?\d+(?:[ \-.]?\d+)+$/",
	);

	protected $_patternName = "";
	
	public function __construct($country) {
		if (!isset($this->_formats[$country])) throw new Exception("Ce pays n'est pour l'instant pas disponible pour le validateur de numéro de téléphone");
		$this->_patternName = $country;
		parent::__construct(array('pattern' => $this->_formats[$country]));
	}
	
	protected function _error($messageKey, $value = null) {
		parent::_error($messageKey, $value);
	}
}