<?php

class Application_Form_Validate_Tiers extends Zend_Validate_Abstract {
	
	const PARTICULIER = 'particulier incomplet';
	const ENTREPRISE = 'entreprise incomplète';
	
	protected $_messageTemplates = array(
		self::PARTICULIER => "Un particulier doit avoir au minimum un nom",
		self::ENTREPRISE => "Une entreprise doit avoir au minimum une raison sociale"	
	);
	
	public function isValid($value, $context = null) {
		if ($context['type'] == "Entreprise" && $context['raison'] == "") {
			$this->_error(self::ENTREPRISE);
			return false;
		} elseif ($context['type'] == "Particulier" && $context['nom'] == "") {
			$this->_error(self::PARTICULIER);
			return false;
		}
		
		return true;
	}
}