<?php

class Application_Model_ASMapper
{
	protected $_dbTable;
	
	public function setDbTable($dbTable)
	{
		if (is_string($dbTable)) {
			$dbTable = new $dbTable();
		}
		if (!$dbTable instanceof Zend_Db_Table_Abstract) {
			throw new Exception('Invalid table data gateway provided');
		}
		$this->_dbTable = $dbTable;
		return $this;
	}
	
	public function getDbTable()
	{
		if (null === $this->_dbTable) {
			$this->setDbTable('Application_Model_DbTable_StatiqueAdresse');
		}
		return $this->_dbTable;
	}
	
	public function save(Application_Model_AdresseStatique $adresse) {
		$data = array(
				":nom"	=> $adresse->getNom(),
				":ligne1" => substr($adresse->getLigne1(),0,38),
				":ligne2" => substr($adresse->getLigne2(),0,38),
				":ligne3" => substr($adresse->getLigne3(),0,38),
				":ligne4" => substr($adresse->getLigne4(),0,38),
				":code"	=> $adresse->getCodePostal(),
				":ville"=> $adresse->getVille(),
				":tel"	=> $adresse->getTelephone(),
				":lib"  => $adresse->getLibelle(),
				":tag"	=> $adresse->getTag(),
				":pays"	=> $adresse->getPays(),
				":ref"	=> $adresse->getReference()
		);
		$sql = "INSERT INTO adressestatique(nom, ligne1, ligne2, ligne3, ligne4, codepostal, ville, telephone, libelle, tag, pays, reference) VALUES (:nom,:ligne1,COALESCE(:ligne2,''),COALESCE(:ligne3,''),COALESCE(:ligne4,''),:code,:ville,COALESCE(:tel, ''),:lib,:tag,:pays,:ref)
		ON CONFLICT (reference, nom, ligne1, ligne2, ligne3, ligne4, codepostal, ville, pays, tag, telephone, libelle) DO NOTHING;";
		$stmt = new Zend_Db_Statement_Pdo($this->getDbTable()->getAdapter(), $sql);
		$stmt->execute($data);
		return $this->exists($adresse);
	}
	
	public function find($id, Application_Model_AdresseStatique $adresse) {
		$row = $this->getDbTable()->getAdapter()->select()->from('adressestatique')->where("id = ?", $id)->query()->fetch(Zend_Db::FETCH_OBJ);
		if (0 == count($row)) {
			return;
		}
		$adresse->setId($row->id)
		->setNom($row->nom)
		->setLigne1($row->ligne1)
		->setLigne2($row->ligne2)
		->setLigne3($row->ligne3)
		->setLigne4($row->ligne4)
		->setCodePostal($row->codepostal)
		->setVille($row->ville)
		->setPays($row->pays)
		->setTag($row->tag)
		->setTelephone($row->telephone)
		->setLibelle($row->libelle)
		->setReference($row->reference);
	}
	
	public function exists(Application_Model_AdresseStatique $adresse) {
		$select = $this->getDbTable()->getAdapter()->select()
												   ->from('adressestatique','id')
												   ->where('nom = ?',$adresse->getNom())
												   ->where('ligne1 = ?',$adresse->getLigne1())
												   ->where("ligne2 = ?", $adresse->getLigne2())
												   ->where('ligne3 = ?',$adresse->getLigne3())
												   ->where("ligne4 = ?", $adresse->getLigne4())
												   ->where('codepostal = ?',$adresse->getCodePostal())
												   ->where('ville = ?',$adresse->getVille())
												   ->where('libelle = ?', $adresse->getLibelle())
												   ->where($adresse->getTag() === null?"tag = ''":'tag = ?', $adresse->getTag())
												   ->where($adresse->getTelephone() === null?"telephone = ''":'telephone = ?', $adresse->getTelephone())
												   ->where('pays = ?', $adresse->getPays())
												   ->where('reference = ?', $adresse->getReference());
		$row = $select->query()->fetch(Zend_Db::FETCH_OBJ);
		if ($row === false) {
			return false;
		} else {
			return $row->id;
		}
	}
	
	// la suppression d'une adresse statique est impossible, cf règle statique_adresse_del_lock
}

