<?php

class Application_Model_Adresse
{
	protected $_id;
	protected $_tiers;
	protected $_libelle;
    protected $_nom = '';
	
	protected $_ligne1;
	protected $_ligne2;
	protected $_ligne3;
	protected $_ligne4;
    protected $_codepostal;
    protected $_ville;
    protected $_pays;
    protected $_tag;
 
	public function __construct(array $options = null) {
    	if (is_array($options)) {
    		foreach ($options as $nom => $val) {
    			try {
    				$this->__set($nom, $val);
    			} catch (Exception $e) {
    			}
    		}
    	}
    }
    
    public function __set($name, $value)
    {
        $method = 'set' . $name;
        if (('mapper' == $name) || !method_exists($this, $method)) {
            throw new Exception('Invalid adresse property');
        }
        $this->$method($value);
    }
 
    public function __get($name)
    {
        $method = 'get' . $name;
        if (('mapper' == $name) || !method_exists($this, $method)) {
            throw new Exception('Invalid adresse property');
        }
        return $this->$method();
    }
    
    public function getId() {
    	return $this->_id;
    }
    public function setId($value) {
    	$this->_id = $value;
    	return $this;
    }
    
    public function getTiers() {
    	return $this->_tiers;
    }
    public function setTiers($value) {
    	$this->_tiers = $value;
    	return $this;
    }
    
    public function getNom() {
        return $this->_nom;
    }
    public function setNom($value) {
        $this->_nom = $value;
        return $this;
    }
    
	public function getLigne1() {
    	return $this->_ligne1;
    }
    public function setLigne1($value) {
    	$this->_ligne1 = $value;
    	return $this;
    }
	
	public function getLigne2() {
    	return $this->_ligne2;
    }
    public function setLigne2($value) {
    	$this->_ligne2 = $value;
    	return $this;
    }
	
	public function getLigne3() {
    	return $this->_ligne3;
    }
    public function setLigne3($value) {
    	$this->_ligne3 = $value;
    	return $this;
    }
	
	public function getLigne4() {
    	return $this->_ligne4;
    }
    public function setLigne4($value) {
    	$this->_ligne4 = $value;
    	return $this;
    }
	
    public function getCodePostal() {
    	return $this->_codepostal;
    }
    public function setCodePostal($value) {
    	$this->_codepostal = $value;
    	return $this;
    }
    
    public function getVille() {
    	return $this->_ville;
    }
    public function setVille($value) {
    	$this->_ville = $value;
    	return $this;
    }
    
    public function getValues() {
    	return array(
    			'id' 		=> $this->_id,
    			'libelle' 	=> $this->_libelle,
                'nom'       => $this->_nom,
    			'tiers' 	=> $this->_tiers,
    			'ligne1' 	=> $this->_ligne1,
    			'ligne2' 	=> $this->_ligne2,
			    'ligne3' 	=> $this->_ligne3,
    			'ligne4' 	=> $this->_ligne4,
    			'codepostal' => $this->_codepostal,
    			'ville' 	=> $this->_ville,
				'pays' 		=> $this->_pays,
    			'tag'		=> $this->_tag
    	);
    }
	public function getLibelle() {
		return $this->_libelle;
	}

	public function setLibelle($_libelle) {
		$this->_libelle = $_libelle;
		return $this;
	}
	public function getTag() {
		return $this->_tag;
	}

	public function setTag($_tag) {
		$this->_tag = $_tag;
		return $this;
	}
	public function getPays() {
		return $this->_pays;
	}

	public function setPays($_pays) {
		$this->_pays = $_pays;
		return $this;
	}



}

