<?php

class Application_Model_AdresseStatique
{
	protected $_id;
	protected $_nom;

	protected $_ligne1;
	protected $_ligne2;
	protected $_ligne3;
	protected $_ligne4;
	protected $_codepostal;
	protected $_ville;
	protected $_pays;
	protected $_tag;
	protected $_telephone;
	protected $_libelle;
	protected $_reference;
	
	public function __construct(array $options = null) {
		if (is_array($options)) {
			foreach ($options as $nom => $val) {
				try {
					$this->__set($nom, $val);
				} catch (Exception $e) {
				}
			}
		}
	}
	
	public function __set($name, $value)
	{
		$method = 'set' . $name;
		if (('mapper' == $name) || !method_exists($this, $method)) {
			throw new Exception('Invalid adressestatique property');
		}
		$this->$method($value);
	}
	
	public function __get($name)
	{
		$method = 'get' . $name;
		if (('mapper' == $name) || !method_exists($this, $method)) {
			throw new Exception('Invalid adressestatique property');
		}
		return $this->$method();
	}
	
	public function __toString() {
		return $this->_nom.PHP_EOL.$this->_ligne1.PHP_EOL.(($this->_ligne2 !== null)?$this->_ligne2.PHP_EOL:null).PHP_EOL.(($this->_ligne3 !== null)?$this->_ligne3.PHP_EOL:null).PHP_EOL.(($this->_ligne4 !== null)?$this->_ligne4.PHP_EOL:null).$this->_codepostal." ".$this->_ville;
	}
	
	/**
	 * @return the $_id
	 */
	public function getId() {
		return $this->_id;
	}

	/**
	 * @param field_type $_id
	 */
	public function setId($_id) {
		$this->_id = $_id;
		return $this;
	}

	/**
	 * @return the $_nom
	 */
	public function getNom() {
		return $this->_nom;
	}
	
	public function getNomComplet() {
		return $this->getNom();
	}

	/**
	 * @param field_type $_nom
	 */
	public function setNom($_nom) {
		$this->_nom = $_nom;
		return $this;
	}
	
	public function setNomComplet($_nom) {
		return $this->setNom($_nom);
	}
	
	/**
	 * @return the $_ligne1
	 */
	public function getLigne1() {
		return $this->_ligne1;
	}
	
	/**
	 * @param field_type $_ligne1
	 */
	public function setLigne1($_ligne1) {
		$this->_ligne1 = $_ligne1;
		return $this;
	}

	/**
	 * @return the $_ligne2
	 */
	public function getLigne2() {
		return $this->_ligne2;
	}
	
	/**
	 * @param field_type $_ligne2
	 */
	public function setLigne2($_ligne2) {
		$this->_ligne2 = $_ligne2;
		return $this;
	}

	/**
	 * @return the $_ligne3
	 */
	public function getLigne3() {
		return $this->_ligne3;
	}
	
	/**
	 * @param field_type $_ligne3
	 */
	public function setLigne3($_ligne3) {
		$this->_ligne3 = $_ligne3;
		return $this;
	}

	/**
	 * @return the $_ligne4
	 */
	public function getLigne4() {
		return $this->_ligne4;
	}
	/**
	 * @param field_type $_ligne4
	 */
	public function setLigne4($_ligne4) {
		$this->_ligne4 = $_ligne4;
		return $this;
	}
	
	/**
	 * @return the $_code
	 */
	public function getCodePostal() {
		return $this->_codepostal;
	}

	/**
	 * @param field_type $_code
	 */
	public function setCodePostal($_code) {
		$this->_codepostal = $_code;
		return $this;
	}

	/**
	 * @return the $_ville
	 */
	public function getVille() {
		return $this->_ville;
	}

	/**
	 * @param field_type $_ville
	 */
	public function setVille($_ville) {
		$this->_ville = $_ville;
		return $this;
	}

	/**
	 * @return the $_pays
	 */
	public function getPays() {
		return $this->_pays;
	}

	/**
	 * @param field_type $_pays
	 */
	public function setPays($_pays) {
		$this->_pays = $_pays;
		return $this;
	}
	public function getTag() {
		return $this->_tag;
	}

	public function setTag($_tag) {
		$this->_tag = $_tag;
		return $this;
	}
	public function getTelephone() {
		return Application_Extension_StaticLib::formaterTelephone($this->_telephone);
	}

	public function setTelephone($_telephone) {
		$this->_telephone = $_telephone;
		return $this;
	}
	public function getLibelle() {
		return $this->_libelle;
	}

	public function setLibelle($_libelle) {
		$this->_libelle = $_libelle;
		return $this;
	}
	public function getReference() {
		return $this->_reference;
	}

	public function setReference($_reference) {
		$this->_reference = $_reference;
		return $this;
	}
}

