<?php

class Application_Model_Conteneur
{
	protected $_id;
	protected $_lettre;
	protected $_poids;
	protected $_marchandise;
	protected $_operateur;
	protected $_numero;
	protected $_poidscorrige;
	protected $_tourneeGroupe;
	protected $_tourneeNom;
	protected $_referencescommande;
	protected $_traces;

	public function __construct(array $options = null) {
		if (is_array($options)) {
			foreach ($options as $nom => $val) {
				try {
					$this->__set($nom, $val);
				} catch (Exception $e) {
				}
			}
		}
	}
	
	public function __set($name, $value)
	{
		$method = 'set' . $name;
		if (('mapper' == $name) || !method_exists($this, $method)) {
			throw new Exception('Invalid conteneur property');
		}
		$this->$method($value);
	}
	
	public function __get($name)
	{
		$method = 'get' . $name;
		if (('mapper' == $name) || !method_exists($this, $method)) {
			throw new Exception('Invalid conteneur property');
		}
		return $this->$method();
	}
	
	public function getId() {
		return $this->_id;
	}
	public function setId($val) {
		$this->_id = $val;
		return $this;
	}
	/**
	 * @return the $_lettre
	 */
	public function getLettre() {
		return $this->_lettre;
	}

	/**
	 * @return the $_poids
	 */
	public function getPoids() {
		return $this->_poids;
	}

	public function getPoidsEnKg() {
		return number_format($this->_poids/1000, 3, ",", " ")." kg";
	}
	
	/**
	 * @param field_type $_lettre
	 */
	public function setLettre($_lettre) {
		$this->_lettre = $_lettre;
		return $this;
	}

	/**
	 * @param field_type $_poids
	 */
	public function setPoids($_poids) {
		$this->_poids = round($_poids);
		return $this;
	}
	/**
	 * @return the $_marchandise
	 */
	public function getMarchandise() {
		return $this->_marchandise;
	}

	/**
	 * @param field_type $_marchandise
	 */
	public function setMarchandise($_marchandise) {
		$this->_marchandise = $_marchandise;
		return $this;
	}
	
	public function getNumero() {
		return $this->_numero;
	}

	public function setNumero($_numero) {
		$this->_numero = $_numero;
		return $this;
	}
	public function getOperateur() {
		if ($this->_operateur == null) return '';
		return $this->_operateur;
	}

	public function setOperateur($_operateur) {
		$this->_operateur = $_operateur;
		return $this;
	}
	public function getPoidscorrige() {
		return $this->_poidscorrige;
	}

	public function setPoidscorrige($_poidscorrige) {
		$this->_poidscorrige = $_poidscorrige;
		return $this;
	}
	
	public function gettournee() {
		$separator="";
		if(
			!empty($this->gettourneeGroupe()) &&
			!empty($this->getTourneeNom())
		){
			$separator=" - ";
		}
		return $this->gettourneeGroupe().$separator.$this->getTourneeNom();
	}

	public function getTourneeGroupe() {
		return $this->_tourneeGroupe;
	}

	public function getTourneeNom() {
		return $this->_tourneeNom;
	}

	public function setTournee($_tournee) {
		return $this->setTourneeNom($_tournee);
	}

	public function setTourneeGroupe($groupe) {
		$this->_tourneeGroupe = $groupe;
		return $this;
	}

	public function setTourneeNom($nom) {
		$this->_tourneeNom = $nom;
		return $this;
	}
	
	public function getReferencesCommande() {
		return $this->_referencescommande;
	}

	public function setReferencesCommande($_referencescommande) {
		$this->_referencescommande = $_referencescommande;
		return $this;
	}

	public function getTraces() {
		return $this->_traces;
	}

	public function setTraces($_traces) {
		$this->_traces = $_traces;
		return $this;
	}
}

