<?php
// https://framework.zend.com/manual/1.12/fr/zend.date.creation.html
class Application_Model_Date{
	protected $_date;

	private function __construct($date){
		$this->_date = $date;
	}

	public static function fromISO($date){
		return new static($date, Zend_Date::ISO_8601);
	}

	public function isDateValid(){
		$dateParts = preg_split("/-/", $this->_date);
		return (! empty($this->_date) &&
			checkdate($dateParts[1], $dateParts[2], $dateParts[0])
		);
	}

	public function dateToFRFormat(){
		$dateParts = preg_split("/-/", $this->_date);
		$dateFR = $dateParts[2]."/".$dateParts[1]."/".$dateParts[0];
		return $dateFR;
	}
}