<?php

class Application_Model_Entreprise extends Application_Model_Contact
{
	private $_conciliant;
	
    protected $_siren;
    protected $_raison;
    protected $_statut;
 
    /**
     * Constructeur du parent (Application_Model_Tiers)
     * Un second paramètre optionnel, la conciliance, peut être fourni : s'il vaut true, l'appel d'accesseurs non définis renverra null plutôt que lever une exception. Par défaut, ce paramètre vaut false.
     * @param array $options
     * @param boolean $gentil
     */
    public function __construct(array $options = null, $gentil = false) {
    	parent::__construct($options);
    	$this->_conciliant = $gentil;
    }
    
    public function __set($name, $value)
    {
        $method = 'set' . $name;
        if (('mapper' == $name) || !method_exists($this, $method)) {
        	if ($this->_conciliant) return null;
            throw new Exception('Invalid entreprise property');
        }
        $this->$method($value);
    }
 
    public function __get($name)
    {
        $method = 'get' . $name;
        if (('mapper' == $name) || !method_exists($this, $method)) {
        	if ($this->_conciliant) return null;
            throw new Exception('Invalid entreprise property');
        }
        return $this->$method();
    }
 
    public function __toString() {
    	switch ($this->getSiren()) {
    		case null:
    			$siren = "null";
    			break;
    		case "":
    			$siren = "vide";
    			break;
    		case "         ":
    			$siren = "complété";
    			break;
    		default:
    			$siren = "autre";
    			break;
    	}
    	return $this->getStatut()." ".$this->getRaison()." {".$siren."} => ".$this->getReference();
    }
    
    public function setSiren($data) {
		$this->_siren = ($data == "" || $data == "         ")?null:$data;
		return $this;
	}
    public function getSiren() {
		return $this->_siren;
	}
 
    public function setRaison($data) {
		$this->_raison = $data;
		return $this;
	}
    public function getRaison() {
		return $this->_raison;
	}
	
	public function setRaisonSociale($data) {
		return $this->setRaison($data);
	}
 
	public function getRaisonSociale() {
		return $this->getRaison();
	}
	
    public function setStatut($data) {
		$this->_statut = $data;
		return $this;
	}
    public function getStatut() {
		return $this->_statut;
	}
	
	public function getValues() {
		return array(
			'id' 		=> $this->_id,
			'reference' => $this->_reference,
			'mail' 		=> $this->_mail,
			'telfixe' 	=> Application_Extension_StaticLib::formaterTelephone($this->_tel_fixe),
			'fax' 		=> Application_Extension_StaticLib::formaterTelephone($this->_fax),
			'telport' 	=> Application_Extension_StaticLib::formaterTelephone($this->_tel_port),
			'siren' 	=> $this->_siren,
			'statut' 	=> $this->_statut,
			'raison' 	=> $this->_raison
		);
	}
}

