<?php

class Application_Model_EtatsMapper {
	
	private $_classesetq = array();
	private $_classeslv  = array();
	private $_classesjn  = array();
	
	public function __construct() {
		if (($fichier = fopen(APPLICATION_PATH.'/models/Data/etats.csv', 'r')) !== false) {
			while ($classe = fgetcsv($fichier,100)) {
				if ($classe[0] == "etatlv") {
					$this->_classeslv[$classe[1]] = $classe[2];
				} elseif ($classe[0] == "etatetq") {
					$this->_classesetq[$classe[1]] = $classe[2];
				} elseif ($classe[0] == "etatjn") {
					$this->_classesjn[$classe[1]] = $classe[2];
				}
			}
		}
		
		if (count($this->_classesetq) == 0) {
			$this->_classesetq[0] = "impression standard";
		}
		if (count($this->_classeslv) == 0) {
			$this->_classeslv[0] = "impression standard";
		}
		if (count($this->_classesjn) == 0) {
			$this->_classesjn[0] = "impression standard";
		}
	}
	
	public function getClassesEtq() {
		return $this->_classesetq;
	}
	
	public function getClassesLv() {
		return $this->_classeslv;
	}
	
	public function getClassesJn() {
		return $this->_classesjn;
	}
}
