<?php
class Application_Model_ExpediteurMapper
{
	protected $_dbTable;
	
	public function __construct($definePROPRIETAIRE = true){
		if($definePROPRIETAIRE){
			if (!defined("PROPRIETAIRE")) define("PROPRIETAIRE", Zend_Auth::getInstance()->getStorage()->read()->id);
		}
	}
	public function setDbTable($dbTable)
	{
		if (is_string($dbTable)) {
			$dbTable = new $dbTable();
		}
		if (!$dbTable instanceof Zend_Db_Table_Abstract) {
			throw new Exception('Invalid table data gateway provided');
		}
		$this->_dbTable = $dbTable;
		return $this;
	}
	
	public function getDbTable()
	{
		if (null === $this->_dbTable) {
			$this->setDbTable('Application_Model_DbTable_Utilisateur');
		}
		return $this->_dbTable;
	}

	public function find($id, Application_Model_ObjExpediteur $utilisateur) {
		$row = $this->getDbTable()->getAdapter()->select()->from('vueexpediteur')->where("id = ?",$id)->query()->fetch(Zend_Db::FETCH_OBJ);
		if (0 == count($row)) {
			return;
		}
		$utilisateur->setId($row->id)->setNom($row->nomcomplet)->setReference($row->reference)->setAdresseDefaut($row->idadresse);
	}
	
	public function getMe() {
		$this->find(PROPRIETAIRE, $o = new Application_Model_ObjExpediteur());
		return $o;
	}
	
	public function setNom($id, $nouveau_nom) {
		$stmt = new Zend_Db_Statement_Pdo($this->getDbTable()->getAdapter(), 'UPDATE expediteur SET nomcomplet = :nom WHERE idtiers = :id');
		$stmt->execute(array(':id' => $id, ':nom' => $nouveau_nom));
	}
	
	public function setPassword($id, $nouveau_password, $ancien_password) {
		$stmt = new Zend_Db_Statement_Pdo($this->getDbTable()->getAdapter(), "UPDATE expediteur SET motdepasse = MD5(:salt || :npass) WHERE idtiers = :id AND motdepasse = MD5(:salt || :apass);");
		$stmt->execute(array(":salt" => Zend_Registry::get('staticSalt'), ":npass" => $nouveau_password, ":id" => $id, ":apass" => $ancien_password));
	}
	
	public function matchPassword($password) {
		$stmt = new Zend_Db_Statement_Pdo($this->getDbTable()->getAdapter(), "SELECT idtiers FROM expediteur WHERE idtiers = :id AND motdepasse = MD5(:salt || :pass);");
		$stmt->execute(array(":id" => Zend_Auth::getInstance()->getStorage()->read()->id, ":salt" => Zend_Registry::get('staticSalt'), ":pass" => $password));
		return (boolean) $stmt->fetch(Zend_Db::FETCH_OBJ);
	}
	
	public function register(Application_Model_ObjExpediteur $util, Application_Model_Adresse $adresse) {
		// pour les transporteurs
	}
	
	public function getCoordonnees() {
		return $this->getDbTable()->getAdapter()->select()->from('tiers',array('telfixe','telport','fax','mail'))->where('id = ?', PROPRIETAIRE)->query()->fetch(Zend_Db::FETCH_ASSOC);
	}
	
	public function getOptions($id = PROPRIETAIRE) {
		return $this->getDbTable()->getAdapter()->select()->from('expediteur',array('taglv', 'tagadresse','limitecolis','nbligneslv','nbcartesct','etatetq','etatlv', 'etatjn', 'autocompleteoperateur', 'autocompletedestinataire', 'utiliseenlevement', 'estcontrolable', 'impressionenlevement', 'lvplanifiable'))->where('idtiers = ?', $id)->query()->fetch(Zend_Db::FETCH_ASSOC);
	}
	
	public function setCoordonnees($coordonnees) {
		$stmt = new Zend_Db_Statement_Pdo($this->getDbTable()->getAdapter(), "UPDATE tiers SET (telfixe, fax, telport, mail) = (COALESCE(:fix,telfixe), COALESCE(:fax,fax), COALESCE(:port,telport), COALESCE(:mail,mail)) WHERE id = :id;");
		$stmt->execute(array(":fix" => $coordonnees['telfixe'], ":fax" => $coordonnees['fax'], ":port" => $coordonnees['telport'], ":mail" => $coordonnees['mail'], ":id" => PROPRIETAIRE));		
	}
	
	public function setOptions(Application_Model_ObjExpediteur $u) {
		$stmt = new Zend_Db_Statement_Pdo($this->getDbTable()->getAdapter(), "UPDATE expediteur SET (taglv, tagadresse, nbcartesct, nbligneslv, etatetq, etatlv, etatjn, autocompleteoperateur, autocompletedestinataire) = (:tlv::boolean, :tad::boolean, :nbc, :nbl, :cetq, :clv, :cjn, :ao, :ad) WHERE idtiers = :idt;");
		$stmt->execute(array(":tlv" => $u->getTaglv(), ":tad" => $u->getTagadresse(), ":nbl" => $u->getNbligneslv(), ":nbc" => $u->getNbcartesct(), ":idt" => $u->getId(), ":cetq" => $u->getEtatetq(), ":clv" => $u->getEtatlv(), ":cjn" => $u->getEtatjn(), ":ao" => $u->getAutocompleteoperateur(), ":ad" => $u->getAutocompletedestinataire()));
	}
	
	public static function getNbusers() {
		$ret = Zend_Db_Table_Abstract::getDefaultAdapter()->select()->from('expediteur', 'COUNT(*)')->query()->fetch(Zend_Db::FETCH_NUM);
		return $ret[0];
	}

	public function getAll($orderBy = 'nomcomplet'){
		$sotableBy=['nomcomplet','idtiers'];
		if(!in_array($orderBy, $sotableBy)) $orderBy = 'nomcomplet';
		$listExpediteur = $this->getDbTable()->getAdapter()->select()
						->from( 'expediteur', ['idexpediteur'=>'idtiers','type','nomcomplet'] )
						->join( 'adresse', 'idadressedefaut = adresse.id', ['nom','ligne1','ligne2','ligne3','ligne4','codepostal','ville','pays'] )
						->join( 'tiers', 'expediteur.idtiers = tiers.id' ,['telfixe', 'reference'])
						->where( 'expediteur.estutilisable' )
						->order( $orderBy )
						->query()
						->fetchAll(Zend_Db::FETCH_ASSOC);
		return $listExpediteur;
	}

}

