<?php

class Application_Model_LV
{
	const FORMAT_DATE = 'd/m/Y H:i';
	const FORMAT_DATE_COURT = 'd/m/Y';
	
	protected $_id;
	protected $_numero;
	protected $_expediteur;
	protected $_destinataire;
	protected $_datesaisie;
	protected $_valeurdeclaree;
	protected $_contreremboursementdeclare;
	protected $_contreremboursementcorrige;
	protected $_portdu;
	protected $_message;
	protected $_instructions;
	protected $_proprietaire;
	protected $_etat;
	protected $_datemodification;
	protected $_idflux;
	protected $_flux;
	protected $_tag;
	protected $_tourneeGroupe;
	protected $_tourneeNom;
	protected $_referencescommande;
	protected $_dateclotureprevue;
	protected $_emarge;
  protected $_demandesuppression;
  protected $_demandesuppression_motif;
	protected $_erreurs;
	protected $listeIconesSuivi = ['livrno', 'livrok', 'livrec', 'livrpb', 'livrko'];
	
	public function getProprietaire() {
		return $this->_proprietaire;
	}
	
	public function getEtat() {
		return $this->_etat;
	}
	
	public function setProprietaire($_proprietaire) {
		$this->_proprietaire = $_proprietaire;
		return $this;
	}
	
	public function setEtat($_etat) {
		$this->_etat = $_etat;
		return $this;
	}
	
	public function getId() {
		return $this->_id;
	}

	public function getExpediteur() {
		return $this->_expediteur;
	}

	public function getDestinataire() {
		return $this->_destinataire;
	}

	public function getValeurDeclaree() {
		return ($this->_valeurdeclaree === null || $this->_valeurdeclaree === '')?0:$this->_valeurdeclaree;
	}

	public function getInstructions() {
		return ($this->_instructions === '')?null:$this->_instructions;
	}

	public function setId($_id) {
		$this->_id = $_id;
		return $this;
	}

	public function setExpediteur($_expediteur) {
		$this->_expediteur = $_expediteur;
		return $this;
	}

	public function setDestinataire($_destinataire) {
		$this->_destinataire = $_destinataire;
		return $this;
	}

	public function setValeurDeclaree($_valeur_declaree) {
		$this->_valeurdeclaree = $_valeur_declaree;
		return $this;
	}

	public function setInstructions($_instructions) {
		$this->_instructions = $_instructions;
		return $this;
	}

	public function __construct(array $options = null) {
		if (is_array($options)) {
			foreach ($options as $nom => $val) {
				try {
					$this->__set($nom, $val);
				} catch (Exception $e) {
				}
			}
		}
	}
	
	public function __set($name, $value)
	{
		$method = 'set' . $name;
		if (('mapper' == $name) || !method_exists($this, $method)) {
			throw new Exception('Propriété non reconnue pour l\'objet LV');
		}
		$this->$method($value);
	}
	
	public function __get($name)
	{
		$method = 'get' . $name;
		if (('mapper' == $name) || !method_exists($this, $method)) {
			throw new Exception('Propriété non reconnue pour l\'objet LV');
		}
		return $this->$method();
	}
	public function getNumero() {
		return $this->_numero;
	}

	public function getDateSaisie() {
		return $this->_datesaisie;
	}
	
	public function getContreremboursement() {
		return ( is_null($this->getContreremboursementCorrige()) ) ? $this->getContreremboursementDeclare() : $this->getContreremboursementCorrige();
	}
	
	public function getContreremboursementDeclare() {
		return ($this->_contreremboursementdeclare === null || $this->_contreremboursementdeclare === '')?0:$this->_contreremboursementdeclare;
	}
	
	public function getContreremboursementCorrige() {
		return $this->_contreremboursementcorrige;
	}

	public function getPortDu() {
		return $this->_portdu;
	}

	public function getMessage() {
		return ($this->_message === '')?null:$this->_message;
	}

	public function setNumero($_numero) {
		$this->_numero = $_numero;
		return $this;
	}

	public function setDateSaisie($_date_saisie) {
		$this->_datesaisie = date(self::FORMAT_DATE,strtotime($_date_saisie));
		return $this;
	}

	public function setContreremboursementDeclare($_contreremboursementdeclare) {
		$this->_contreremboursementdeclare = $_contreremboursementdeclare;
		return $this;
	}

	public function setContreremboursementCorrige($_contreremboursementcorrige) {
		$this->_contreremboursementcorrige = $_contreremboursementcorrige;
		return $this;
	}

	public function setPortDu($_port_du) {
		$this->_portdu = $_port_du;
		return $this;
	}

	public function setMessage($_message) {
		$this->_message = $_message;
		return $this;
	}
	public function getDatemodification() {
		return $this->_datemodification;
	}

	public function setDatemodification($_datemodification) {
		$this->_datemodification = date(self::FORMAT_DATE,strtotime($_datemodification));
		return $this;
	}

	public function setValues(array $vals) {
		foreach ($vals as $nom => $val) {
			try {
				$this->__set($nom, $val);
			} catch (Exception $e) {
			}
		}
		return $this;
	}
	public function getFlux() {
		return $this->_flux;
	}
	
	public function getIdFlux() {
		return $this->_idflux;
	}

	public function getTag() {
		return $this->_tag;
	}

	public function setFlux($_flux) {
		$this->_flux = $_flux;
		return $this;
	}
	
	public function setIdFlux($_idflux) {
		if( is_numeric($_idflux) ) $this->_idflux = $_idflux;
		return $this;
	}

	public function setTag($_tag) {
		$this->_tag = $_tag;
		return $this;
	}

	public function getTournee() {
		$separator="";
		if(
			!empty($this->getTourneeGroupe()) &&
			!empty($this->getTourneeNom())
		){
			$separator=" - ";
		}
		return $this->getTourneeGroupe().$separator.$this->getTourneeNom();
	}

	public function getTourneeGroupe() {
		return $this->_tourneeGroupe;
	}

	public function getTourneeNom() {
		return $this->_tourneeNom;
	}
	
	public function setTournee($_tournee) {
		return $this->setTourneeNom($_tournee);
	}

	public function setTourneeGroupe($groupe) {
		$this->_tourneeGroupe = $groupe;
		return $this;
	}

	public function setTourneeNom($nom) {
		$this->_tourneeNom = $nom;
		return $this;
	}
	
	public function getReferenceCommande() {
		return $this->_referencescommande;
	}

	public function setReferencesCommande($_referencescommande) {
		$this->_referencescommande = $_referencescommande;
		return $this;
	}
	
	public function getDateCloturePrevue() {
		return $this->_dateclotureprevue;
	}

	public function setDateCloturePrevue($_dateclotureprevue) {
		$this->_dateclotureprevue = $_dateclotureprevue;
		return $this;
	}
	
	public function getEmarge() {
		return $this->_emarge;
	}
	
	public function setEmarge($_emarge) {
		if(preg_match('/^https?:/', $_emarge )){
			$this->_emarge = $_emarge;
		}
		return $this;
	}
  
  public function setDemandeSuppression($bool){
    if(is_bool($bool)) $this->_demandesuppression = $bool;
    return $this;
  }
  
  public function setDemandeSuppression_motif($str){
    if(is_string($str)) $this->_demandesuppression_motif = $str;
    return $this;
  }
  
  public function getDemandeSuppression(){
    return $this->_demandesuppression;
  }
  
  public function getDemandeSuppression_motif(){
    return $this->_demandesuppression_motif;
  }

	public function getListeIconesSuivi(){
		return $this->listeIconesSuivi;
	}
}

