<?php
class Application_Model_LVMapper
{

	protected $_dbTable;
	
	public function __construct($definePROPRIETAIRE = true){
		if($definePROPRIETAIRE){
			if (!defined("PROPRIETAIRE")) define("PROPRIETAIRE", Zend_Auth::getInstance()->getStorage()->read()->id);
		}
	}

	public function setDbTable($dbTable)
	{
		if (is_string($dbTable)) {
			$dbTable = new $dbTable();
		}
		if (!$dbTable instanceof Zend_Db_Table_Abstract) {
			throw new Exception('Invalid table data gateway provided');
		}
		$this->_dbTable = $dbTable;
		return $this;
	}
	
	public function getDbTable()
	{
		if (null === $this->_dbTable) {
			$this->setDbTable('Application_Model_DbTable_LettreVoiture');
		}
		return $this->_dbTable;
	}
	
	public function isCloturee($lettre) {
		$result = $this->getDbTable()->getAdapter()->select()->from('lv','datecloture')->where('id = ?', $lettre)->query()->fetch(Zend_Db::FETCH_OBJ);
		return ($result->datecloture != null);
	}
	
	public function createJournal() {
		$stmt = new Zend_Db_Statement_Pdo($this->getDbTable()->getAdapter(), "SELECT nextnumero('J') AS n;");
		$stmt->execute();
		return $stmt->fetch(Zend_Db::FETCH_COLUMN);
	}
	
	public function getJournal($idlv) {
		return $this->getDbTable()->getAdapter()->select()->from('lv','numerolot')->where("id = ?", $idlv)->query()->fetch(Zend_Db::FETCH_OBJ)->numerolot;
	}
	
	public function getJournaux() {
		return $this->getDbTable()->getAdapter()->select()->from('vuejournal')->where("idexpediteur = ?", PROPRIETAIRE)->order("dateramasse DESC")->limit(10)->query()->fetchAll(Zend_Db::FETCH_OBJ);
	}
	
	public function getIdlvFromJournal($journal) {
		$stmt = new Zend_Db_Statement_Pdo($this->getDbTable()->getAdapter(), "SELECT id FROM lv WHERE numerolot = '$journal';");
		$stmt->execute();
		return $stmt->fetchAll(Zend_Db::FETCH_COLUMN);
	}
	
	public function filtreLvPrevue (array $ids) {
		if (count($ids) == 0 or empty($ids[0])) return "";
		$idlvs = implode(', ', $ids);
		$ids = new Zend_Db_Statement_Pdo($this->getDbTable()->getAdapter(), "SELECT id FROM lv WHERE id IN ($idlvs) AND dateclotureprevue <= now();");
		$ids->execute();
		$ids = $ids->fetchAll(Zend_Db::FETCH_COLUMN);
		$ids = implode(', ', $ids);
		return $ids;
	}

	public function getIdlvsEnlevement ($ids) {
		$stmt_query = "SELECT lv.id FROM lv
					   WHERE lv.id IN ($ids)
					   AND lv.idflux IN (SELECT id FROM fluxstatique WHERE fluxstatique.libelle = 'Enlèvement')";
		$stmt = new Zend_Db_Statement_Pdo($this->getDbTable()->getAdapter(), $stmt_query);
		$stmt->execute();
		return $stmt->fetchAll(Zend_Db::FETCH_COLUMN, 0);
	}

	public function getIdlvsTypeImpression ($ids, $type) {
		$stmt_query = "SELECT lv.id FROM lv
					   WHERE lv.id IN ($ids)
					   AND lv.idflux IN (SELECT id FROM fluxstatique WHERE fluxstatique.impression = '".$type."')";
		$stmt = new Zend_Db_Statement_Pdo($this->getDbTable()->getAdapter(), $stmt_query);
		$stmt->execute();
		return $stmt->fetchAll(Zend_Db::FETCH_COLUMN, 0);
	}
	
	public function cloture ($ids) {
		$return = false;
		$ids_enlevement = $this->getIdlvsEnlevement($ids);
		$ids = array(
			implode(', ', array_diff(explode(', ', $ids), $ids_enlevement)),
			implode(', ', $ids_enlevement)
		);
		for ($i = 0, $size_ids = count($ids); $i < $size_ids; ++$i) {
			if (!empty($ids[$i])) {
				$ids_impression = array(
					array('impression' => 'Locale', 'ids' => implode(', ', $this->getIdlvsTypeImpression($ids[$i], 'Locale'))),
					array('impression' => 'Dépôt', 'ids' => implode(', ', $this->getIdlvsTypeImpression($ids[$i], 'Dépôt')))
				);
				for ($j = 0, $size_ids_impression = count($ids_impression); $j < $size_ids_impression; ++$j) {
					if (!empty($ids_impression[$j]['ids'])) {
						$journal = $this->createJournal();
						$stmt_set = ($ids_impression[$j]['impression'] == 'Locale')
							? "(datecloture, dateimpression, numerolot) = (NOW(), NOW(), '".$journal."')"
							: "(datecloture, numerolot) = (NOW(), '".$journal."')";
						$stmt_query = "UPDATE lv
									   SET $stmt_set
									   WHERE id IN (".$ids_impression[$j]['ids'].")
									   AND idexpediteur = :prop
									   AND datecloture IS NULL
									   AND idflux IN (SELECT id FROM fluxstatique WHERE impression = '".$ids_impression[$j]['impression']."')
									   RETURNING numero, numerolot";
						$stmt = new Zend_Db_Statement_Pdo($this->getDbTable()->getAdapter(), $stmt_query);
						$stmt->execute(array(":prop" => PROPRIETAIRE));
						if ($stmt->rowCount() >= 1) {
							$results = $stmt->fetchAll(Zend_Db::FETCH_ASSOC);
							$this->logLotLv($results);
							$this->getDbTable()->getAdapter()->prepare("CALL cloture(:journal)")->execute(array(":journal" => $journal));
							$return = true;
						}
					}
				}
			}
		}
		return $return;
	}
	
	public function demandesuppression(array $ids, $motif) {
		if (count($ids) == 0 or empty($ids[0])) return false;
		$ids = implode(', ', $ids);
		$stmt = new Zend_Db_Statement_Pdo($this->getDbTable()->getAdapter(),
			"WITH demandesuppressioninsert AS (
			INSERT INTO demandesuppressionlv (idlv, motif)
			SELECT id, :motif FROM lv
			WHERE idexpediteur = :prop
			AND datecloture IS NOT NULL
			AND id IN ($ids)
			AND id NOT IN (SELECT idlv FROM demandesuppressionlv)
			RETURNING * )
SELECT lv.numero FROM lv
JOIN demandesuppressioninsert ON demandesuppressioninsert.idlv = lv.id");
		// ajouter propriétaire et cloturée
		$stmt->execute(array(':motif' => $motif, ':prop' => PROPRIETAIRE));
		if( $stmt->rowCount() == 0 ){
			return false;
		}else{
			$results = $stmt->fetchAll(Zend_db::FETCH_ASSOC);
			Zend_Registry::get('logger')->info("Deletion request for LV ".implode(', ', array_column( $results , "numero" ))." for the reason : ".$motif);
			return true;
		}
	}
	
	public function isDemandeSuppression($id) {
		$result = $this->getDbTable()->getAdapter()->select()->from('demandesuppressionlv','id')->where('idlv = ?', $id)->query()->fetch(Zend_Db::FETCH_OBJ);
		return ($result->id != null);
	}
	
	public function ordonner($ids) {
		$ids = implode(', ', $ids);
		$res = $this->getDbTable()->getAdapter()->select()->from('vuelv', array('departement', 'poidstotal', 'id', 'flux', 'impression'))->order(array('flux ASC','impression ASC', 'departement ASC', 'poidstotal DESC'))->where("id IN ($ids)")->query()->fetchAll(Zend_Db::FETCH_OBJ);
		$ret = array();
		foreach ($res as $lv) {
			if (!isset($ret[$lv->flux]))
				$ret[$lv->flux] = array("impression" => $lv->impression, "lv" => array());
			$ret[$lv->flux]["lv"][] = $lv->id;
		}
		return $ret;
	}
	
	public function getExpeNomComplet($ids) {
		$ids = implode(', ', $ids);
		$stmt = new Zend_Db_Statement_Pdo($this->getDbTable()->getAdapter(), "SELECT expediteur.nomcomplet FROM lv JOIN expediteur ON expediteur.idtiers = lv.idexpediteur WHERE id IN ($ids)");
		$stmt->execute();
		return $stmt->fetch(Zend_Db::FETCH_COLUMN);
	}
	
	private function existsFlux($idflux) {
		$stmt = new Zend_Db_Statement_Pdo($this->getDbTable()->getAdapter(), "SELECT id FROM fluxstatique WHERE libelle = (SELECT libelle FROM flux WHERE id = $idflux) AND impression = (SELECT impression FROM flux WHERE id = $idflux);");
		$stmt->execute();
		return $stmt->fetch(Zend_Db::FETCH_COLUMN);
	}
	
	public function saveFlux($idflux) {
		if ($id = $this->existsFlux($idflux)) return $id;
		$stmt = new Zend_Db_Statement_Pdo($this->getDbTable()->getAdapter(), "INSERT INTO fluxstatique(libelle, impression) SELECT libelle, impression FROM flux WHERE id = $idflux RETURNING id;");
		$stmt->execute();
		return $stmt->fetch(Zend_Db::FETCH_COLUMN);
	}

	public function updateFlux($idflux, $idlv) {
		$idfluxstatique = $this->saveFlux($idflux);
		$stmt = new Zend_Db_Statement_Pdo($this->getDbTable()->getAdapter(), "UPDATE lv SET idflux = :flux WHERE id = :id AND idexpediteur = :expediteur");
		$stmt->execute(array(
			'flux' => $idfluxstatique,
			'id' => $idlv,
			'expediteur' => PROPRIETAIRE
		));
	}
	
	private function estGroupable(Application_Model_LV $lv, $nbcolis, array $optionsCodes) {
		$em = new Application_Model_ExpediteurMapper();
		$o = $em->getOptions();

		if(count($optionsCodes) > 0){
			$optionsCodesStr = implode($optionsCodes, ',');
		}else{
			$optionsCodesStr = '';
		}

		$params = array(
				"exp" => $lv->getExpediteur(),
				"dst" => $lv->getDestinataire(),
				"pd" => $lv->getPortDu(),
				"tag" => $lv->getTag(),
				"idflux" => $lv->getIdFlux(),
				"dateclotureprevue" => $lv->getDateCloturePrevue(),
				"optionsCodes" => $optionsCodesStr
		);
		$sql = "WITH lvoptions AS (
SELECT
	lv.id,
	lv.idexpediteur,
	lv.dateclotureprevue,
	lv.datecreation,
	lv.tag,
	lv.idflux,
	lv.idadresseexpedition,
	lv.idadressedestination,
	lv.portdu,
	(SELECT count(*) FROM conteneur WHERE conteneur.idlv = lv.id) AS nbcolis,
	(SELECT coalesce(string_agg(option.code, ',' ORDER BY option.code DESC), '') -- la contrainte d'unicité de la table optionlv empèche qu'il y est plusieurs fois la même option pour une même lv
		FROM optionlv
		JOIN option ON option.id = optionlv.idoption
		WHERE optionlv.idlv = lv.id
	) AS options
	FROM lv
	WHERE lv.datecloture IS NULL
)
SELECT id, nbcolis
	FROM lvoptions
	WHERE
		(dateclotureprevue = :dateclotureprevue
		OR (
			dateclotureprevue = datecreation::date
			AND now()::date = :dateclotureprevue
			AND dateclotureprevue <= :dateclotureprevue
			)
		)
		AND idadresseexpedition = :exp
		AND idadressedestination = :dst
		AND portdu = :pd::boolean
		AND tag = :tag
		AND idflux = :idflux
		AND options = :optionsCodes";

		if ($o['limitecolis'] > 0) {
			$sql .=	"		AND nbcolis < :nb";
			$params['nb'] = $o['limitecolis'] - $nbcolis;
		}
		$sql .= "	ORDER BY nbcolis ASC;";
		$stmt = new Zend_Db_Statement_Pdo($this->getDbTable()->getAdapter(), $sql);
		
		$stmt->execute($params);
		
		$result = $stmt->fetch(Zend_Db::FETCH_OBJ);
		if (!$result) {
			return null;
		}
		return $result->id;
	}
	
	/* principe de groupage :
	 	En cours : date de cloture nulle
		N'est pas un bon d'enlèvement : non implémenté
		Même expéditeur : vérifié par l'adresse
		Même destinataire : inclus dans l'adresse
		Même adresse de destinataire : vérifié
		Même transporteur : une base par transporteur, pas de risque
		Même flux : vérifié
		Même tag : vérifié
		Même statut de port dû : vérifié
		Le nombre cumulé de colis des 2 lettres de voiture ne doit pas dépassé le nombre maximum de colis admissibles par lettre de voiture pour le transporteur : vérifié
		Même options: vérifié par la comparaison des codes concaténés
	*/
	
	public function datenow() {
		$sql = "SELECT now()::date;";
		$query = $this->getDbTable()->getAdapter()->query($sql);
		
		$res = $query->fetch(Zend_Db::FETCH_NUM);
		$date = explode ("-", $res[0]);
		$now = $date[2]."/".$date[1]."/".$date[0];
		return $now;
	}
	
	public function save(Application_Model_LV $lv, $nbcolis, array $optionsCodes) {
		$em = new Application_Model_ExpediteurMapper();
		$o = $em->getOptions();
		if (null === ($id = $lv->getId()) && ($nbcolis < $o['limitecolis'] || $o['limitecolis'] == 0)) // si la lv fournie n'a pas d'id et que le nombre de colis satisfait les restrictions du transporteur
		$id = $this->estGroupable($lv, $nbcolis, $optionsCodes);
		
		$data = array(
			":val"		=> round($lv->getValeurDeclaree() * 100),
			":inst"		=> $lv->getInstructions(),
			":msg"		=> $lv->getMessage(),
			":cr"		=> round($lv->getContreremboursementDeclare() * 100),
			":pd"		=> $lv->getPortDu()
		);
		if (null === ($id)) {
			if ($o['lvplanifiable']) {
				$sql = "INSERT INTO lv(idadresseexpedition, idadressedestination, valeurdeclaree, contreremboursementdeclare, portdu, message, instructions, idexpediteur, tag, idflux, dateclotureprevue) VALUES (:exped,:dest,:val,:cr,:pd,:msg,COALESCE(:inst,''),:prop,:tag,:idflux,:dateclotureprevue) RETURNING id;";
			}
			else {
				$sql = "INSERT INTO lv(idadresseexpedition, idadressedestination, valeurdeclaree, contreremboursementdeclare, portdu, message, instructions, idexpediteur, tag, idflux) VALUES (:exped,:dest,:val,:cr,:pd,:msg,COALESCE(:inst,''),:prop,:tag,:idflux) RETURNING id;";
			}
			$data[':prop'] = PROPRIETAIRE;
			$data[':exped'] = $lv->getExpediteur();
			$data[':dest'] = $lv->getDestinataire();
			$data[':tag'] = $lv->getTag();
			$data[':idflux'] = $lv->getIdFlux();
			if ($o['lvplanifiable'])
				$data[':dateclotureprevue'] = $lv->getDateCloturePrevue();
		} else { // groupage
			$sql = "UPDATE lv SET (valeurdeclaree, contreremboursementdeclare, portdu, message, instructions, datemodification) = (valeurdeclaree + :val,contreremboursementdeclare + :cr,:pd,coalesce(message,:msg),coalesce(instructions,:inst),'now'::timestamp without time zone) WHERE id = ".$id.";";
		}
		$stmt = new Zend_Db_Statement_Pdo($this->getDbTable()->getAdapter(), $sql);
		$stmt->execute($data);
		if ($id === null) {
			$id = $stmt->fetch(Zend_Db::FETCH_OBJ)->id;
		}

		if(count($optionsCodes) > 0){
			$optionLVMapper = new Application_Model_OptionLVMapper();
			$optionLVMapper->addOptionsToLv($optionsCodes, $id);
		}

		return $id;
	}
	
	public function fetch($lettre, $avecConformite = false) {
		$row = $this->getDbTable()->getAdapter()->select()->from('vuelv')->where("id = ?", $lettre)->where("idexpediteur = ?", PROPRIETAIRE)->query()->fetch(Zend_Db::FETCH_ASSOC);
		$ret = Application_Extension_StaticLib::row2Objlv($row);
		if ($avecConformite) {
			$ret->setConformite($row);
			$traces = $this->getDbTable()->getAdapter()->fetchAll("
				SELECT DISTINCT
				tracereport.id,
				to_char(tracereport.date, 'DD/MM/YYYY HH24:MI') date,
				CASE WHEN tracereport.justification = 'MQP' THEN typetrace_ihm.libelle || ' (' || nbanomalies || ')'
				ELSE typetrace_ihm.libelle END AS message, 
				acteurstatique.nom acteur,
				tracereport.note,
				trace.longitude, 
				trace.latitude
				FROM tracereport
				JOIN acteurstatique ON acteurstatique.id = tracereport.idacteur
				JOIN typetrace_ihm ON typetrace_ihm.justification = tracereport.justification AND typetrace_ihm.situation = tracereport.situation
				LEFT JOIN trace ON trace.idtracereport = tracereport.id
				WHERE tracereport.idlv = $lettre
				ORDER BY date DESC, tracereport.id DESC;");
			$ret->setTraces($traces);
		}
		return $ret;
	}
	
	public function getOldest() {
		return $this->getDbTable()->getAdapter()->select()->from('lv',array('premierelv' => new Zend_Db_Expr('min(datecreation)::date')))->where('idexpediteur = ?', PROPRIETAIRE)->query()->fetch(Zend_Db::FETCH_OBJ)->premierelv;
	}
	
	public function countLv($cloturee = false) {
		$req = $this->getDbTable()->getAdapter()->select()->from('vuelv','count(*)')->where('idexpediteur = ?', PROPRIETAIRE);
		if ($cloturee) {
			$req = $req->where('datecloture IS NOT NULL');
		} else {
			$req = $req->where('datecloture IS NULL');
		}
		$res = $req->query()->fetch(Zend_Db::FETCH_NUM);
		return $res[0];
	}
	
	public function countColis($cloturee = false) {
		$req = $this->getDbTable()->getAdapter()->select()->from('vuelv','sum(nbcolis)')->where('idexpediteur = ?', PROPRIETAIRE);
		if ($cloturee) {
			$req = $req->where('datecloture IS NOT NULL');
		} else {
			$req = $req->where('datecloture IS NULL');
		}
		$res = $req->query()->fetch(Zend_Db::FETCH_NUM);
		return $res[0];
	}
	
	public function find($id, Application_Model_LV $lettre) {
		if(!ctype_digit($id)) return false;
		$row = $this->getDbTable()->getAdapter()->select()->from('lv')
			->join('fluxstatique', 'lv.idflux = fluxstatique.id', array('flux' => 'libelle'))
			->where("lv.id = ?", $id)
			->where('idexpediteur = ?', PROPRIETAIRE)
			->where('datecloture IS NULL')
			->query()->fetch(Zend_Db::FETCH_OBJ);
		if ($row === false) {
			return false;
		}
		$lettre->setId($row->id)
			   ->setNumero($row->numero)
			   ->setExpediteur($row->idadresseexpedition)
			   ->setDestinataire($row->idadressedestination)
			   ->setValeurDeclaree($row->valeurdeclaree / 100)
			   ->setContreremboursementDeclare($row->contreremboursementdeclare / 100)
			   ->setContreremboursementCorrige( is_null( $row->contreremboursementcorrige ) ? null : $row->contreremboursementcorrige / 100 )
			   ->setPortDu($row->portdu)
			   ->setMessage($row->message)
			   ->setInstructions($row->instructions)
			   ->setProprietaire($row->idexpediteur)
			   ->setDateSaisie($row->datecreation)
			   ->setEmarge(empty($row->emarge) ? "" : $row->emarge)
			   ->setFlux($row->flux);
	return true;
	}
	
	public function findObj($id, Application_Model_ObjLV $lettre) {
		$row = $this->getDbTable()->getAdapter()->select()->from('vuelv')->where("id = ?", $id)->where('idexpediteur = ?', PROPRIETAIRE)->query()->fetch(Zend_Db::FETCH_ASSOC);
		if (0 == count($row)) {
			return;
		}
		
		Application_Extension_StaticLib::row2Objlv($row,$lettre);
		$lettre->setReferencesCommande($row['references']);
	}
	
	public function getNumeroLvNbColisDestByLvIds($listeIds) {
		$stmt = new Zend_Db_Statement_Pdo($this->getDbTable()->getAdapter(),
"SELECT lv.numero , count(conteneur.id) AS nbColis, 
	( adressestatique.nom || ' - ' || adressestatique.codepostal || ' ' || adressestatique.ville ) AS destinataire
FROM lv
JOIN conteneur ON lv.id = conteneur.idlv AND lv.id IN (".implode(', ', $listeIds).")
JOIN adressestatique ON adressestatique.id = lv.idadressedestination
WHERE lv.datecloture IS NOT NULL
GROUP BY lv.numero, destinataire");
		$stmt->execute();
		if( $stmt->rowCount() == 0 ){
			return false;
		}elseif( $stmt->rowCount() == 1 ){
			return array($stmt->fetch(Zend_Db::FETCH_ASSOC));
		}else{
			return $stmt->fetchAll(Zend_Db::FETCH_ASSOC);
		}
	}
	
	public function delete($id) {
		$stmt = new Zend_Db_Statement_Pdo($this->getDbTable()->getAdapter(), 
			"WITH todelete AS (
	SELECT lv.id, lv.numero lvnumero, datecreation, 
	array_to_string(array(SELECT numero FROM conteneur WHERE idlv =:id), ', ') cnumero
	FROM lv 
	WHERE lv.id = :id AND idexpediteur = :prop AND datecloture is null
)
DELETE FROM lv USING todelete WHERE lv.id=todelete.id RETURNING todelete.lvnumero, todelete.datecreation::date, todelete.cnumero;");
		$stmt->execute(array(":id" => $id, ":id" => $id, ":prop" => PROPRIETAIRE));
		if( $stmt->rowCount() != 1 ){
			return false;
		}else{
			$result = $stmt->fetch(Zend_Db::FETCH_ASSOC);
			Zend_Registry::get('logger')->info('Deleting LV '.$result["lvnumero"]
			.' created '.$result["datecreation"].' with parcels : '.$result["cnumero"]);
			return true;
		};
	}
	
	public function saveConteneur(Application_Model_Conteneur $conteneur, $checkCloturee = true) {
		$em = new Application_Model_ExpediteurMapper();
		$o = $em->getOptions();
		$limite = $o['limitecolis'];
		$infosParcel = $conteneur->getPoids()." g of ".$conteneur->getMarchandise().
				" made by ".$conteneur->getOperateur();
		if (count($this->fetchAllConteneurs($conteneur->getLettre())) >= $limite && $limite > 0) {
			Zend_Registry::get('logger')->warn(
				"Delivery id ".$conteneur->getLettre()." has reached its maximum number of parcels :".
				"Can't add parcel (".$infosParcel.")"
			);
			return;
		};
		if ($checkCloturee){
			if($this->isCloturee($conteneur->getLettre())) {
				Zend_Registry::get('logger')->warn(
					"Delivery id ".$conteneur->getLettre()." already consigned : ".
					"Can't add parcel (".$infosParcel.")"
				);
				return;
			};
		};
		$stmt = new Zend_Db_Statement_Pdo($this->getDbTable()->getAdapter(), "INSERT INTO conteneur (idlv, poidsdeclare, marchandise, operateur) VALUES (:lt,:pd,:mc, :op);");
		$stmt->execute(array(
				":lt"  => $conteneur->getLettre(),
				//#2598 : si l'utilisateur a saisie plusieurs colis avec un poids de 1g, la répartition du poids peut donner des colis de moins de 1g.
				":pd"  => $conteneur->getPoids() >= 1 ? $conteneur->getPoids() : 1,
				":mc"  => $conteneur->getMarchandise(),
				":op"  => $conteneur->getOperateur()
		));
	}
	
	public function deleteConteneur($id) {
		$stmt = new Zend_Db_Statement_Pdo($this->getDbTable()->getAdapter(), "DELETE FROM conteneur WHERE id = :id RETURNING numero");
		$stmt->execute(array(":id" => $id));
		if( $stmt->rowCount() > 0 ){
			$result = $stmt->fetch(Zend_Db::FETCH_ASSOC);
			Zend_Registry::get('logger')->info("Deleting parcel ".$result["numero"]);
			return true;
		}else{
			return false;
		}
	}
	
	public function fetchAllConteneurs($lettre, $newer = null) {
		if (empty($lettre)) return []; // bug 2146, à approfondir
		$resultSet = $this->getDbTable()->getAdapter()->select()->from('vueconteneur')->where("idlv = ?",$lettre)->order("id ASC");
		if (!is_null($newer)) {
			$resultSet = $resultSet->where("dateimpression IS NULL");
		}
		$resultSet = $resultSet->query()->fetchAll(Zend_Db::FETCH_OBJ);
		$entries = array();
		foreach ($resultSet as $row) {
			$entry = new Application_Model_Conteneur();
			$entry->setId($row->id)
				  ->setNumero($row->numero)
				  ->setLettre($row->idlv)
				  ->setPoids($row->poidsdeclare)
				  ->setPoidscorrige($row->poidsconstate)
				  ->setMarchandise($row->marchandise)
				  ->setOperateur($row->operateur)
				  ->setTourneeGroupe($row->tournee_groupe)
				  ->setTourneeNom($row->tournee_nom)
				  ->setReferencesCommande($row->references);
			$entries[] = $entry;
		}
		return $entries;
	}

	public function fetchAllConteneursWithTraces($idlettre) {
		$entries = $this->fetchAllConteneurs($idlettre);
		$ids = [];
		foreach ($entries as $entry) {
			$ids[] = $entry->id;
		}
		$results = $this->getDbTable()->getAdapter()->fetchAll("
SELECT
	trace.idconteneur,
	to_char(trace.date, 'DD/MM/YYYY HH24:MI') date,
	typetrace_ihm.libelle message,
	acteurstatique.nom acteur,
	trace.note,
	trace.longitude,
	trace.latitude,
	CASE 
	WHEN trace.situation IS NULL AND trace.justification IS NULL THEN 0 
	WHEN trace.situation IN ('LIV', 'PAQ') AND trace.justification = 'CFM' THEN 1 
	WHEN (trace.situation NOT IN ('LIV', 'PAQ') AND trace.justification = 'CFM') THEN 2 
	WHEN trace.situation = 'SOL'::text THEN 4 
	ELSE 0 
	END AS statutsuivi 
FROM trace
JOIN acteurstatique ON acteurstatique.id = trace.idacteur
LEFT JOIN typetrace_ihm ON typetrace_ihm.situation = trace.situation AND typetrace_ihm.justification = trace.justification 
WHERE trace.idconteneur IN (".implode(', ', $ids).")
ORDER BY trace.idconteneur ASC, trace.date DESC;");
		$traces = [];
		foreach ($results as $result) {
			$traces[$result['idconteneur']][] = $result;
		}
		foreach ($entries as &$entry) {
			if (isset($traces[$entry->getId()]))
				$entry->setTraces($traces[$entry->getId()]);
		}
		return $entries;
	}
	
	public function fetchAllCommandes($lettre) {
		return $this->getDbTable()->getAdapter()->select()
												->from('commande',array('reference','id'))
												->where('idlv = ?', $lettre)
												->order('id ASC')
												->query()
												->fetchAll(Zend_db::FETCH_ASSOC);
	}
	
	public function fetchDecalageConteneur($lettre) {
		if (empty($lettre)) return 0; // bug 2145, à approfondir
		return $this->getDbTable()->getAdapter()->select()
												->from("conteneur", "COUNT(*)")
												->where("dateimpression IS NOT NULL")
												->where("idlv = ?", $lettre)
												->query()
												->fetch(Zend_Db::FETCH_COLUMN);
	}
	
	public function imprimeConteneurs($lettre) {
		$sql = "UPDATE conteneur SET dateimpression = NOW() WHERE idlv = :id RETURNING numero";
		$stmt = new Zend_Db_Statement_Pdo($this->getDbTable()->getAdapter(), $sql.";");
		$stmt->execute(array(":id" => $lettre));
		$retour = $stmt->fetchAll(Zend_Db::FETCH_ASSOC);
		Zend_Registry::get('logger')->info("Printing parcel label ".implode(', ', array_column( $retour , "numero" )));
		return $stmt->rowCount() < 1;
	}
	
	public function existsMarchandise($marchandise) {
		$row = $this->getDbTable()->getAdapter()->select()->from('marchandise')->where("libelle = ?", $marchandise)->where("idexpediteur = ?",PROPRIETAIRE)->query()->fetch(Zend_Db::FETCH_OBJ);
		return (boolean) $row;
	}
	
	public function saveMarchandise($marchandise) {
		if ($this->existsMarchandise($marchandise) || strlen(trim($marchandise)) == 0) return;
		$stmt = new Zend_Db_Statement_Pdo($this->getDbTable()->getAdapter(), "INSERT INTO marchandise (libelle, idexpediteur) VALUES (:nom,:prop)");
		$stmt->execute(array(":nom" => $marchandise, ":prop" => PROPRIETAIRE));
	}
	
	public function fetchAllMarchandises() {
		$resultSet = $this->getDbTable()->getAdapter()->select()->from('marchandise','libelle')->where("idexpediteur = ?",PROPRIETAIRE)->query()->fetchAll(Zend_Db::FETCH_OBJ);
		$entries = array();
		foreach ($resultSet as $row) {
			$entries[$row->libelle] = $row->libelle;
		}
		return $entries;
	}
	
	public function existsOperateur($operateur) {
		$row = $this->getDbTable()->getAdapter()->select()->from('operateur')->where("libelle = ?", $operateur)->where("idexpediteur = ?",PROPRIETAIRE)->query()->fetch(Zend_Db::FETCH_OBJ);
		return (boolean) $row;
	}
	
	public function saveOperateur($operateur) {
		if ($this->existsOperateur($operateur) || strlen(trim($operateur)) == 0) return;
		$stmt = new Zend_Db_Statement_Pdo($this->getDbTable()->getAdapter(), "INSERT INTO operateur (libelle, idexpediteur) VALUES (:nom,:prop)");
		$stmt->execute(array(":nom" => $operateur, ":prop" => PROPRIETAIRE));
	}
	
	public function fetchAllOperateurs() {
		$resultSet = $this->getDbTable()->getAdapter()->select()->from('operateur','libelle')->where("idexpediteur = ?",PROPRIETAIRE)->query()->fetchAll(Zend_Db::FETCH_OBJ);
		$entries = array();
		foreach ($resultSet as $row) {
			$entries[$row->libelle] = $row->libelle;
		}
		return $entries;
	}
	
	public function saveCommande($commande, $lv) {
		$stmt = new Zend_Db_Statement_Pdo($this->getDbTable()->getAdapter(), "INSERT INTO commande (idlv, reference) VALUES (:lv,:ref)");
		$stmt->execute(array(":lv" => $lv, ":ref" => $commande));
	}
	
	public function deleteCommandeDelta(array $commandes, $lv) {
		if (count($commandes) > 0) {
			$sql = "DELETE FROM commande WHERE idlv = :lv AND id NOT IN (".implode(", ", $commandes).")";
		} else {
			$sql = "DELETE FROM commande WHERE idlv = :lv";
		}
		$stmt = new Zend_Db_Statement_Pdo($this->getDbTable()->getAdapter(), $sql);
		$stmt->execute(array(":lv" => $lv));
	}
	
	public function existsInstructions($instructions) {
		$row = $this->getDbTable()->getAdapter()->select()->from('instructions')->where("libelle = ?", $instructions)->where("idexpediteur = ?",PROPRIETAIRE)->query()->fetch(Zend_Db::FETCH_OBJ);
		return (boolean) $row;
	}
	
	public function saveInstructions($instructions) {
		if ($this->existsInstructions($instructions) || strlen($instructions) == 0) return;
		$stmt = new Zend_Db_Statement_Pdo($this->getDbTable()->getAdapter(), "INSERT INTO instructions (idexpediteur, libelle) VALUES (:prop,:lib)");
		$stmt->execute(array(":prop" => PROPRIETAIRE, ":lib" => $instructions));
	}
	
	public function fetchAllInstructions() {
		$resultSet = $this->getDbTable()->getAdapter()->select()->from('instructions',array('id','libelle'))->where("idexpediteur = ?",PROPRIETAIRE)->query()->fetchAll(Zend_Db::FETCH_OBJ);
		$entries = array();
		foreach ($resultSet as $row) {
			$entries[$row->libelle] = $row->libelle;
		}
		return $entries;
	}
	
	public function fetchAllObj() {
		$resultSet = $this->getDbTable()->getAdapter()->select()->from('vuelv')->where('idexpediteur = ?', PROPRIETAIRE)->order('datecloture DESC')->query()->fetchAll(Zend_Db::FETCH_ASSOC);
		$entries = array();
		
		foreach ($resultSet as $row) {
			$entry = new Application_Model_ObjLV($row);
			$entry->setExpediteur(array(
					"nom" 			=> $row['expediteur_nom'],
					"ligne1"		=> $row['expediteur_ligne1'],
					"ligne2" 		=> $row['expediteur_ligne2'],
					"ligne3"		=> $row['expediteur_ligne3'],
					"ligne4" 		=> $row['expediteur_ligne4'],
					"codepostal"	=> $row['expediteur_codepostal'],
					"ville"			=> $row['expediteur_ville']
			));
			$entry->setDestinataire(array(
					"nom"			=> $row['destinataire_nom'],
					"ligne1"		=> $row['destinataire_ligne1'],
					"ligne2"		=> $row['destinataire_ligne2'],
					"ligne3"		=> $row['destinataire_ligne3'],
					"ligne4"		=> $row['destinataire_ligne4'],
					"codepostal"	=> $row['destinataire_codepostal'],
					"ville"			=> $row['destinataire_ville']
			));
			$entries[] = $entry;
		}
		return $entries;
	}
	
	public function fetchAllFlux() {
		return $this->getDbTable()->getAdapter()->select()->from('flux')->where('idexpediteur = ?', PROPRIETAIRE)->order('id')->query()->fetchAll(Zend_Db::FETCH_ASSOC);
	}
	
	public function fetchAllUsedFlux() {
		$requete = $this->getDbTable()->getAdapter()->select()
												->distinct()
												->from('lv',array())
												->join('fluxstatique', 'lv.idflux = fluxstatique.id')
												->where('lv.idexpediteur = ?', PROPRIETAIRE)
												->where('lv.datecloture IS NOT NULL')
												->order('libelle ASC');
		return $requete->query()->fetchAll(Zend_Db::FETCH_ASSOC);
	}
	
	public function fetchAllDestinataires() {
		$reqNom = new Zend_Db_Statement_Pdo(
				$this->getDbTable()->getAdapter(),
				"SELECT adressestatique.nom
				FROM adressestatique JOIN lv ON lv.idadressedestination = adressestatique.id
				WHERE idexpediteur = :id AND datecloture IS NOT NULL GROUP BY nom ORDER BY nom ASC;");
		// une étude mexicaine a prouvé que prendre une dose supérieure à une cuillère à café (5ml) de harissa dans un kebab rend son consommateur enclin à l'exagération quant à la taille de ses attributs
		// l'étude a également prouvé que lesdits attributs rétrécissent de 5% de leur taille pour chaque kebab dépassant la dose de harissa préconisée
		$reqRef = new Zend_Db_Statement_Pdo(
				$this->getDbTable()->getAdapter(),
				"SELECT adressestatique.reference
				FROM adressestatique JOIN lv ON lv.idadressedestination = adressestatique.id
				WHERE idexpediteur = :id AND datecloture IS NOT NULL GROUP BY reference ORDER BY reference ASC;");
		$reqNom->execute(array("id" => PROPRIETAIRE));
		$reqRef->execute(array("id" => PROPRIETAIRE));
		$resNom = $reqNom->fetchAll(Zend_Db::FETCH_ASSOC);
		$resRef = $reqRef->fetchAll(Zend_Db::FETCH_ASSOC);
		return array("parnom" => $resNom, "parref" => $resRef); // tableau contenant "parnom" et "parref" qui contiennent chacun des groupements d'id et leur discriminant
	}
	
	public function getNextVal($sequence) {
		$i = Application_Model_ParametresMapper::getParametre('indicenumero');
		if ($i === null) { // nouveau transporteur, pas de recoupement à éviter
			$stmt = new Zend_Db_Statement_Pdo($this->getDbTable()->getAdapter(), "SELECT nextval(:seq) AS n;");
			$stmt->execute(array("seq" => $sequence));
			return base_convert($stmt->fetch(Zend_Db::FETCH_OBJ)->n, 10, 36);
		}
		do {
			$stmt = new Zend_Db_Statement_Pdo($this->getDbTable()->getAdapter(), "SELECT nextval(:seq) AS n;");
			$stmt->execute(array("seq" => $sequence));
			$n = base_convert($stmt->fetch(Zend_Db::FETCH_OBJ)->n, 10, 36);
		} while (strlen($n) < $i && ctype_digit($n));
		return $n;
	}
	
	public function getFluxEnlevement($impression) {
		$sql = "SELECT id FROM fluxstatique WHERE libelle = 'Enlèvement' AND impression = '$impression'::impression;";
		$stmt = new Zend_Db_Statement_Pdo($this->getDbTable()->getAdapter(), $sql);
		$stmt->execute();
		$id = $stmt->fetch(Zend_Db::FETCH_COLUMN);
		if ($id) return $id;
		$sql = "INSERT INTO fluxstatique (libelle, impression) VALUES ('Enlèvement', '$impression') RETURNING id;";
		$stmt = new Zend_Db_Statement_Pdo($this->getDbTable()->getAdapter(), $sql);
		$stmt->execute();
		return $stmt->fetch(Zend_Db::FETCH_COLUMN);
	}
	
	public function getStats() {
		return $this->getDbTable()->getAdapter()->select()->from('vuestats')->query()->fetchAll(Zend_Db::FETCH_OBJ);
	}
	
	public static function getNblv() {
		$ret = Zend_Db_Table_Abstract::getDefaultAdapter()->select()->from('lv','COUNT(*)')->query()->fetch(Zend_Db::FETCH_NUM);
		return $ret[0];
	}
	
	public function changeDateCloturePrevue($id, $date){
		$stmt = new Zend_Db_Statement_Pdo($this->getDbTable()->getAdapter(), "UPDATE lv SET dateclotureprevue = '$date'::timestamp WHERE id = $id;");
		$stmt->execute();
	}

	private function logLotLv($fetchedArray){
		Zend_Registry::get('logger')->info('Closing batch '.$fetchedArray[0]["numerolot"]);
	}

	public function getNbLvColis(){
		$sql = "SELECT lv.idexpediteur, lv.createur, 'aujourdhui'::text AS periode, 
				count(DISTINCT conteneur.idlv) AS nblv, count(*) AS nbcolis
			FROM conteneur
			JOIN lv ON lv.id = conteneur.idlv
				AND lv.datecloture > date_trunc('day'::text, now())
			GROUP BY lv.idexpediteur, lv.createur
		UNION
		SELECT lv.idexpediteur, lv.createur, 'encours'::text AS periode, 
				count(DISTINCT conteneur.idlv) AS nblv, count(*) AS nbcolis
			FROM conteneur
			JOIN lv ON lv.id = conteneur.idlv
				AND lv.datecloture IS NULL
			GROUP BY lv.idexpediteur, lv.createur
		ORDER BY createur";

	$stmt = new Zend_Db_Statement_Pdo($this->getDbTable()->getAdapter(), $sql);
	$stmt->execute();

	return $stmt->fetchAll(Zend_Db::FETCH_ASSOC);
	}

	public function getNbLvSemaine($nbSemaine){
		if(is_numeric($nbSemaine)) $nbSemaine=intval($nbSemaine);
		else $nbSemaine = 4;
		
		$sql = "SELECT idexpediteur, createur, EXTRACT('week' FROM datecloture)::text periode, COUNT(*) nblv
				FROM lv
				WHERE datecloture > date_trunc('week'::text, now() - '$nbSemaine week'::interval)
				GROUP BY idexpediteur, createur, EXTRACT('week' FROM datecloture)
			ORDER BY createur";

	$stmt = new Zend_Db_Statement_Pdo($this->getDbTable()->getAdapter(), $sql);
	$stmt->execute();

	return $stmt->fetchAll(Zend_Db::FETCH_ASSOC);
	}

	public function getNbLvAnnee($annee){
		if(is_numeric($annee)) $annee=intval($annee);
		else $annee = false;
		
		if($annee){
			$sql = "SELECT idexpediteur, createur, '$annee' periode, COUNT(*) nblv
					FROM lv
					WHERE datecloture BETWEEN date_trunc('year'::text, timestamp '$annee-01-01') 
						AND date_trunc('year'::text, timestamp '$annee-01-01' + '1 year'::interval)
					GROUP BY idexpediteur, createur
				ORDER BY createur";
		}else{
			$sql = "SELECT idexpediteur, createur, 'cetteannee' periode, COUNT(*) nblv
					FROM lv
					WHERE datecloture > date_trunc('year'::text, now() )
					GROUP BY idexpediteur, createur
				ORDER BY createur";
		}

	$stmt = new Zend_Db_Statement_Pdo($this->getDbTable()->getAdapter(), $sql);
	$stmt->execute();

	return $stmt->fetchAll(Zend_Db::FETCH_ASSOC);
	}

	public function getNbLvTotal(){
		$sql = "SELECT idexpediteur, createur, 'total' periode, COUNT(*) nblv
				FROM lv
				WHERE datecloture IS NOT NULL
				GROUP BY idexpediteur, createur
			ORDER BY createur";

	$stmt = new Zend_Db_Statement_Pdo($this->getDbTable()->getAdapter(), $sql);
	$stmt->execute();

	return $stmt->fetchAll(Zend_Db::FETCH_ASSOC);
	}

	public function getLvPremiereDerniere(){
		$sql = "SELECT idexpediteur, to_char( MIN(datecloture) , 'DD/MM/YYYY') premiere, to_char( MAX(datecloture) , 'DD/MM/YYYY') derniere
			FROM lv
			GROUP BY idexpediteur
			ORDER BY idexpediteur";

	$stmt = new Zend_Db_Statement_Pdo($this->getDbTable()->getAdapter(), $sql);
	$stmt->execute();

	return $stmt->fetchAll(Zend_Db::FETCH_ASSOC);
	}

	public function aEtiquetteAImprimer($idlv){
		$retour = false;
		if( is_numeric($idlv) && $idlv == abs($idlv) ){
			$result = $this->getDbTable()->getAdapter()->select()
				->from('conteneur', array('count(*)'))
				->where("idlv = $idlv")
				->where("dateimpression IS NULL")
				->query()
				->fetch(Zend_Db::FETCH_ASSOC);
			$retour = $result["count"] > 0;
		};
		return $retour;
	}

}

