<?php

class Application_Model_Marchandise
{
	protected $_id;
	protected $_nom;
	
	public function __construct(array $options = null) {
		if (is_array($options)) {
			foreach ($options as $nom => $val) {
				try {
					$this->__set($nom, $val);
				} catch (Exception $e) {
				}
			}
		}
	}
	
	public function __set($name, $value)
	{
		$method = 'set' . $name;
		if (('mapper' == $name) || !method_exists($this, $method)) {
			throw new Exception('Invalid conteneur property');
		}
		$this->$method($value);
	}
	
	public function __get($name)
	{
		$method = 'get' . $name;
		if (('mapper' == $name) || !method_exists($this, $method)) {
			throw new Exception('Invalid conteneur property');
		}
		return $this->$method();
	}
	/**
	 * @return the $_nom
	 */
	public function getNom() {
		return $this->_nom;
	}

	/**
	 * @param field_type $_nom
	 */
	public function setNom($_nom) {
		$this->_nom = $_nom;
		return $this;
	}
	/**
	 * @return the $_id
	 */
	public function getId() {
		return $this->_id;
	}

	/**
	 * @param field_type $_id
	 */
	public function setId($_id) {
		$this->_id = $_id;
		return $this;
	}



}

