<?php

class Application_Model_ObjLV extends Application_Model_LV {
	
	protected $_nbcolis;
	protected $_marchandises;
	protected $_poidstotal;
	protected $_poidstotaldeclare;
	protected $_poidstotalconstate;
	protected $_references;
	protected $_operateurs;
	protected $_datecloture;
	protected $_dateimpression;
	protected $_expediteurObj;
	protected $_destinataireObj;
	protected $_enlevement;
	protected $_conformite;
	protected $_facturation;
	protected $_traces;
	protected $_optionsObj = [];
	
	//redéfinition des accesseurs afin d'obtenir les objets
	public function getDestinataire() {
		return $this->_destinataireObj;
	}
	
	public function getExpediteur() {
		return $this->_expediteurObj;
	}
	
	public function setDestinataire($destinataire) {
		if (is_array($destinataire)) {
			$this->_destinataireObj = new Application_Model_AdresseStatique($destinataire);
		} elseif ($destinataire instanceof Application_Model_AdresseStatique) {
			$this->_destinataireObj = $destinataire;
		} else {
			//throw new Exception("Les propriétés objets ne peuvent être définies qu'à l'aide d'instances de cette classe ou de tableau associatif");
		}
		return $this;
	}
	
	public function setExpediteur($expediteur) {
		if (is_array($expediteur)) {
			$this->_expediteurObj = new Application_Model_AdresseStatique($expediteur);
		} elseif ($expediteur instanceof Application_Model_AdresseStatique) {
			$this->_expediteurObj = $expediteur;
		} else {
			//throw new Exception("Les propriétés objets ne peuvent être définies qu'à l'aide d'instances de cette classe ou de tableau associatif");
		}
		return $this;
	}
	
	public function getNbColis() {
		return $this->_nbcolis;
	}

	public function getMarchandises() {
		return $this->_marchandises;
	}

	public function getPoidsCorrigeEnKg() {
		if ($this->_poidstotalconstate > 0 && $this->_poidstotaldeclare != $this->_poidstotalconstate) {
			return '<span class="lgf-lv-poidscorrige">'.($this->_poidstotaldeclare/1000).'</span> '.($this->_poidstotalconstate/1000)." kg";
		}
		return ($this->_poidstotaldeclare/1000)." kg";
	}
	
	public function getPoidsEnKg() {
		if ($this->_poidstotalconstate > 0 && $this->_poidstotaldeclare != $this->_poidstotalconstate) {
			return ($this->_poidstotalconstate/1000)." kg";
		}
		return ($this->_poidstotaldeclare/1000)." kg";
	}
	
	public function getEstCorrigee() {
		return $this->_poidstotalconstate > 0 && $this->_poidstotaldeclare != $this->_poidstotalconstate;
	}
	
	public function getReferences() {
		return $this->_references;
	}

	public function getOperateurs() {
		return $this->_operateurs;
	}

	public function setOperateurs($_operateurs) {
		$this->_operateurs = $_operateurs;
		return $this;
	}
	
	public function setNbColis($_nbcolis) {
		$this->_nbcolis = $_nbcolis;
		return $this;
	}

	public function setMarchandises($_marchandises) {
		$this->_marchandises = $_marchandises;
		return $this;
	}

	public function setReferences($_references) {
		$this->_references = $_references;
		return $this;
	}
	public function getDateCloture() {
		return $this->_datecloture;
	}

	public function setDateCloture($_datecloture) {
		$this->_datecloture = date(self::FORMAT_DATE,strtotime($_datecloture));
		return $this;
	}
	public function getDateImpression() {
		return $this->_dateimpression;
	}

	public function setDateImpression($_dateimpression) {
		($_dateimpression !== null)?$this->_dateimpression = date(self::FORMAT_DATE_COURT,strtotime($_dateimpression)):$this->_dateimpression = " jamais";
		return $this;
	}
	
	public function getPoidsTotal() {
		return $this->_poidstotal;
	}
	
	public function getPoidsTotalDeclare() {
		return $this->_poidstotaldeclare;
	}
	
	public function getPoidsTotalDeclareEnKg() {
		return ($this->_poidstotaldeclare/1000). 'kg';
	}

	public function getPoidsTotalConstate() {
		return $this->_poidstotalconstate;
	}
	
	public function getPoidsTotalConstateEnKg() {
		if ($this->_poidstotalconstate > 0)
			return ($this->_poidstotalconstate/1000). 'kg';
		return "poids ok";
	}

	public function setPoidsTotal($_poidstotal) {
		$this->_poidstotal = $_poidstotal;
		return $this;
	}
	
	public function setPoidsTotalDeclare($_poidstotaldeclare) {
		$this->_poidstotaldeclare = $_poidstotaldeclare;
		return $this;
	}

	public function setPoidsTotalConstate($_poidstotalconstate) {
		$this->_poidstotalconstate = $_poidstotalconstate;
		return $this;
	}
	public function getEnlevement() {
		return $this->_enlevement;
	}

	public function setEnlevement($_enlevement) {
		$this->_enlevement = $_enlevement;
		return $this;
	}

	public function getConformite() {
		return $this->_conformite;
	}

	public function setConformite($row, $codeSuivi = null) {
    	if(!is_array($row)){
      		$this->_erreurs[] = __METHOD__." : Tableau attendu comme 1er paramètre";
      		return $this;
    	}
    	if(is_null($codeSuivi)) {
      		$codeSuivi = Application_Extension_StaticLib::getCodeSuivi();
    	}
    
    	if($row["statutsuivi"] != 0) {
       		$libelle = $codeSuivi[$row["dernieretrace_type"]]["libelle"]; 
    	} else { 
      		$libelle = "Aucune information de suivi"; 
    	};
    	$this->_conformite = array(
			'statut'=>$row["statutsuivi"], 
    		'date'=>$row['dernieretrace_date'], 
    		'type'=>$row['dernieretrace_type'],
    		'libelle'=>$libelle
		);
		return $this;
	}

	public function getFacturation() {
		return $this->_facturation;
	}

	public function setFacturation($row, $facturation) {
		$this->_facturation = array(
			'refs'=>$facturation['refs'],
			'puht'=>$facturation['puht']
		);
		return $this;
	}

	public function getTraces() {
		return $this->_traces;
	}

	public function setTraces($_traces) {
		$this->_traces = $_traces;
		return $this;
	}

	public function getOptions() {
		return $this->_optionsObj;
	}

	public function setOptions($optionsStr) {
		if(!empty($optionsStr)){
			$optionsArray = explode("#", $optionsStr);
			$optionLVmapper = new Application_Model_OptionLVMapper();
			for ($i=0; $i < count($optionsArray); $i = $i+2) {
				$this->addOption(new Application_Model_OptionLV(
					$optionsArray[$i],
					intval($optionsArray[$i+1]),
					$optionLVmapper->getLibelleWithCode($optionsArray[$i])
				));
			}
		}
		return $this;
	}

	public function addOption($option) {
		if (is_array($option)) {
			array_push($this->_optionsObj, Application_Model_OptionLV::fromArray($option));
		} elseif ($option instanceof Application_Model_OptionLV) {
			array_push($this->_optionsObj, $option);
		} else {
			throw new Exception("Valeur d'entrée non supporté.");
		}
		return $this;
	}
}

