<?php

class Application_Model_OptionLV implements JsonSerializable {
  protected $_code;
  protected $_quantite;
  protected $_libelle;

  public function __construct($code, $quantite = null, $libelle = null) {
    $this->_code = $code;
    $this->setQuantite($quantite);
    $this->setLibelle($libelle);
  }

  public static function fromArray(array $array){
    switch (count($array)) {
      case '3':
        return new Application_Model_OptionLV($array[0],$array[1],$array[2]);
        break;
      case '2':
        return new Application_Model_OptionLV($array[0],$array[1]);
        break;
      case '1':
        return new Application_Model_OptionLV($array[0]);
        break;
    }
  }

  public function jsonSerialize() {
      return $this->getCode();
  }

  public function __toString() {
      return $this->getCode();
  }

  public function getCode(){
    return $this->_code;
  }

  public function getQuantite(){
    return $this->_quantite;
  }

  public function setQuantite($quantite){
    if(is_int($quantite)){
      $this->_quantite = $quantite;
    }else{
      $this->_quantite = 1;
    }
    return $this;
  }

  public function getLibelle(){
    if(empty($this->_libelle)){
      return $this->_code;
    }else{
      return $this->_libelle;
    }
  }

  public function setLibelle($libelle){
    // il n'y à pas de raison de redéfinir un libelle existant
    if(empty($this->_libelle) && !empty($libelle)){
      $this->_libelle = $libelle;
    }
    return $this;
  }
}