<?php

class Application_Model_OptionLVMapper {
  const ENV_VAR_NAME = "OPTIONS_LV_AVAIBLE";
  protected $_dbTable;
  protected $_libellesIndexeParCodes;

  public function setDbTable($dbTable)
  {
    if (is_string($dbTable)) {
      $dbTable = new $dbTable();
    }
    if (!$dbTable instanceof Zend_Db_Table_Abstract) {
      throw new Exception('Invalid table data gateway provided');
    }
    $this->_dbTable = $dbTable;
    return $this;
  }

  public function getDbTable()
  {
    if (null === $this->_dbTable) {
      $this->setDbTable('Application_Model_DbTable_OptionLV');
    }
    return $this->_dbTable;
  }

  public function getOptionsDisponibles(){
    $options = [];
    $codesToLibelles = $this->getLibellesIndexeParCodes();
    foreach ($codesToLibelles as $code => $libelle) {
      array_push($options, new Application_Model_OptionLV($code, null, $libelle));
    }
    return $options;
  }

  public function getLibellesIndexeParCodes(){
    if(is_null($this->_libellesIndexeParCodes)){
      $this->_libellesIndexeParCodes = [];
      if(getenv(self::ENV_VAR_NAME)){
        $optionsArray = explode(",",getenv(self::ENV_VAR_NAME));
        foreach ($optionsArray as $codeLibelle) {
           $array = explode("#", $codeLibelle);
           $code = $array[0];
           $libelle = $array[1];
           unset($array);
          $this->_libellesIndexeParCodes[$code] = $libelle;
        }
      }
    }
  return $this->_libellesIndexeParCodes;
  }

  public function getLibelleWithCode($code){
    $codesToLibelle = $this->getLibellesIndexeParCodes();
    if(empty($codesToLibelle[$code])){
      return null;
    }else{
      return $codesToLibelle[$code];
    }
  }

  public function addOptionToLV(Application_Model_OptionLV $option, $idlv){
    $data = [
      ":code"=>$option->getCode(),
      "idlv"=>$idlv
    ];
    $sql = "INSERT INTO public.optionlv (idoption,idlv) VALUES (public.idoption(:code),:idlv);";
    $stmt = new Zend_Db_Statement_Pdo($this->getDbTable()->getAdapter(), $sql);
    try{
      $stmt->execute($data);
    }catch(Exception $e){
      Zend_Registry::get('logger')->err(__METHOD__."() catch exception \$exception : "
        .print_r($e,true)." when try to add ".$option->getCode()." to lv id ".$idlv);
    }
  }

  public function addOptionsToLv(array $optionsCodes, $idlv){
    foreach ($optionsCodes as $optionCode ) {
      $this->addOptionToLV(new Application_Model_OptionLV($optionCode), $idlv);
    }
  }
}
