<?php

class Application_Model_ParametresMapper
{
	private static $_adapter = null;
	private static $_data = array();
	private static $_revision;
	
	public static function existe($id) {
		if (self::$_adapter == null) {
			self::$_adapter = Zend_Db_Table_Abstract::getDefaultAdapter();
		}
		return self::$_adapter->select()->from('expediteur', 'COUNT(*)')
										->join('tiers','tiers.id = expediteur.idtiers', array())
										->where('tiers.reference = ?',$id)
										->query()
										->fetch(Zend_Db::FETCH_COLUMN) == 1;
	}
	
	public static function setDernierClient ($user_agent, $id) {
		if (self::$_adapter == null) {
			self::$_adapter = Zend_Db_Table_Abstract::getDefaultAdapter();
		}
		
		$data = array (
			'dernierclient' => $user_agent
		);
		
		return self::$_adapter->update('expediteur', $data, 'idtiers IN (SELECT idtiers FROM expediteur) AND idtiers = (SELECT id FROM tiers WHERE reference = \'' . $id . '\' LIMIT 1)');
	}
	
	public static function setDerniereIp ($remote_addr, $id) {
		if (self::$_adapter == null) {
			self::$_adapter = Zend_Db_Table_Abstract::getDefaultAdapter();
		}
		
		$data = array (
			'derniereip' => $remote_addr
		);
		
		return self::$_adapter->update('expediteur', $data, 'idtiers IN (SELECT idtiers FROM expediteur) AND idtiers = (SELECT id FROM tiers WHERE reference = \'' . $id . '\' LIMIT 1)');
	}
	
	public static function estUtilisable($id) {
		if (self::$_adapter == null) {
			self::$_adapter = Zend_Db_Table_Abstract::getDefaultAdapter();
		}
		return self::$_adapter->select()->from('expediteur','estutilisable')
										->join('tiers','tiers.id = expediteur.idtiers')
										->where('tiers.reference = ?',$id)
										->query()
										->fetch(Zend_Db::FETCH_OBJ)->estutilisable;
	}
	
	public static function getParametre($nom) {
		if (self::$_adapter == null) {
			self::$_adapter = Zend_Db_Table_Abstract::getDefaultAdapter();
		}
		if (isset(self::$_data[$nom])) return self::$_data[$nom];
		return self::$_data[$nom] = self::$_adapter->select()->from('parametres','valeur')
															 ->where('cle = ?',$nom)
															 ->query()
															 ->fetch(Zend_Db::FETCH_OBJ)->valeur;
	}
	
	public static function getRevision() {
		if (isset(self::$_revision)) return self::$_revision;
		$vars = explode(" ",trim(file_get_contents(APPLICATION_PATH."/version")," ".PHP_EOL));
		return self::$_revision = $vars[0];
	}
	
	public static function getUserList() {
		if (self::$_adapter == null) {
			self::$_adapter = Zend_Db_Table_Abstract::getDefaultAdapter();
		}
		$result = self::$_adapter->select()->from('vueexpediteur', array('id', 'reference'))
										   ->where("estutilisable = 'true'::boolean")
										   ->order('reference ASC')
										   ->query()
										   ->fetchAll(Zend_Db::FETCH_OBJ);
		$return = array();
		foreach ($result as $user) {
			$return[$user->id] = $user->reference;
		}
		return $return;
	}
	
	public function getMailA() {
		if (self::$_adapter == null) {
			self::$_adapter = Zend_Db_Table_Abstract::getDefaultAdapter();
		}
		return self::$_adapter->select()->from('parametres','valeur')
										->where('cle LIKE ?','maila%')
										->query()
										->fetchAll(Zend_Db::FETCH_COLUMN);
	}
	
	public function getMailCC() {
		if (self::$_adapter == null) {
			self::$_adapter = Zend_Db_Table_Abstract::getDefaultAdapter();
		}
		return self::$_adapter->select()->from('parametres','valeur')
										->where('cle LIKE ?','mailcc%')
										->query()
										->fetchAll(Zend_Db::FETCH_COLUMN);
	}
	
	public function getMailEtiquette() {
		if (self::$_adapter == null) {
			self::$_adapter = Zend_Db_Table_Abstract::getDefaultAdapter();
		}
		return self::$_adapter->select()->from('parametres','valeur')
										->where('cle LIKE ?','mailetiquette%')
										->query()
										->fetchAll(Zend_Db::FETCH_COLUMN);
	}
}

