<?php

class Application_Model_Particulier extends Application_Model_Contact
{
	private $_conciliant;
	
	protected $_nom;
	protected $_prenom;
	protected $_civilite;
 
	/**
	 * Constructeur du parent (Application_Model_Tiers)
	 * Un second paramètre optionnel, la conciliance, peut être fourni : s'il vaut true, l'appel d'accesseurs non définis renverra null plutôt que lever une exception. Par défaut, ce paramètre vaut false.
	 * @param array $options
	 * @param boolean $gentil
	 */
	public function __construct(array $options = null, $gentil = false) {
    	parent::__construct($options);
    	$this->_conciliant = $gentil;
    }
	
    public function __set($name, $value)
    {
        $method = 'set' . $name;
        if (('mapper' == $name) || !method_exists($this, $method)) {
        	if ($this->_conciliant) return null;
            throw new Exception('Invalid particulier property');
        }
        $this->$method($value);
    }
 
    public function __get($name)
    {
        $method = 'get' . $name;
        if (('mapper' == $name) || !method_exists($this, $method)) {
        	if ($this->_conciliant) return null;
            throw new Exception('Invalid particulier property');
        }
        return $this->$method();
    }
 
    public function setNom($value) {
		$this->_nom = $value;
		return $this;
	}
    public function getNom() {
		return $this->_nom;
	}
 
    public function setPrenom($value) {
		$this->_prenom = $value;
		return $this;
	}
    public function getPrenom() {
		return $this->_prenom;
	}
 
    public function setCivilite($value) {
		$this->_civilite = ($value == '')?null:$value;
		return $this;
	}
    public function getCivilite() {
		return $this->_civilite;
	}

	public function getValues() {
		return array(
				'id' 		=> $this->_id,
				'reference' => $this->_reference,
				'mail' 		=> $this->_mail,
				'telfixe' 	=> Application_Extension_StaticLib::formaterTelephone($this->_tel_fixe),
				'fax' 		=> Application_Extension_StaticLib::formaterTelephone($this->_fax),
				'telport' 	=> Application_Extension_StaticLib::formaterTelephone($this->_tel_port),
				'civilite' 	=> $this->_civilite,
				'nom' 		=> $this->_nom,
				'prenom' 	=> $this->_prenom
		);
	}
}

