<?php

class Application_Model_Tiers
{
	protected $_reference;
	protected $_tel_fixe;
    protected $_fax;
    protected $_tel_port;
    protected $_mail;
    protected $_id;
    protected $_nom_complet;
    protected $_type;
 
    public function __construct(array $options = null) {
    	if (is_array($options)) {
    		foreach ($options as $nom => $val) {
    			try {
    				$this->__set($nom, $val);
    			} catch (Exception $e) {
    			}
    		}
    	}
    }
    
    public function __set($name, $value)
    {
        $method = 'set' . $name;
        if (('mapper' == $name) || !method_exists($this, $method)) {
            throw new Exception('Invalid tiers property');
        }
        $this->$method($value);
    }
 
    public function __get($name)
    {
        $method = 'get' . $name;
        if (('mapper' == $name) || !method_exists($this, $method)) {
            throw new Exception('Invalid tiers property');
        }
        return $this->$method();
    }
 
    public function setReference($value) {
		$this->_reference = $value;
		return $this;
	}
    public function getReference() {
		return $this->_reference;
	}
 
    public function setTelFixe($value) {
		$this->_tel_fixe = $value;
		return $this;
	}
    public function getTelFixe() {
		return Application_Extension_StaticLib::formaterTelephone($this->_tel_fixe);
	}
 
    public function setFax($value) {
		$this->_fax = $value;
		return $this;
	}
    public function getFax() {
		return Application_Extension_StaticLib::formaterTelephone($this->_fax);
	}
 
    public function setTelPort($value) {
		$this->_tel_port = $value;
		return $this;
	}
    public function getTelPort() {
		return Application_Extension_StaticLib::formaterTelephone($this->_tel_port);
	}
 
    public function setMail($value) {
		$this->_mail = $value;
		return $this;
	}
    public function getMail() {
		return $this->_mail;
	}
 
    public function setId($id) {
		$this->_id = $id;
		return $this;
	}
    public function getId() {
		return $this->_id;
	}
    
    public function setNomComplet($value) {
		$this->_nom_complet = $value;
		return $this;
	}
    public function getNomComplet() {
		return $this->_nom_complet;
	}
    
    public function setType($value) {
		$this->_type = $value;
		return $this;
	}
    public function getType() {
		return $this->_type;
	}
}

