<?php
if (!defined("PROPRIETAIRE")) define("PROPRIETAIRE", Zend_Auth::getInstance()->getStorage()->read()->id);

class Application_Model_TiersMapper
{
	protected $_dbTable;
 
    public function setDbTable($dbTable)
    {
        if (is_string($dbTable)) {
            $dbTable = new $dbTable();
        }
        if (!$dbTable instanceof Zend_Db_Table_Abstract) {
            throw new Exception('Invalid table data gateway provided');
        }
        $this->_dbTable = $dbTable;
        return $this;
    }
 
    public function getDbTable()
    {
        if (null === $this->_dbTable) {
            $this->setDbTable('Application_Model_DbTable_Tiers');
        }
        return $this->_dbTable;
    }
    
    public function existsReference($reference, $self = null) {
    	$row = $this->getDbTable()->getAdapter()->select()
    											->from('tiers')
    											->join('contact','contact.idtiers = tiers.id')
    											->where("reference = ?", $reference)
    											->where("contact.idexpediteur = ?", PROPRIETAIRE);
    	if ($self !== null) $row->where("id <> ?", $self);
    	$row = $row->query()->fetch(Zend_Db::FETCH_OBJ);
    	return (boolean) $row;
    }
    
    /**
     * @todo ne représente pas du tout le comportement souhaité
     * @param Application_Model_Entreprise $tiers
     */
    public function updateEntreprise(Application_Model_Entreprise $tiers) {
    	if (!$this->existsReference($tiers->getReference(), $tiers->getId())) { // la référence n'existe pas pour cet expéditeur
	    	$data = array(
	    			array(), 	// START TRANSACTION
	    			array(		// UPDATE tiers
	    					':ref'   => $tiers->getReference(),
	    					':fix' => str_replace(array("."," ","-"), "", $tiers->getTelFixe()),
	    					':fax' => str_replace(array("."," ","-"), "", $tiers->getFax()),
	    					':port' => str_replace(array("."," ","-"), "", $tiers->getTelPort()),
	    					':mail' => $tiers->getMail(),
	    					':id'	=> $tiers->getId()
	    			),
	    			array(		// UPDATE entreprise
	    					':rais' => $tiers->getRaison(),
	    					':stat' => $tiers->getStatut(),
	    					':siren' => $tiers->getSiren(),
	    					':id'	=> $tiers->getId()
	    			),
	    			array() 	// COMMIT
	    	);
	    	$sql = 	array(
	    			"START TRANSACTION;",
	    			"UPDATE tiers SET (reference, telfixe, fax, telport, mail) = (:ref,NULLIF(:fix,''),NULLIF(:fax,''),NULLIF(:port,''),:mail) WHERE id = :id;",
	    			"UPDATE entreprise SET (raisonsociale, statut, siren) = (:rais,NULLIF(:stat,'')::statut,:siren) WHERE idcontact = :id;",
	    			"COMMIT;"
	    	);
	    	foreach ($sql as $num => $line) {
	    		$stmt = new Zend_Db_Statement_Pdo($this->getDbTable()->getAdapter(), $line);
	    		$stmt->execute($data[$num]);
	    	}
    		return true;
    	} else {
    		return false;
    	}
    }
    
    public function saveEntreprise(Application_Model_Entreprise $tiers)
    {
    	$data = array(
    			array(), 	// START TRANSACTION
    			array(		// INSERT tiers
    					':ref'   => $tiers->getReference(),
    					':fix' => str_replace(array("."," ","-"), "", $tiers->getTelFixe()),
    					':fax' => str_replace(array("."," ","-"), "", $tiers->getFax()),
    					':port' => str_replace(array("."," ","-"), "", $tiers->getTelPort()),
    					':mail' => $tiers->getMail()
    			),
    			array(		// INSERT contact
    					':prop' => PROPRIETAIRE
    			),
    			array(		// INSERT entreprise
    					':rais' => $tiers->getRaison(),
    					':stat' => $tiers->getStatut(),
    					':siren' => $tiers->getSiren()
    			),
    			array() 	// COMMIT
    	);
    	$returns = array(false, true, false, false, false);
    	$sql = 	array(
    			"START TRANSACTION;",
    			"INSERT INTO tiers(reference, telfixe, fax, telport, mail) VALUES (:ref,NULLIF(:fix,''),NULLIF(:fax,''),NULLIF(:port,''),:mail) RETURNING id;",
    			"INSERT INTO contact(idtiers, idexpediteur) VALUES (currval('cle_tiers'), :prop);",
    			"INSERT INTO entreprise(idcontact, raisonsociale, statut, siren) VALUES (currval('cle_tiers'),:rais,NULLIF(:stat,'')::statut,:siren);",
    			"COMMIT;"
    	);
    	foreach ($sql as $num => $line) {
    		$stmt = new Zend_Db_Statement_Pdo($this->getDbTable()->getAdapter(), $line);
    		$stmt->execute($data[$num]);
    		if ($returns[$num]) {
    			$id = $stmt->fetch(Zend_Db::FETCH_OBJ)->id;
    		}
    	}
    	return $id;
    }
    
    public function updateParticulier(Application_Model_Particulier $tiers) {
    	if (!$this->existsReference($tiers->getReference(), $tiers->getId())) {
    	$data = array(
	    			array(), 	// START TRANSACTION
	    			array(		// UPDATE tiers
	    					':ref'   => $tiers->getReference(),
	    					':fix' => str_replace(array("."," ","-"), "", $tiers->getTelFixe()),
	    					':fax' => str_replace(array("."," ","-"), "", $tiers->getFax()),
	    					':port' => str_replace(array("."," ","-"), "", $tiers->getTelPort()),
	    					':mail' => $tiers->getMail(),
	    					':id'	=> $tiers->getId()
	    			),
	    			array(		// UPDATE particulier
	    					':nom' => $tiers->getNom(),
	    					':pre' => $tiers->getPrenom(),
	    					':civ' => $tiers->getCivilite(),
	    					':id'	=> $tiers->getId()
	    			),
	    			array() 	// COMMIT
	    	);
	    	$sql = 	array(
	    			"START TRANSACTION;",
	    			"UPDATE tiers SET (reference, telfixe, fax, telport, mail) = (:ref,NULLIF(:fix,''),NULLIF(:fax,''),NULLIF(:port,''),:mail) WHERE id = :id;",
	    			"UPDATE particulier SET (nom, prenom, civilite) = (:nom,:pre,:civ) WHERE idcontact = :id;",
	    			"COMMIT;"
	    	);
	    	foreach ($sql as $num => $line) {
	    		$stmt = new Zend_Db_Statement_Pdo($this->getDbTable()->getAdapter(), $line);
	    		$stmt->execute($data[$num]);
	    	}
    		return true;
    	} else {
    		return false;
    	}
    }
    
    public function saveParticulier(Application_Model_Particulier $tiers)
    {
    	$data = array(
    			array(), 	// START TRANSACTION
    			array(		// INSERT tiers
    					':ref'   => $tiers->getReference(),
    					':fix' => str_replace(array("."," ","-"), "", $tiers->getTelFixe()),
    					':fax' => str_replace(array("."," ","-"), "", $tiers->getFax()),
    					':port' => str_replace(array("."," ","-"), "", $tiers->getTelPort()),
    					':mail' => $tiers->getMail()
    			),
    			array(
    					':prop' => PROPRIETAIRE
    			),
    			array(		// INSERT particulier
    					':civ' => $tiers->getCivilite(),
    					':nom' => $tiers->getNom(),
    					':pnom' => $tiers->getPrenom()
    			),
    			array() 	// COMMIT
    	);
    	$returns = array(false, true, false, false, false);
    	$sql = 	array(
    			"START TRANSACTION;",
    			"INSERT INTO tiers(reference, telfixe, fax, telport, mail) VALUES (:ref,NULLIF(:fix,''),NULLIF(:fax,''),NULLIF(:port,''),:mail) RETURNING id;",
    			"INSERT INTO contact(idtiers, idexpediteur) VALUES (currval('cle_tiers'), :prop);",
    			"INSERT INTO particulier(idcontact, civilite, nom, prenom) VALUES (currval('cle_tiers'),:civ,:nom,:pnom);",
    			"COMMIT;"
    	);
    	foreach ($sql as $num => $line) {
    		$stmt = new Zend_Db_Statement_Pdo($this->getDbTable()->getAdapter(), $line);
    		$stmt->execute($data[$num]);
    		if ($returns[$num]) {
    			$id = $stmt->fetch(Zend_Db::FETCH_OBJ)->id;
    		}
    	}
    	return $id;
    }
 	
    public function delete($id) {
    	$stmt = new Zend_Db_Statement_Pdo($this->getDbTable()->getAdapter(), "DELETE FROM tiers WHERE id = :id AND id IN (SELECT idtiers FROM contact WHERE idexpediteur = :prop);");
    	$stmt->execute(array(":id" => $id, ":prop" => PROPRIETAIRE));
    }
    
    public function find($id, Application_Model_Tiers $tiers)
    {
    	$row = $this->getDbTable()->getAdapter()->select()->from('vuecarnet')->where("id = ?", $id)->where("idexpediteur = ?", PROPRIETAIRE)->query()->fetch(Zend_Db::FETCH_OBJ);
        if (0 == count($row)) {
            return;
        }
        $tiers->setId($row->id)
              ->setReference($row->reference)
              ->setNomComplet($row->nomcomplet)
              ->setType($row->type)
        	  ->setTelFixe($row->telfixe)
        	  ->setFax($row->fax)
        	  ->setTelPort($row->telport)
        	  ->setMail($row->mail);
    }
 
	public function findEntreprise($id, Application_Model_Entreprise $entreprise)
	{
		$row = $this->getDbTable()->getAdapter()->select()->from('vuecarnet')->where("id = ?", $id)->where("idexpediteur = ?", PROPRIETAIRE)->query()->fetch(Zend_Db::FETCH_OBJ);
		if (0 == count($row)) {
			return;
		}
		$entreprise->setId($row->id)
				   ->setReference($row->reference)
				   ->setTelFixe($row->telfixe)
				   ->setFax($row->fax)
				   ->setTelPort($row->telport)
				   ->setMail($row->mail)
				   ->setRaison($row->raisonsociale)
				   ->setStatut($row->statut)
				   ->setSiren($row->siren);	   
	}
	
	public function findParticulier($id, Application_Model_Particulier $particulier)
	{
		$row = $this->getDbTable()->getAdapter()->select()->from('vuecarnet')->where("id = ?", $id)->where("idexpediteur = ?", PROPRIETAIRE)->query()->fetch(Zend_Db::FETCH_OBJ);
		if (0 == count($row)) {
			return;
		}
		$particulier->setId($row->id)
					->setReference($row->reference)
					->setTelFixe($row->telfixe)
					->setFax($row->fax)
					->setTelPort($row->telport)
					->setMail($row->mail)
					->setCivilite($row->civilite)
					->setNom($row->nom)
					->setPrenom($row->prenom);	
	}
	
	public function findType($id) {
		$row = $this->getDbTable()->getAdapter()->select()->from('vuecarnet','type')->where("id = ?", $id)->query()->fetch(Zend_Db::FETCH_OBJ);
		return ($row)?$row->type:false;
	}
    
    /**
     * Récupère les tiers d'un expéditeur pour le formulaire de LV
     * @return array(id => reference)
     */
    public function fetchAllAsList() {
    	$resultSet = $this->getDbTable()->getAdapter()->select()
    												  ->from('vuecarnet',array('id','reference'))
    												  ->where("idexpediteur = ?", PROPRIETAIRE)
    												  ->order('reference')
    												  ->query()
    												  ->fetchAll(Zend_Db::FETCH_OBJ);
    	$entries = array();
    	foreach ($resultSet as $row) {
    		$entries[$row->id] = $row->reference;
    	}
    	return $entries;
    }
    
    /**
     * Renvoie la liste des valeurs d'une énumération SQL, sous forme de tableau associatif dont les clés sont les valeurs.
     * Si le paramètre null est à true, le tableau contiendra une clé "non renseigné(e)" de valeur vide en première position.
     * @param string $name
     * @param bool $null
     */
    public function getEnumValues($name, $null = false) {
    	$result = $this->getDbTable()->getAdapter()->query("SELECT enum_range(null::$name) AS vals;")->fetchAll(Zend_Db::FETCH_OBJ);
    	$num = $result[0]->vals; // donne un résultat du type {val,val,val,val,...}
    	$num = explode(",", substr($num,1,-1)); // transforme en tableau de sous-chaînes, la chaîne récupérée
    	$assoc = array();
    	if ($null) {
    		$assoc[''] = "inconnu";
    	}
    	foreach ($num as $val) {
    		$assoc[$val] = $val;
    	}
    	//return array("Test" => "Test", "Remi" => "Remi", "Num" => $num);
    	return $assoc;
    }
    
}

