<?php

class Application_Plugin_Pdf {
	
	private $_pdf = null;
	
	private $_actions = array(
		"Rectangle" 		=> "draw",
		"Circle"			=> "draw",
		"Text"				=> "draw",
		"Ellipse"			=> "draw",
		"Line"				=> "draw",
		"Polygon"			=> "draw",
		"RoundedRectangle"	=> "draw",
		"Page"				=> "append",
		"Style"				=> "create"
	);
	
	private $_options = array(
		"Rectangle"			=> array("x","y","largeur","hauteur"),
		"Circle"			=> array("x","y","rayon"),
		"Text"				=> array("x","y","texte","encodage"),
		"Ellipse"			=> array("x","y","largeur","hauteur"),
		"Line"				=> array("x1","y1","x2","y2"),
		"Polygon"			=> array("x","y"),
		"RoundedRectangle"	=> array("x","y","largeur","hauteur","rayon"),
		"Page"				=> array("largeur","hauteur"),
		"Style"				=> array("fillColor","lineColor","font","lineWidth")
	);
	
	public function __construct() {
		$this->_pdf = new Zend_Pdf();
	}
	
	public function execute(array $ordres = null) {
		foreach ($ordres as $ordre) {
			$this->action($ordre['action'], $ordre['options']);
		}
	}
	
	private function action(string $type, array $options) {
		if ($type === null) throw new Exception("Action non reconnue, consultez la doc pour plus de détail");
		
		if (!isset($this->_actions[$type])) throw new Exception("Action non reconnue, consultez la doc pour plus de détail");
		
		foreach($this->_options[$type] as $option) {
			if (!isset($options[$option])) throw new Exception("Paramètre ".$option." manquant pour l'action ".$type);
		}
		
		
	}
	
	private function __call($methode, $params) {
	}
}