<?php

class Application_Plugin_Splitter {
	
	private $bits = array();
	private $separator = "";
	private $iterator = -1;
	private $last = 0;
	
	public function __construct($string, $separator, $length) {
		
		$this->separator = $separator;
		
		$this->bits = str_split($string, $length-1);
		
		$this->last = count($this->bits) - 1;
		
		
		if ($this->last > 0) {
			if (strlen($this->bits[$this->last]) == 1) {
				$this->bits[$this->last - 1] .= $this->bits[$this->last];
				unset($this->bits[$this->last--]);
			}
		}
	}
	
	public function __toString() {
		$this->iterator = $this->iterator + 1;
		if ($this->iterator < $this->last) {
			$return = $this->bits[$this->iterator].$this->separator;
		} elseif ($this->iterator == $this->last) {
			$return = $this->bits[$this->iterator];
		} else {
			$return = "";
		}
		return $return;
	}
}