<?php

class Application_Validate_Tiers extends Zend_Validate_Abstract {
	// cette classe vérifie la validité du formulaire envoyé
	const TEL = 'aucun téléphone';
	
	protected $_messageTemplates = array(
		self::TEL => "Un contact doit contenir au moins un numéro de téléphone"	
	);
	
	public function isValid($form) {
		if (!$form instanceof Application_Form_Tiers) {
			throw new Exception("Ce validateur ne fonctionne qu'avec un formulaire de contact de type Application_Form_Tiers");
		}
		
		$ne = new Zend_Validate_NotEmpty();
		$return = true;
		
		if (!$ne->isValid($form->getValue('telfixe')) && !$ne->isValid($form->getValue('telfax')) && !$ne->isValid($form->getValue('telport'))) {
			$this->_error(self::TEL);
			$return = false;
		}
		
		return $return;
	}
}