/**
 * Fichier partiel adresse.js
 * @author Jean Pruliere
 */

function replug() {
	$("input.adresse-updater").change(function() {
		var set = "destinataire_adresse";
		var id = $(this).attr("id");
		$(this).siblings('label').removeClass('adresse-dest-selected');
		$("label#label-"+id).addClass('adresse-dest-selected');
	});
	$("input.adresse-updater").eq(0).click();
}

String.prototype.ucfirst = function() {
	return this.charAt(0).toUpperCase() + this.substr(1);
};

$(document).ready(function() {
	
	// pour retirer les noms de champ vides
	$('dt').each(function() {
		if ($(this).html() == "&nbsp;") $(this).remove();
	});
	
	// pour formulaire et sous-formulaire d'adresse
	$("input.ville").replaceWith(function() {
		return $('<select name="'+$(this).attr('name')+'" id="'+$(this).attr('id')+'" class="'+$(this).attr('class')+'"><option>'+$(this).val()+'</option></select>').data("lval",$(this).val());
	});
	$("select.ville").attr("disabled","disabled");
	$("button.aide").click(function() {
		var pays = $("select.pays option:selected").val();
		var prefix = $(this).attr('id').slice(0,-4);
		var ville = prompt("Quelle ville cherchez-vous ?","Tapez ici le nom de la ville recherchée");
		if (ville != null) {
			$.get(
				"/ajax/codepostal/ville/"+ville+":"+pays,
				{},
				function(data2) {
					for (key in data2) {
						$("button#"+prefix+"aide").data("ville", key);
						$("input#"+prefix+"codepostal").val(data2[key]).change();
					}
				},
				"json"
			);
		}
		return false;
	});
	$("input.code").change(function() {
		var pays = $("select.pays option:selected").val();
		var prefix = $(this).attr('id').slice(0,-10);
		$.get(
			"/ajax/ville/codepostal/"+$(this).val()+":"+pays,
			{},
			function(data) {
				// gestion de la ville lors de l'enregistrement des adresses ponctuelles
				if (!$("#"+prefix+"ville").data("lval")) {
					$("#"+prefix+"ville").data("lval",$("#"+prefix+"ville").val());
				}
				$("#"+prefix+"ville").empty();
				// affichage de la liste des villes
				if (data != null) {
					$.each(data, function (key, value) {
						$("#"+prefix+"ville").append($('<option>', {value:value}).text(value));
					});
					$("#"+prefix+"ville").removeAttr("disabled");
				} else {
					$("#"+prefix+"ville").append($('<option>', {value:"nomatch"}).text("AUCUNE VILLE POUR CE CODE POSTAL"));
				}
				// gestion de la ville lors de l'enregistrement des adresses ponctuelles
				if (jQuery.inArray($("#"+prefix+"ville").data("lval"), data) != -1) {
					$("#"+prefix+"ville").val($("#"+prefix+"ville").data("lval"));
					$("#"+prefix+"ville").removeData("lval");
				}else{
					// si non, selection de la première ville
					$("#"+prefix+"ville").children(":first").eq(0).prop( "selected", true );
				}
				if ($("button#"+prefix+"aide").data("ville")) {
					$("#"+prefix+"ville").val($("button#"+prefix+"aide").data("ville").toUpperCase().replace(/( |')/gi,"-"));
				}
			},
			"json"
		);
	});
	
	$("input.code").each(function() {
		if ($(this).val().length > 0) {
			$(this).change();
		}
	});
	
	$(".tiers-updater").change(function() {
		var tiers = $(this).val();
		if (tiers != "otf")
			$.get(
				"/ajax/adresses/id/"+tiers,
				{},
				function(data) {
					$("#adresses_legend:hidden,#adresses_end:hidden").fadeIn();
					$("#adresses_group:hidden").slideDown();
					$("#adresses_group *").remove();
					$("#adresses_group").append(data);
					replug(); // le contenu inséré est réabonné
					$("#adresse-dest-"+$(".rhi-adresse").val()).click();
					$(".rhi-adresse").remove();
				},
				"html"
			);
	}).filter(":checked").click(); // pour le rhi
	
	$("select.pays").change(function(){ 
		$("input.code").val(''); 
		$("select.ville").empty();
	});
	
	$("#destinataire-selection-value").focus();
	$("select#idflux").focus();
});