/**
 * Fichier partiel ecombo.js
 * @author Jean Pruliere
 */

String.prototype.startsWith = function(str) {
	s = str.toLowerCase();
	t = this.toLowerCase();
	for (var i = 0; i < s.length; i++) {
		if (t.charAt(i) != s.charAt(i)) return false;
	}
	return true;
};

$(document).ready(function() {
	// 1 remplacement
	$("select.lgf-editable-combo").replaceWith(function() {
		var name = $(this).attr("name");
		var classes = $(this).attr("class").split(" ");
		var maxlength = $(this).attr("maxlength"); // Zend passe l'attribut même s'il est invalide
		maxlength = (maxlength != undefined)?'maxlength="'+maxlength+'" ':"";
		var radioclass = name.replace(/[[\]]/g,"-")+"-option";
		$.each(classes, function(i, _class) {
			if (_class == "lgf-editable-combo") {
				classes.splice(i,1);
				return false;
			}
		});
		classes.push(radioclass);
		var id = name.replace(/[[\]]/g,"-") + "-edition";
		var opts = $(this).children(); // les options du select
		/* on crée le support de remplacement :
		* - une div contenant
		*   - un radio qui permet de sélectionner l'option "nouvelle valeur"
		*   - un input qui permet de saisir la nouvelle valeur ou d'en rechercher une existante
		*   - une ul qui contient les valeurs des options
		*/
		var combo = $('<div class="lgf-ecombo" id="'+id+'"><input type="radio" id="'+id+'-new-value" class="'+radioclass+'" value="" /><input type="text" class="lgf-ecombo-value" name="'+name+'" id="'+id+'-value" '+maxlength+'/><ul class="lgf-ecombo-values" id="'+id+'-values"></ul></div>');
		var iterator = 0;
		opts.each(function() { // pour chaque option
			var value = $(this).val(); // on récupère la valeur
			var text = $(this).text();
			var elmid = id + "-" + iterator++;
			var checked = "";
			if ($(this).val() == "lgf-new-value") {
				combo.find("#"+id+"-value").val($(this).text());
				combo.children("#"+id+"-new-value").attr("checked","checked").val($(this).text());
				return true; // continue
			}
			if ($(this).prop("selected")) {
				checked = 'checked="checked" ';
				combo.find("#"+id+"-value").val($(this).val());
				combo.children("#"+id+"-new-value").val($(this).text());
			}
			var cls = "";
			if (classes.length > 0) {
				cls = ' class="'+classes.join(" ")+'"';
			}
			// pis on crée le couple radio-label dans une li
			combo.children("ul.lgf-ecombo-values").append('<li><input type="radio" id="'+elmid+'"'+cls+' value="'+value+'" '+checked+'/><label for="'+elmid+'">'+text+'</label></li>');
			if ($(this).prop("selected")) {
				combo.children("ul.lgf-ecombo").children('li').last().children('input').click();
			}
		});
					
		return combo;
	});

	// 2 sauvegarde des valeurs
	$('.lgf-ecombo-value').each(function() {
		$(this).data("pval", $(this).val()); // valeur précédente du champ, pour traiter les saisies clavier
	});

	// 3 saisie
	$('.lgf-ecombo-value').keyup(function(e) {
		var input = $(this);
		var ulid = input.attr("id").substring(0,input.attr("id").length-6)+"-values";
		var hid = input.attr("id").substring(0,input.attr("id").length-6)+"-new-value";

		$("."+$("#"+hid).attr("class")).removeAttr("checked");
		$("#"+ulid).children('li').removeClass('lgf-ecombo-value-selected');
		var len = input.val().length;
		if (input.data("pval") == input.val() || len == 0) { // cas d'une touche muette (ex: alt, ctrl, tab)
			return false; // on arrête là
		}
		if (e.keyCode == 8) { // cas de la touche retour arrière (bsp)
			if (input.prop("selectionEnd") != input.prop("selectionStart")) { // propriété DOM définissant le caret
				/* lorsqu'une partie du texte est sélectionnée, bsp retire cette sélection.
				* le comportement souhaité ici est que la dernière lettre tapée soit retirée, la sélection ne faisant que proposer une auto-complétion 
				*/
				input.val(input.val().slice(0,-1)); // on implémente manuellement le comportement de la touche
			}
			input.data("pval",input.val());
			// s'il n'y a pas de caret, le comportement normal est déclenché
			$("#"+hid).attr("checked","checked").val($(this).val());
			return false; // on ne repropose pas d'auto-complétion
		}
		var match = false;
		$("#"+ulid+" label").each(function() {
			if ($(this).text().startsWith(input.val()) && !match) {
				$("#"+$(this).attr("for")).attr("checked","checked").click();
				if (document.selection) { // ie
					var tr = input.get(0).createTextRange();
					tr.moveStart('character', len);
					tr.moveEnd('character', $(this).text().length);
					tr.select();
				} else { // navigateur standard
					input.prop("selectionStart",len);
					input.prop("selectionEnd",$(this).text().length);
				}
				var ul = $(this).parents('ul').first();
				var li = $(this).parent('li');
				ul.scrollTop(li.prop("offsetTop") - ul.prop("clientHeight")/2 + li.prop("clientHeight")/2);
				li.addClass('lgf-ecombo-value-selected');
				input.data("pval",input.val());
				match = true;
			} else {
				$("#"+$(this).attr("for")).removeAttr("checked");
			}
		});
		if (!match) {
			$("#"+hid).attr("checked","checked");
		}
		$("#"+hid).val($(this).val());
		input.data("pval",input.val());
	});

	// 4 changement
	$("ul.lgf-ecombo-values input[type=radio]").change(function() {
		var ulid = $(this).parents('ul').attr("id"); // *-values
		var inputid = ulid.substring(0,ulid.length-1); // *-value
		$("."+$(this).attr("class")).removeAttr("checked");
		$(this).attr("checked","checked");
		$("#"+inputid).val($(this).siblings('label').text());
		$(this).parents('ul').children('li').removeClass('lgf-ecombo-value-selected');
		$(this).parent().addClass('lgf-ecombo-value-selected');
	});

	// 5 sélection
	$("ul.lgf-ecombo-values li").click(function() {
		$(this).children("input[type=radio]").change();
	});
});