/**
 * Fichier partiel filtres.js
 * @author Jean Pruliere
 */

function formatDateAsISO(dateFR){
	console.log("formatDateAsISO",dateFR);
	const regex = /([0-9]{1,2})\/([0-9]{1,2})\/([0-9]{2,4})/
	function regexResultToISO(full,day,month,year){
		console.log("regexResultToISO",arguments);
		return String(year).padStart(2, '0') + "-" +
				String(month).padStart(2, '0') + "-" +
				String(day).padStart(2, '0')
	}
	return dateFR.replace(regex,regexResultToISO);
}

$(document).ready(function() {
	$("#search-filters").submit(function() {
		var location = $(this).attr("action") + "/filtrer";
		if ($("#filter-place").length) {
			location += "/" + $("#filter-champ").val() + "/" + $("#filter-place").val() + "/" + $("#filter-pattern").val();
		}
		if ($("#filter-du").length) {

			location += "/les_lv/du/" + formatDateAsISO($("#filter-du").val())
					+ "/au/" + formatDateAsISO($("#filter-au").val());
		}
		if ($("#filter-ids-parnom").is(':checked'))
			location += "/nomclient/" + $("#filter-nomclient").val();
		else
			location += "/refclient/" + $("#filter-refclient").val();
		location += "/flux/" + $("#filter-flux").val();
		window.location.replace(location);
		return false;
	});
	
	$("#filter-ids-parnom").change(function() {
		$(".filter-ids-nom").show();
		$(".filter-ids-ref").hide();
	});
	
	$("#filter-ids-parref").change(function() {
		$(".filter-ids-ref").show();
		$(".filter-ids-nom").hide();
	});
	
	$("#search-fields").submit(function() {
		if ($("#fields-reference").length == 0) return false;
		window.location.replace($(this).attr("action") + "/reference/" + encodeURIComponent($("#fields-reference").val()));
		return false;
	});
});